/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Components;

import android.view.View;
import android.view.ViewGroup;
import com.nanorep.nanoclient.Response.NRConfiguration;
import nanorep.nanowidget.Components.AbstractViews.NRCustomContentView;
import nanorep.nanowidget.Components.NRResultItem;
import nanorep.nanowidget.DataClasse.NRResult;
import nanorep.nanowidget.Utilities.Calculate;
import nanorep.nanowidget.interfaces.NRResultItemListener;

public class NRContentItem
extends NRResultItem {
    private NRCustomContentView contentView;
    private int mMaxHeight;

    public void setmMaxHeight(int mMaxHeight) {
        this.mMaxHeight = mMaxHeight;
    }

    public NRContentItem(View view, NRResultItemListener listener, NRConfiguration config, NRCustomContentView contentView) {
        super(view, listener);
        this.contentView = contentView;
        this.contentView.setListener(this.mListener);
    }

    @Override
    protected void configViewObjects(NRConfiguration config) {
    }

    @Override
    protected void bindViews(View view) {
    }

    public void setBody(String body) {
        this.mResult.getFetchedResult().setBody(body);
        this.contentView.loadData(body, "text/html", "UTF-8");
    }

    @Override
    public void resetBody() {
        this.contentView.loadUrl("about:blank");
    }

    @Override
    public void setData(NRResult result) {
        this.mResult = result;
        this.calculateItemViewHeight();
        if (this.mResult.getFetchedResult().getBody() != null) {
            this.setBody(this.mResult.getFetchedResult().getBody());
        } else {
            this.mListener.fetchBodyForResult(this, this.mResult.getFetchedResult().getId(), this.mResult.getFetchedResult().getHash());
        }
    }

    private void calculateItemViewHeight() {
        int delta = 50;
        if (this.mResult.getFetchedResult().getChanneling() != null) {
            delta += 50;
        }
        ViewGroup.LayoutParams lp = this.contentView.getLayoutParams();
        lp.height = this.mMaxHeight - (int)Calculate.pxFromDp(this.itemView.getContext(), delta);
        this.contentView.setLayoutParams(lp);
    }
}

