/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.DataClasse;

import android.animation.ValueAnimator;
import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import java.util.ArrayList;
import java.util.List;
import nanorep.nanowidget.Components.AbstractViews.NRCustomTitleView;
import nanorep.nanowidget.Components.NRTitleView;
import nanorep.nanowidget.DataClasse.NRResult;
import nanorep.nanowidget.R;
import nanorep.nanowidget.interfaces.CRUDAdapterInterface;
import nanorep.nanowidget.interfaces.NRCustomViewAdapter;
import nanorep.nanowidget.interfaces.NRTitleListener;

public class NRResultsAdapter
extends RecyclerView.Adapter<ViewHolder>
implements CRUDAdapterInterface<NRResult> {
    private ArrayList<NRResult> results = new ArrayList();
    private NRCustomViewAdapter viewAdapter;
    private Listener listener;

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        Context context = parent.getContext();
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.title_item, parent, false);
        NRCustomTitleView titleView = this.viewAdapter.getTitle(context);
        if (titleView == null) {
            titleView = new NRTitleView(context);
        }
        LinearLayout titleContainer = (LinearLayout)view.findViewById(R.id.title_container);
        titleContainer.addView((View)titleView);
        return new ViewHolder(view, titleView, titleContainer);
    }

    public void onBindViewHolder(ViewHolder holder, int position) {
        NRResult result = this.getItem(position);
        holder.titleView.setTitleText(result.getFetchedResult().getTitle());
        holder.setHeight(result.getHeight());
        holder.setResult(result);
        holder.titleView.setListener(holder);
    }

    public int getItemCount() {
        return this.results.size();
    }

    @Override
    public NRResult getItem(int position) {
        return this.results.get(position);
    }

    @Override
    public void addItem(NRResult item) {
    }

    @Override
    public void removeItem(NRResult item) {
    }

    @Override
    public void addItems(List<NRResult> items) {
        if (items == null) {
            return;
        }
        this.results.addAll(items);
        this.notifyDataSetChanged();
    }

    @Override
    public void clearList() {
    }

    @Override
    public void updateItem(int pos, NRResult item) {
    }

    @Override
    public void showItem(NRResult result, int itemPosition) {
    }

    @Override
    public List<NRResult> getItems() {
        return null;
    }

    @Override
    public void removeItem(int currentItemPosition) {
    }

    public void setViewAdapter(NRCustomViewAdapter viewAdapter) {
        this.viewAdapter = viewAdapter;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder
    implements NRTitleListener {
        private NRCustomTitleView titleView;
        private LinearLayout title_container;
        private View view;
        private NRResult result;

        public ViewHolder(View view, NRCustomTitleView titleView, LinearLayout titleContainer) {
            super(view);
            this.titleView = titleView;
            this.title_container = titleContainer;
            this.view = view;
        }

        private void setHeight(int height) {
            ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{this.view.getHeight(), height});
            animator.setDuration(300L);
            animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    ((ViewHolder)ViewHolder.this).titleView.getLayoutParams().height = (Integer)animation.getAnimatedValue();
                    ((ViewHolder)ViewHolder.this).view.getLayoutParams().height = (Integer)animation.getAnimatedValue();
                    ViewHolder.this.view.requestLayout();
                }
            });
            animator.start();
        }

        public void setResult(NRResult result) {
            this.result = result;
        }

        public NRResult getResult() {
            return this.result;
        }

        public NRCustomTitleView getTitleView() {
            return this.titleView;
        }

        public LinearLayout getTitle_container() {
            return this.title_container;
        }

        @Override
        public void onTitleClicked() {
            NRResultsAdapter.this.listener.onResultItemSelected(this, this.getAdapterPosition());
        }

        @Override
        public void onTitleCollapsed(int height) {
        }

        @Override
        public void onShareClicked() {
        }
    }

    public static interface Listener {
        public void onResultItemSelected(ViewHolder var1, int var2);
    }
}

