/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Components;

import android.content.Context;
import android.support.v4.content.ContextCompat;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomLikeView;
import nanorep.nanowidget.R;

public class NRLikeView
extends NRCustomLikeView {
    private TextView mLikeButton;
    private TextView mDislikeButton;
    private TextView likeText;
    private boolean mLikeSelection;

    public NRLikeView(Context context) {
        super(context);
        LayoutInflater.from((Context)context).inflate(R.layout.like_view, (ViewGroup)this);
    }

    @Override
    public void updateLikeButton(boolean isLike) {
        this.resetLikeView();
        if (isLike) {
            this.mLikeButton.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.nr_like_color));
            this.mDislikeButton.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.nr_text_color));
        } else {
            this.mLikeButton.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.nr_text_color));
            this.mDislikeButton.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.nr_dislike_color));
        }
        this.mLikeButton.setEnabled(false);
        this.mDislikeButton.setEnabled(false);
        this.mLikeSelection = isLike;
    }

    @Override
    public void resetLikeView() {
        this.mLikeButton.setEnabled(true);
        this.mDislikeButton.setEnabled(true);
        this.mLikeButton.setTextColor(this.getResources().getColor(R.color.nr_text_color));
        this.mDislikeButton.setTextColor(this.getResources().getColor(R.color.nr_text_color));
    }

    public void onViewAdded(View child) {
        super.onViewAdded(child);
        this.likeText = (TextView)child.findViewById(R.id.likeText);
        this.mLikeButton = (TextView)child.findViewById(R.id.likeButton);
        this.mDislikeButton = (TextView)child.findViewById(R.id.dislikeButton);
        this.mLikeButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                NRLikeView.this.sendSelection(true);
            }
        });
        this.mDislikeButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                NRLikeView.this.sendSelection(false);
            }
        });
    }

    private void sendSelection(boolean selection) {
        this.mLikeSelection = selection;
        this.updateLikeButton(this.mLikeSelection);
        this.mListener.onLikeClicked(this, null, this.mLikeSelection);
    }

    @Override
    public boolean getLikeSelection() {
        return this.mLikeSelection;
    }

    @Override
    public boolean shouldOpenDialog() {
        return true;
    }

    @Override
    public void updateText(String text) {
        this.likeText.setText((CharSequence)text);
    }
}

