package nanorep.nanowidget.Components;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.ImageButton;

import nanorep.nanowidget.Components.AbstractViews.NRCustomTitleView;
import nanorep.nanowidget.R;

/**
 * Created by noat on 04/12/2016.
 */

public class NRCTitleView extends NRCustomTitleView {

    private Button mTitleButton;
    private ImageButton shareButton;

    public NRCTitleView(Context context) {
        super(context);
        LayoutInflater.from(context).inflate(R.layout.nrc_title, this);
    }

    @Override
    public void setTitleText(String text) {
        mTitleButton.setText(text);

        mTitleButton.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                mListener.onTitleClicked();
            }
        });
    }

    @Override
    public void unfold(boolean closed) {

    }


    @Override
    public int getTitleHeight(String text) {
        return 0;
    }

    @Override
    public void resetView() {

    }

    @Override
    public void setTitleMaxLines(int lines) {

    }

    @Override
    public void onViewAdded(View child) {
        super.onViewAdded(child);

        mTitleButton = (Button) child.findViewById(R.id.titleButton);
        shareButton = (ImageButton) child.findViewById(R.id.shareButton);

        shareButton.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                mListener.onShareClicked();
            }
        });
    }
}
