package nanorep.nanowidget.Components;

import android.content.Context;
import android.graphics.Color;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.ImageView;

import nanorep.nanowidget.Components.AbstractViews.NRCustomNegativeFeedbackView;
import nanorep.nanowidget.R;

/**
 * Created by noat on 07/12/2016.
 */

public class NRCNegativeFeedbackView extends NRCustomNegativeFeedbackView implements TextWatcher {

    Button submitButton;
    EditText editText;
    ImageView closeButton;

    public NRCNegativeFeedbackView(Context context) {
        super(context);

        LayoutInflater.from(context).inflate(R.layout.negative_feedback_view, this);
    }

    @Override
    public void dismissKeyboard() {
        InputMethodManager imm = (InputMethodManager)getContext().getSystemService(Context.INPUT_METHOD_SERVICE);
        imm.hideSoftInputFromWindow(editText.getWindowToken(), 0);
    }

    @Override
    public void onViewAdded(View child) {
        super.onViewAdded(child);

        closeButton = (ImageView) child.findViewById(R.id.closeButton);
        closeButton.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                mListener.onClearClicked();
            }
        });

        submitButton = (Button) child.findViewById(R.id.submitButton);
        editText = (EditText) child.findViewById(R.id.editText);

        editText.addTextChangedListener(this);

        submitButton.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                mListener.onSubmitClicked(editText.getText().toString());
            }
        });
    }

    @Override
    public void beforeTextChanged(CharSequence s, int start, int count, int after) {

    }

    @Override
    public void onTextChanged(CharSequence s, int start, int before, int count) {
        setSubmitButton(s.length() == 0);
    }

    private void setSubmitButton(boolean textEmpty) {
        String backgroundColor = "#ffffff";
        String textColor = "#e1e1e1";
        if(!textEmpty) {
            backgroundColor = "#f9c844";
            textColor = "#ffffff";
        }

        submitButton.setBackgroundColor(Color.parseColor(backgroundColor));
        submitButton.setTextColor(Color.parseColor(textColor));
    }

    @Override
    public void afterTextChanged(Editable s) {

    }
}
