package nanorep.nanowidget.Components;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;

import com.nanorep.nanoclient.Channeling.NRChanneling;

import nanorep.nanowidget.Components.AbstractViews.NRCustomChannelView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomFeedbackView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomLikeView;
import nanorep.nanowidget.R;

/**
 * Created by noat on 07/12/2016.
 */

public class NRCFeedbackView extends NRCustomFeedbackView {

    private LinearLayout feedbackLayout;
    private LinearLayout negativeFeedbcakContainer;
    private LinearLayout likeChannelContainer;

    public NRCFeedbackView(Context context) {
        super(context);

        LayoutInflater.from(context).inflate(R.layout.nrc_feedback, this);
    }

    @Override
    public void onViewAdded(View child) {
        super.onViewAdded(child);

        feedbackLayout = (LinearLayout) child.findViewById(R.id.feedback_layout);
        likeChannelContainer = (LinearLayout) child.findViewById(R.id.likeChannelContainer);
        negativeFeedbcakContainer = (LinearLayout) child.findViewById(R.id.negativeFeedbcakContainer);
    }

    @Override
    public void addLikeView() {
        likeChannelContainer.addView(customLikeView);
    }

    @Override
    public void addChannelView() {
        likeChannelContainer.addView(customChannelView);
    }

    @Override
    public void addNegativeFeedbackView() {
        negativeFeedbcakContainer.addView(customNegativeFeedbackView);
    }

    @Override
    public void setCustomLikeView(NRCustomLikeView customLikeView) {
        super.setCustomLikeView(customLikeView);
        addLikeView();
    }

    @Override
    public void setCustomChannelView(NRCustomChannelView customChannelView) {
        super.setCustomChannelView(customChannelView);
        addChannelView();
    }

    @Override
    public void onChannelSelected(NRChanneling channeling) {
        mListener.onChannelSelected(channeling);
    }

    @Override
    public void onLikeClicked(NRCustomLikeView likeView, String resultId, boolean isLike) {
        if(!isLike){
            addNegativeFeedbackView();
        }
    }

    // negative listener methods
    @Override
    public void onSubmitClicked(String text) {
        mListener.onLikeClicked(customLikeView, null, false);
        customLikeView.updateText(getResources().getString(R.string.thank_you));
        customNegativeFeedbackView.dismissKeyboard();
        negativeFeedbcakContainer.removeAllViews();
    }

    @Override
    public void onClearClicked() {
        customNegativeFeedbackView.dismissKeyboard();
        negativeFeedbcakContainer.removeAllViews();
        customLikeView.resetLikeView();
    }
    //end negative listener methods
}
