package nanorep.nanowidget.Components;

import android.content.Context;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.nanorep.nanoclient.Channeling.NRChanneling;

import java.util.ArrayList;

import nanorep.nanowidget.Components.AbstractViews.NRCustomChannelView;
import nanorep.nanowidget.R;

/**
 * Created by noat on 04/12/2016.
 */

public class NRCChannelingView  extends NRCustomChannelView {

    private RecyclerView mChannelingsRecycleView;
    private ChannelingAdapter mAdapter;

    public NRCChannelingView(Context context) {
        super(context);

        mAdapter = new ChannelingAdapter();
        LayoutInflater.from(context).inflate(R.layout.channeling_view, this);
    }

    @Override
    public void onViewAdded(View child) {
        super.onViewAdded(child);
        mChannelingsRecycleView = (RecyclerView) child.findViewById(R.id.channelingTabs);
        mChannelingsRecycleView.setAdapter(mAdapter);
    }

    @Override
    public void setChannelings(ArrayList<NRChanneling> channelings) {
        mChannelings = channelings;
        mChannelingsRecycleView.setLayoutManager(new GridLayoutManager(this.getContext(), mChannelings.size()));
        mAdapter.notifyDataSetChanged();
    }

    @Override
    public void onChannelSelected(NRChanneling channeling) {
        mListener.onChannelSelected(channeling);
    }

    public class ChannelingAdapter extends RecyclerView.Adapter<NRChannelItem> {

        @Override
        public NRChannelItem onCreateViewHolder(ViewGroup parent, int viewType) {
            View view = LayoutInflater.from(parent.getContext()).inflate(R.layout.nrc_channel_item, parent, false);
            NRChannelItem item = new NRCChannelItem(view);
            item.setListener(NRCChannelingView.this);
            return item;
        }

        @Override
        public void onBindViewHolder(NRChannelItem holder, int position) {
            holder.setChanneling(mChannelings.get(position));
        }

        @Override
        public int getItemCount() {
            if (mChannelings != null) {
                return mChannelings.size();
            }
            return 0;
        }
    }
}
