package nanorep.nanowidget.Components;

import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.nanorep.nanoclient.Channeling.NRChanneling;

import nanorep.nanowidget.R;

/**
 * Created by nissimpardo on 26/06/16.
 */
public class NRCChannelItem extends NRChannelItem {

    public NRCChannelItem(View itemView) {
        super(itemView);
    }

    public void setChanneling(NRChanneling channeling) {
        mChanneling = channeling;
        if(mTextView != null) {
            mTextView.setText(channeling.getButtonText());
        }
        String resName = null;
        switch (channeling.getType()) {
            case PhoneNumber:
                resName = "phone_conv";
                break;
            case ChatForm:
                resName = "chat_conv";
                break;
            case OpenCustomURL:
            case ContactForm:
                resName = "mail_conv";
                break;

        }
        if (resName != null) {
            mIcon.setImageResource(itemView.getResources().getIdentifier(resName, "drawable", itemView.getContext().getPackageName()));
        }
    }

}
