package nanorep.nanowidget.Fragments;

import android.Manifest;
import android.animation.Animator;
import android.animation.FloatEvaluator;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.view.ViewCompat;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.webkit.JavascriptInterface;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;

import com.nanorep.nanoclient.Channeling.NRChanneling;
import com.nanorep.nanoclient.Connection.NRError;
import com.nanorep.nanoclient.Connection.NRUtilities;
import com.nanorep.nanoclient.Handlers.NRLocationHandler;
import com.nanorep.nanoclient.Handlers.NRSpeechHandler;
import com.nanorep.nanoclient.Interfaces.NRQueryResult;
import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.RequestParams.NRFAQLikeParams;
import com.nanorep.nanoclient.RequestParams.NRLikeType;
import com.nanorep.nanoclient.Response.NRCreateConversation;
import com.nanorep.nanoclient.Response.NRFAQAnswer;
import com.nanorep.nanoclient.Response.NRHandleConversationStatement;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import nanorep.nanowidget.Components.AbstractViews.NRCustomChannelView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomContentView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomFeedbackView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomLikeView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomNegativeFeedbackView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomSearchBarView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomSuggestionsView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomTitleView;
import nanorep.nanowidget.Components.ChannelPresenters.NRChannelPresentor;
import nanorep.nanowidget.Components.ChannelPresenters.NRChannelStrategy;
import nanorep.nanowidget.Components.MyWebView;
import nanorep.nanowidget.Components.NRCChannelingView;
import nanorep.nanowidget.Components.NRCFeedbackView;
import nanorep.nanowidget.Components.NRCNegativeFeedbackView;
import nanorep.nanowidget.Components.NRCSearchBar;
import nanorep.nanowidget.Components.NRCTitleView;
import nanorep.nanowidget.Components.NRCWebView;
import nanorep.nanowidget.Components.NRChannelItem;
import nanorep.nanowidget.Components.NRContentView;
import nanorep.nanowidget.Components.NRLikeView;
import nanorep.nanowidget.Components.NRResultItem;
import nanorep.nanowidget.Components.NRResultTopView;
import nanorep.nanowidget.Components.NRSuggestionsView;
import nanorep.nanowidget.DataClasse.NRResult;
import nanorep.nanowidget.R;
import com.nanorep.nanoclient.RequestParams.NRCEntity;
import nanorep.nanowidget.Requests.NRPersonalQuery;
import nanorep.nanowidget.Requests.NRPublicUserQuery;
import nanorep.nanowidget.interfaces.NRConversationIdListener;
import nanorep.nanowidget.interfaces.NRCustomViewAdapter;
import nanorep.nanowidget.interfaces.NRPrivatePersonalQueries;
import nanorep.nanowidget.interfaces.NRPublicPersonalQueries;
import nanorep.nanowidget.interfaces.NRSearchBarListener;
import nanorep.nanowidget.interfaces.NRSuggestionsListener;
import nanorep.nanowidget.interfaces.OnSpeechListener;
import nanorep.nanowidget.interfaces.OnPersonalDataFetched;
import nanorep.nanowidget.interfaces.OnPublicDataFetched;

/**
 * Created by noat on 04/12/2016.
 */

public class NRCMainFragment extends Fragment implements NRSearchBarListener, NRResultTopView.Listener, NRChannelItem.OnChannelSelectedListener, NRSuggestionsListener, NRContentView.Listener {

    private static final String BASE_URL = "http://ec2-54-245-13-126.us-west-2.compute.amazonaws.com/";
//    private static final String BASE_URL = "http://192.168.30.137/conversational/";
    private static final String INDEX = "index.html";
    private static final String ICC = "icici.html";

    public static final String TAG = NRCMainFragment.class.getName();
    public static final String SUPPORT_CENTER_LINK = "supportCenterLink";
    public static final String READ_MORE = "readMore";
    public static final String CHANNEL = "channel";
    public static final String ANSWER = "answer";
    public static final String READY = "ready";
    public static final String KIND = "kind";
    public static final String CONVERSATIONAL = "conversational";
    public static final String HTTP = "http";
    public static final String WAS_HELPFUL = "wasHelpful";
    public static final String USER_OPTION = "userOption";
    public static final String LOCATION = "location";
    public static final String CONVERSATION_NOT_FOUND = "Conversation_not_found";


    private Pattern mPattern;
//    private Pattern paramPattern;

    private NRCustomViewAdapter viewAdapter;
    private String conversationId;
    private boolean onSpeechInitialized;

    // search bar
    LinearLayout searchBarContainer;
    NRCustomSearchBarView searchBarView;

    // web view
    NRCWebView nrcWebView;

    // conversation id listener
    NRConversationIdListener conversationIdListener;

    // suggestions view
    private NRCustomSuggestionsView suggestionsView;
    private LinearLayout suggestionViewContainer;

    private RelativeLayout fragment_place_holder;
    private RelativeLayout main_linear;

    private boolean loadingFinished = true;
    private boolean redirect = false;

    private OnSpeechListener mSpeechListener;

    private ArrayList<NRPersonalQuery> queries;

    NRChannelPresentor channelPresentorListener;

    JSONArray jsons = new JSONArray();

    FrameLayout content_main;

    NRPublicPersonalQueries nrPublicPersonalQueries;
    NRPrivatePersonalQueries nrPrivatePersonalQueries;

    ArrayList<NRPublicUserQuery> requests;

    private Object reflectionObject;

    public static NRCMainFragment newInstance(String conversationId) {

        Bundle args = new Bundle();

        args.putString("conversationId", conversationId);

        NRCMainFragment fragment = new NRCMainFragment();
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        requests = new ArrayList<>();

        queries = new ArrayList<>();

        mPattern = Pattern.compile("(\\{\\{[^{{\"]*\\}\\})");
//        paramPattern = Pattern.compile("(\\(^\\(\"*\\))");
    }

    private void getConversationID(Nanorep.OnCreateConversationalListener onCreateConversationalListener) {
        Nanorep.getInstance().createConversation(onCreateConversationalListener);
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);

        if(context instanceof NRCustomViewAdapter) {
            viewAdapter = (NRCustomViewAdapter) context;
        }
    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        final View view = inflater.inflate(R.layout.nrc_fragment_main, container, false);

        if(Nanorep.getInstance().getAccountParams().getAccount().equals("icicibot")) {
            updateTitleNormalText();
        }

        conversationId = this.getArguments().getString("conversationId");
        if(conversationId == null) {
            getConversationID(new Nanorep.OnCreateConversationalListener() {
                @Override
                public void onConversationalCreated(NRCreateConversation createConversation, NRError error) {
                    if(error == null) {
                        conversationId = createConversation.id;
                        if(conversationIdListener != null) {
                            conversationIdListener.onConversationIdFetched(conversationId);
                        }

                        setViews(view);
                    }
                }
            });
        } else {
            setViews(view);
        }

        return view;
    }

    private void setViews(final View view) {

        content_main = (FrameLayout) view.findViewById(R.id.content_main);
        fragment_place_holder = (RelativeLayout) view.findViewById(R.id.fragment_place_holder);
        main_linear = (RelativeLayout) view.findViewById(R.id.main_linear);

        // web view
        nrcWebView = (NRCWebView) view.findViewById(R.id.nrcWebView);
        initWebView();
        nrcWebView.requestFocus(View.FOCUS_DOWN);

        // search bar
        searchBarContainer = (LinearLayout) view.findViewById(R.id.nrcSearchBarContainer);

        searchBarView = viewAdapter.getSearchBar(getContext());

        if (searchBarView == null) {
            searchBarView = new NRCSearchBar(getContext());
        }

        searchBarView.setListener(this);

        searchBarContainer.addView(searchBarView, new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT));

        // suggestions view
//        suggestionViewContainer = (LinearLayout) view.findViewById(R.id.suggestionViewContainer);
//
//        suggestionsView = viewAdapter.getSuggestionsView(getContext());
//
//        if (suggestionsView == null) {
//            suggestionsView = new NRSuggestionsView(getContext());
//        }
//
//        suggestionsView.setListener(this);
//
//        suggestionViewContainer.addView(suggestionsView);

        Nanorep.getInstance().getNRConfiguration().getAutoComplete().setDividerVisible(true);

        view.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener() {
            @Override
            public void onGlobalLayout() {
                Rect r = new Rect();
                //r will be populated with the coordinates of your view that area still visible.
                view.getWindowVisibleDisplayFrame(r);

                int heightDiff = view.getRootView().getHeight() - (r.bottom - r.top);
                if (heightDiff > 150) { // if more than 100 pixels, its probably a keyboard...
                    nrcWebView.loadUrl("javascript:scrollToBottom();");
                }
            }
        });

    }

    private void initWebView() {

        nrcWebView.clearCache(true);

        nrcWebView.getSettings().setJavaScriptEnabled(true);

        nrcWebView.setWebViewClient(new NRCWebClient());

        nrcWebView.setWebChromeClient(new WebChromeClient() {
        });

        //Add a JavaScriptInterface, so I can make calls from the web to Java methods
//        nrcWebView.addJavascriptInterface(new myJavaScriptInterface(), "CallToAnAndroidFunction");

        String url = BASE_URL;
        if(Nanorep.getInstance().getAccountParams().getAccount().equals("icicibot")) {
            url += ICC;
        } else {
            url += INDEX;
        }
        nrcWebView.loadUrl(url);
    }

    public void setSpeechListener(OnSpeechListener mSpeechListener) {
        this.mSpeechListener = mSpeechListener;
    }

    @Override
    public void onStartRecording(final ImageButton button) {

        final ObjectAnimator scaleDown = ObjectAnimator.ofPropertyValuesHolder(button,
        PropertyValuesHolder.ofFloat("scaleX", 0.5f),
        PropertyValuesHolder.ofFloat("scaleY", 0.5f));
        scaleDown.setDuration(500);
        scaleDown.setEvaluator(new FloatEvaluator());
        scaleDown.setRepeatCount(ValueAnimator.INFINITE);
        scaleDown.setRepeatMode(ValueAnimator.REVERSE);

        scaleDown.addListener(new Animator.AnimatorListener() {
            @Override
            public void onAnimationStart(Animator animation) {

            }

            @Override
            public void onAnimationEnd(Animator animation) {
                animation.removeListener(this);
                animation.setDuration(0);
//                if(button.getScaleX() == 0.5f) {
//                    ((ValueAnimator) animation).reverse();
//                }

                ViewCompat.setScaleX(button,1.0f);
                ViewCompat.setScaleY(button,1.0f);
            }

            @Override
            public void onAnimationCancel(Animator animation) {
                animation.removeListener(this);
                animation.setDuration(0);
//                if(button.getScaleX() == 0.5f) {
//                    ((ValueAnimator) animation).reverse();
//                }
                ViewCompat.setScaleX(button,1.0f);
                ViewCompat.setScaleY(button,1.0f);
            }

            @Override
            public void onAnimationRepeat(Animator animation) {

            }
        });


//        if (!onSpeechInitialized) {
//            onSpeechInitialized = true;
            Nanorep.getInstance().getSpeechHandler().setListener(new NRSpeechHandler.Listener() {
                @Override
                public void onSpeechDetected(String text) {
                    Log.d("SPEECH", text);
                    if(scaleDown.isRunning()) {
                        scaleDown.end();
                        scaleDown.cancel();
                        button.clearAnimation();
                    }
                    searchBarView.updateText(searchBarView.getText() + " " + text);
                }

                @Override
                public void onSpeechDetectionFailed(int error) {
                    if(scaleDown.isRunning()) {
                        scaleDown.end();
                        scaleDown.cancel();
                        button.clearAnimation();
                    }
                }

                @Override
                public void onPermissionNeeded() {
                    requestPermissions(new String[] {Manifest.permission.RECORD_AUDIO}, 100);
                }
            });
//        }

        scaleDown.start();
        Nanorep.getInstance().getSpeechHandler().startRecording();
    }

    @Override
    public void fetchSuggestionsForText(final String text) {
//        Nanorep.getInstance().suggestionsForText(text, new Nanorep.OnSuggestionsFetchedListener() {
//            @Override
//            public void onSuggestionsFetched(NRSuggestions suggestions, NRError error) {
//                if (error != null) {
//                    Log.d("Fetcher", error.getDomain());
//                } else if (suggestions != null && suggestions.getSuggestions() != null && suggestions.getSuggestions().size() > 0) {
//                    if (searchBarView.getText().length() - text.length() <= 1) {
//                        suggestionsView.setSuggestions(suggestions.getSuggestions());
//                    }
//                }
//            }
//        });
    }

    // send text to the webView from client
    @Override
    public void searchForText(String text) {

        sendQuestion(text);
    }

    private void sendQuestion(String text) {
//        suggestionsView.setSuggestions(null);
        nrcWebView.loadUrl("javascript:addText(true,{\"text\":\"" + text + "\"});");
        if(conversationId != null) {
            sendStatement(text, null);
        }
//        searchBarView.requestFocus();
    }


    private void sendStatement(final String text, final String entitites) {
        if ("reset".equals(text)) {
            getConversationID(new Nanorep.OnCreateConversationalListener() {
                @Override
                public void onConversationalCreated(NRCreateConversation createConversation, NRError error) {
                    if (error == null) {
                        initWebView();
                    }
                }
            });
        } else {
            Nanorep.getInstance().handleConversationStatement(new Nanorep.OnHandleConversationStatementListener() {
                @Override
                public void onRecievedStatement(NRHandleConversationStatement handleConversationStatement, NRError error) {
                    NRCMainFragment.this.onRecievedStatement(handleConversationStatement, error, text);
                }
            }, conversationId, text, null, entitites);
        }
    }

    private void onRecievedStatement(final NRHandleConversationStatement handleConversationStatement, NRError error, final String text) {
        searchBarView.requestFocus();

        if(error == null) {
            String errorStr = getStringFromJSONObject(handleConversationStatement.json, "error");

            if(CONVERSATION_NOT_FOUND.equals(errorStr)) {

                getConversationID(new Nanorep.OnCreateConversationalListener() {
                    @Override
                    public void onConversationalCreated(NRCreateConversation createConversation, NRError error) {
                        if(error == null) {
                            conversationId = createConversation.id;
                            if(conversationIdListener != null) {
                                conversationIdListener.onConversationIdFetched(conversationId);
                            }

                            sendStatement(text, null);
                        }
                    }
                });

            } else {
                // if rejected
                if(!handleConversationStatement.json.isNull("missingEntities")) {

                    onAnswerRejected(handleConversationStatement, text);

                } else {
                    String answer = getStringFromJSONObject(handleConversationStatement.json, "text");

                    queries = new ArrayList<>();


                    answer = replace(answer);

                    try {
                        handleConversationStatement.json.put("text", answer);
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }

                    nrcWebView.loadUrl("javascript:addText(false," + handleConversationStatement.json + ");");
                    jsons.put(handleConversationStatement.json);
                }
            }
        }
    }

    /**
     * if missingEntities is not empty, this answer is rejected,
     * and we need to query the application for that missing entities.
     *
     * @param handleConversationStatement
     * @param text
     */
    private void onAnswerRejected(final NRHandleConversationStatement handleConversationStatement, final String text) {
        if(!requests.isEmpty()){
            return;
        }

        for (String missingEntity : handleConversationStatement.missingEntities) {
            NRPublicUserQuery userQuery = new NRPublicUserQuery();
            NRCEntity entity = new NRCEntity();
            NRCEntity.ResultEntity resultEntity = entity.new ResultEntity();

            // kind - the missed data
            resultEntity.setKind(missingEntity);

            entity.setResultEntity(resultEntity);
            userQuery.setEntity(entity);
            requests.add(userQuery);
        }

        nrPublicPersonalQueries.fetchPublicPersonalInfo(requests, new OnPublicDataFetched() {
            @Override
            public void onDataFetched(NRPublicUserQuery query) {
                boolean send = true;
                for (NRPublicUserQuery userQuery : requests) {
                    if(userQuery.getEntity().getResultEntity().getKind().equals(query.getEntity().getResultEntity().getKind())){
                        userQuery.getEntity().setResultEntity(query.getEntity().getResultEntity());
                    }

                    if(userQuery.getEntity().getResultEntity().getValue() == null) {
                        send = false;
                    }
                }
                if(send) {
                    JSONArray jsonArray = new JSONArray();

                    for (NRPublicUserQuery userQuery : requests) {
                        JSONObject jsonObject = userQuery.getEntity().getJson();
                        jsonArray.put(jsonObject);
                    }
                    // send the statement again to Nanorep, with the filled public data
                    // that was recieved from application
                    sendStatement(text, jsonArray.toString());

                    requests = new ArrayList<NRPublicUserQuery>();
                }
            }
        });
    }

    private String getStringFromJSONObject(JSONObject jsonObject, String key) {
        String str = "";
        if(!jsonObject.isNull(key)) {
            try {
                str = jsonObject.getString(key);
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }

        return str;
    }

    public void setReflectionObject(Object reflectionObject) {
        this.reflectionObject = reflectionObject;
    }


    private interface Listener {
        void onAnswerComplete(String answer);
    }

    /**
     * If there are place holders {{ }}
     * we need to query the application for the missing provate data
     *
     * @param answer
     */
    private String replace(String answer){

        if(!answerContainPrivatePlaceHolders(answer)) {
            return answer;
        }

        ArrayList<String> placeHolders = new ArrayList<>();
        Matcher matcher = mPattern.matcher(answer);

        while (matcher.find()) {
            String privateHolder = "";
            try {
                privateHolder = matcher.group(1);
                placeHolders.add(privateHolder);
            }catch (IllegalStateException e){
                e.printStackTrace();
            }
        }

        for (String privateHolder : placeHolders) {
            privateHolder = privateHolder.replace("{{", "");
            privateHolder = privateHolder.replace("}}", "");

            String[] parts = privateHolder.split("[\\(\\)]");

            String[] paramsArr = parts[1].split(",");

            Object returnValue = callMethod(isMethodImplemented(reflectionObject, parts[0]), paramsArr);

            answer = answer.replace("{{" + privateHolder + "}}", returnValue.toString());
        }
        return answer;
    }

    private boolean answerContainPrivatePlaceHolders(String answer) {
        if(answer.contains("{{") && answer.contains("}}")) {
            return true;
        }
        return false;
    }


    @Override
    public void onClearClicked(boolean byUser) {
        suggestionsView.setSuggestions(null);
    }

    @Override
    public void onEmptyQuery() {

    }

    // Top View Listener Methods
    @Override
    public void onFoldItemFinished(boolean beforeGoingDown) {

    }

    @Override
    public void fetchBodyForResult(NRCustomContentView view, String resultID, Integer resultHash) {

    }

    @Override
    public void closeAnswer() {

    }

    @Override
    public void onLikeClicked(final NRResultTopView view, final NRCustomLikeView likeView, String resultId, boolean isLike) {
        final NRResult result = view.getmResult();

        if (isLike) {
            onLike(result, view, likeView);
        } else if(!isLike) {
            onDislike(result, view, likeView, NRLikeType.INCORRECT_ANSWER);
        }
        getView().requestFocus();
    }

    private void onLike(NRResult result, final NRResultTopView view, final NRCustomLikeView likeView)  {
        result.getFetchedResult().setLikeState(NRQueryResult.LikeState.positive);
        NRFAQLikeParams likeParams = new NRFAQLikeParams(result.getFetchedResult());
        likeParams.setLikeType(NRLikeType.POSITIVE);
        likeParams.setAnswerId(result.getFetchedResult().getId());
        Nanorep.getInstance().likeForFAQResult(likeParams, new Nanorep.OnLikeSentListener() {
            @Override
            public void onLikeSent(boolean success) {
                if(!success) {
                    view.getmResult().getFetchedResult().setLikeState(NRQueryResult.LikeState.notSelected);
                    likeView.resetLikeView();
                }
            }
        });
    }

    private void onDislike(NRResult result, final NRResultTopView view, final NRCustomLikeView likeView, NRLikeType type)  {
        result.getFetchedResult().setLikeState(NRQueryResult.LikeState.negative);

        NRFAQLikeParams likeParams = new NRFAQLikeParams(result.getFetchedResult());
        likeParams.setLikeType(NRLikeType.INCORRECT_ANSWER);
        likeParams.setAnswerId(result.getFetchedResult().getId());
        Nanorep.getInstance().likeForFAQResult(likeParams, new Nanorep.OnLikeSentListener() {
            @Override
            public void onLikeSent(boolean success) {
                if(!success) {
                    view.getmResult().getFetchedResult().setLikeState(NRQueryResult.LikeState.notSelected);
                    likeView.resetLikeView();
                }
            }
        });
    }

    @Override
    public void onChannelSelected(NRChanneling channeling) {
        NRChannelPresentor presentor = NRChannelStrategy.presentor(getContext(), channeling, Nanorep.getInstance());

        String url = presentor.getUrl();
        if (url != null) {
            final RelativeLayout holder = (RelativeLayout) getView().findViewById(R.id.fragment_place_holder);
            holder.setVisibility(View.VISIBLE);
            NRWebContentFragment webContentFragment = NRWebContentFragment.newInstance(url, null);
            webContentFragment.setListener(new NRWebContentFragment.Listener() {
                @Override
                public void onDismiss() {
                    getChildFragmentManager().popBackStack();
                    holder.setVisibility(View.INVISIBLE);
                    getView().requestFocus();
                }
            });
            getChildFragmentManager().beginTransaction().setCustomAnimations(R.anim.fade_in, R.anim.fade_out, R.anim.fade_in, R.anim.fade_out).add(R.id.fragment_place_holder, webContentFragment).addToBackStack("linked").commit();
            getView().requestFocus();
        } else {
            String permission = presentor.getPermission();
            if( permission != null) {
                setChannelPresentorListener(presentor);
                requestPermissions(new String[]{permission}, 1);
            } else {
                presentor.present();
            }

        }

    }

    @Override
    public void onShareClicked() {
        getView().requestFocus();
    }

    @Override
    public void onSelectSuggestion(String suggestion) {
        searchBarView.updateEditTextView("");
//        searchBarView.dismissKeyboard();
        sendQuestion(suggestion);
    }

    @Override
    public void onLinkedArticleClicked(String articleId) {

    }

    @Override
    public void onLinkClicked(String url) {
        MyWebView webView = new MyWebView(getContext(), url, new MyWebView.Listener() {
            @Override
            public void onDismiss() {
                content_main.removeViewAt(content_main.getChildCount() - 1);
                if(content_main.getChildCount() == 0) {
                    content_main.setVisibility(View.GONE);
                }
                getView().requestFocus();
            }
        });

        content_main.addView(webView);
        content_main.setVisibility(View.VISIBLE);
        getView().requestFocus();
    }

    @Override
    public void onDismiss() {

    }
    //end Top View Listener Methods

    public class myJavaScriptInterface {

        @JavascriptInterface
        public void showHTML(){
            getActivity().runOnUiThread(new Runnable() {

                @Override
                public void run() {
                    nrcWebView.scrollTo(0, nrcWebView.computeVerticalScrollRange());
                }
            });
        }

    }

    private class NRCWebClient extends WebViewClient {

        @Override
        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            return openUrl(url);
        }

        @TargetApi(Build.VERSION_CODES.LOLLIPOP)
        @Override
        public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
            return openUrl(request.getUrl().toString());
        }

        private boolean openUrl(String link) {
            if (link.startsWith(CONVERSATIONAL)) {
                HashMap<String, String> map = (HashMap<String, String>) NRUtilities.jsonStringToPropertyList(link.replace("conversational://",""));

                switch (map.get(KIND)) {
                    case SUPPORT_CENTER_LINK:
                        openSupportCenterLink(map.get("url"));
                        break;
                    case READ_MORE:
                        readMore(map.get("articleId"));
                        break;
                    case  CHANNEL:
                        channeling(map.get("postback"));
                        break;
                    case ANSWER:
                        answer(map.get("text"), map.get("postback"));
                        break;
                    case  READY:
                        initConversationFromCache();
                        break;
                    case WAS_HELPFUL:
                        break;
                    case USER_OPTION:
                        answer(map.get("text"), map.get("postback"));
                        break;
                    case LOCATION:
                        onLocationNeeded();
                        break;
                }

                return true;
            } else  if (link.startsWith(HTTP)) {
                onLinkClicked(link);
                return true;
            }
            return false;
        }

        @Override
        public void onPageStarted(WebView view, String url, Bitmap favicon) {
//            super.onPageStarted(view, url, favicon);
            loadingFinished = false;
            //SHOW LOADING IF IT ISNT ALREADY VISIBLE
            fragment_place_holder.setVisibility(View.VISIBLE);
        }

        @Override
        public void onPageFinished(WebView view, String url) {
            if(!redirect){
                loadingFinished = true;
            }

            if(loadingFinished && !redirect){
//                HIDE LOADING IT HAS FINISHED
                fragment_place_holder.setVisibility(View.GONE);
                    view.clearCache(true);
            } else{
                redirect = false;
            }
        }
    }

    private void initConversationFromCache() {
        jsons = Nanorep.getInstance().getCachedConversation(conversationId);

        if(jsons != null) {
            for (int i = 0; i < jsons.length(); i++) {
                JSONObject row = null;
                try {
                    row = jsons.getJSONObject(i);
                } catch (JSONException e) {
                    e.printStackTrace();
                }
                boolean client = false;
                if(row.names().length() == 1) {
                    client = true;
                }
                nrcWebView.loadUrl("javascript:addText("+client+","+row+");");
            }

        } else {
            jsons = new JSONArray();
        }
    }

    private void onLocationNeeded() {
        Nanorep.getInstance().getLocationHandler().setListener(new NRLocationHandler.Listener() {
            @Override
            public void onLocationFound(double lat, double lang) {
                Log.d("Location", "location " + lat + " " + lang);
                nrcWebView.loadUrl("javascript:addMap();");
                Nanorep.getInstance().handleConversationStatement(new Nanorep.OnHandleConversationStatementListener() {
                    @Override
                    public void onRecievedStatement(NRHandleConversationStatement handleConversationStatement, NRError error) {
                        NRCMainFragment.this.onRecievedStatement(handleConversationStatement, error, null);
                    }
                }, conversationId, "" + lat + "," + lang, null, null);
            }

            @Override
            public void onPermissionNeeded() {
                requestPermissions(new String[] {Manifest.permission.ACCESS_COARSE_LOCATION}, 101);
            }
        });
        Nanorep.getInstance().getLocationHandler().fetchCurrentLocation();
    }

    private void answer(final String text, String postback) {

        nrcWebView.loadUrl("javascript:addText(true,{\"text\":\"" + text + "\"});");

        Nanorep.getInstance().handleConversationStatement(new Nanorep.OnHandleConversationStatementListener() {
            @Override
            public void onRecievedStatement(NRHandleConversationStatement handleConversationStatement, NRError error) {
                NRCMainFragment.this.onRecievedStatement(handleConversationStatement, error, text);
            }
        }, conversationId, null, postback, null);
    }

    @Override
    public void onPause() {
        super.onPause();

        if(conversationId != null) {
            Nanorep.getInstance().addCachedConversation(conversationId, jsons);
        }
    }

    private void channeling(String postback) {
        NRChanneling channeling = NRChanneling.channelForParams((HashMap) NRUtilities.jsonStringToPropertyList(postback));
        onChannelSelected(channeling);
    }

    private void readMore(final String articleId) {
        if(fragment_place_holder.getVisibility() == View.VISIBLE) {
            getView().requestFocus();
            return;
        }

        fragment_place_holder.setVisibility(View.VISIBLE);

        Nanorep.getInstance().getArticleData(articleId, new Nanorep.OnArticleFetchedListener() {
            @Override
            public void onArticleFetched(NRFAQAnswer faqAnswer, NRError error) {

                if(error == null) {
                    //close keyboard
                    searchBarView.dismissKeyboard();

                    faqAnswer.setId(articleId);
                    NRResult result = new NRResult(faqAnswer, NRResultItem.RowType.TITLE);

                    NRResultTopView resultTopView = getTopView(result);

                    content_main.addView(resultTopView);

                    fragment_place_holder.setVisibility(View.GONE);
                    content_main.setVisibility(View.VISIBLE);

                    resultTopView.openOpenedView(result);
                    getView().requestFocus();
                }
            }
        });

    }

    private void openSupportCenterLink(String url){
        Intent i = new Intent(Intent.ACTION_VIEW);
        i.setData(Uri.parse(url));
        startActivity(i);
    }

    private NRResultTopView getTopView(NRResult result) {

        NRResultTopView resultTopView = new NRResultTopView(getActivity());

        resultTopView.setListener(this);

        NRCustomTitleView titleView = new NRCTitleView(getContext());

        NRCustomContentView contentView = new NRContentView(getContext());

        NRCustomLikeView likeView = new NRLikeView(getContext());

        NRCustomChannelView channelView = new NRCChannelingView(getContext());

        NRCustomFeedbackView feedbackView = new NRCFeedbackView(getContext());

        NRCustomNegativeFeedbackView negativeFeedbackView = new NRCNegativeFeedbackView(getContext());

        resultTopView.setTitleView(titleView);
        resultTopView.setContentView(contentView, this);

        resultTopView.setLikeView(likeView);
        resultTopView.setChannelView(channelView, this);

        feedbackView.setCustomLikeView(likeView);
        if (result.getFetchedResult().getChanneling() != null && result.getFetchedResult().getChanneling().size() > 0) {
            feedbackView.setCustomChannelView(channelView);
        }
        feedbackView.setCustomNegativeFeedbackView(negativeFeedbackView);

        resultTopView.setFeedbackView(feedbackView);

        return resultTopView;
    }

    @Override
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);

        nrPublicPersonalQueries = (NRPublicPersonalQueries) getActivity();
        nrPrivatePersonalQueries = (NRPrivatePersonalQueries) getActivity();

        getView().setFocusableInTouchMode(true);
        getView().requestFocus();

        View.OnKeyListener onKeyListener = new View.OnKeyListener() {
            @Override
            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (event.getAction() == KeyEvent.ACTION_DOWN) {
                    if (keyCode == KeyEvent.KEYCODE_BACK) {
                        if(content_main.getChildCount() > 0) {
                            content_main.removeViewAt(content_main.getChildCount() - 1);
                            if(content_main.getChildCount() == 0) {
                                content_main.setVisibility(View.GONE);
                            }
                            return true;
                        }
                    }
                }
                return false;
            }
        };

        getView().setOnKeyListener(onKeyListener);
    }

    public void setConversationIdListener(NRConversationIdListener conversationIdListener) {
        this.conversationIdListener = conversationIdListener;
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if(requestCode == 1 && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
            channelPresentorListener.present();
        } else if (requestCode == 100 && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
            Nanorep.getInstance().getSpeechHandler().initializeVoiceRecognition();
        } else if (requestCode == 101 && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
            Nanorep.getInstance().getLocationHandler().fetchCurrentLocation();
        }
    }

    public void setChannelPresentorListener(NRChannelPresentor channelPresentorListener) {
        this.channelPresentorListener = channelPresentorListener;
    }

    private void updateTitleNormalText() {
//        ActionBar actionBar = ((AppCompatActivity)getActivity()).getSupportActionBar();
//        // titleConfig background color
//        actionBar.setBackgroundDrawable(new ColorDrawable(Color.parseColor("#e77817")));
//        actionBar.setTitle("ICICI Bank Demobot");
    }

    public Method isMethodImplemented(Object obj, String methodName) {
        Method[] methods = obj.getClass().getDeclaredMethods();
        for (Method m : methods) {
            if (m.getName().contains(methodName)) {
                return m;
            }
        }
        return null;
    }

    private Object callMethod(Method bridgeMethod, Object... args) {
        Object object = reflectionObject;
        if (bridgeMethod != null) {
            try {
                if (args == null) {
                    Class<?>[] params = bridgeMethod.getParameterTypes(); // protect case for params mismatch
                    if (params.length != 1){
                        bridgeMethod.invoke(object);
                    }
                    else {
//                        Log.e("handleHtml5LibCall", "Error, Parameters mismatch for method: " + functionName + " number of params = " + params.length);
                    }
                } else {
                    return bridgeMethod.invoke(object, args);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}
