package nanorep.nanowidget.Components.AbstractViews;

import android.content.Context;
import android.widget.LinearLayout;

import nanorep.nanowidget.Components.NRChannelItem;
import nanorep.nanowidget.interfaces.OnFeedBackListener;
import nanorep.nanowidget.interfaces.OnLikeListener;

/**
 * Created by noat on 30/11/2016.
 */

public abstract class NRCustomFeedbackView extends LinearLayout implements OnFeedBackListener{

    protected OnFeedBackListener mListener;
    protected NRCustomLikeView customLikeView;
    protected NRCustomChannelView customChannelView;
    protected NRCustomNegativeFeedbackView customNegativeFeedbackView;


    public void setCustomLikeView(NRCustomLikeView customLikeView) {
        this.customLikeView = customLikeView;
        this.customLikeView.setListener(this);
    }

    public void setCustomChannelView(NRCustomChannelView customChannelView) {
        this.customChannelView = customChannelView;
        this.customChannelView.setListener(this);
    }

    public void setCustomNegativeFeedbackView(NRCustomNegativeFeedbackView customNegativeFeedbackView) {
        this.customNegativeFeedbackView = customNegativeFeedbackView;
        this.customNegativeFeedbackView.setListener(this);
    }

    public NRCustomChannelView getCustomChannelView() {
        return customChannelView;
    }

    public NRCustomLikeView getCustomLikeView() {
        return customLikeView;
    }

    public NRCustomFeedbackView(Context context) {
        super(context);
    }

    public void setListener(OnFeedBackListener listener) {
        mListener = listener;
    }

    public abstract void addLikeView();

    public abstract void addChannelView();

    public abstract void addNegativeFeedbackView();
}
