/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Fragments;

import android.animation.Animator;
import android.animation.FloatEvaluator;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TypeEvaluator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.view.ViewCompat;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.webkit.JavascriptInterface;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.nanorep.nanoclient.Channeling.NRChanneling;
import com.nanorep.nanoclient.Connection.NRError;
import com.nanorep.nanoclient.Connection.NRUtilities;
import com.nanorep.nanoclient.Handlers.NRLocationHandler;
import com.nanorep.nanoclient.Handlers.NRSpeechHandler;
import com.nanorep.nanoclient.Interfaces.NRQueryResult;
import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.RequestParams.NRCEntity;
import com.nanorep.nanoclient.RequestParams.NRFAQLikeParams;
import com.nanorep.nanoclient.RequestParams.NRLikeType;
import com.nanorep.nanoclient.Response.NRCreateConversation;
import com.nanorep.nanoclient.Response.NRFAQAnswer;
import com.nanorep.nanoclient.Response.NRHandleConversationStatement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nanorep.nanowidget.Components.AbstractViews.NRCustomContentView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomFeedbackView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomLikeView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomSearchBarView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomSuggestionsView;
import nanorep.nanowidget.Components.ChannelPresenters.NRChannelPresentor;
import nanorep.nanowidget.Components.ChannelPresenters.NRChannelStrategy;
import nanorep.nanowidget.Components.MyWebView;
import nanorep.nanowidget.Components.NRCChannelingView;
import nanorep.nanowidget.Components.NRCFeedbackView;
import nanorep.nanowidget.Components.NRCNegativeFeedbackView;
import nanorep.nanowidget.Components.NRCSearchBar;
import nanorep.nanowidget.Components.NRCTitleView;
import nanorep.nanowidget.Components.NRCWebView;
import nanorep.nanowidget.Components.NRChannelItem;
import nanorep.nanowidget.Components.NRContentView;
import nanorep.nanowidget.Components.NRLikeView;
import nanorep.nanowidget.Components.NRResultItem;
import nanorep.nanowidget.Components.NRResultTopView;
import nanorep.nanowidget.Components.NRSuggestionsView;
import nanorep.nanowidget.DataClasse.NRResult;
import nanorep.nanowidget.Fragments.NRWebContentFragment;
import nanorep.nanowidget.R;
import nanorep.nanowidget.Requests.NRPersonalQuery;
import nanorep.nanowidget.Requests.NRPublicUserQuery;
import nanorep.nanowidget.interfaces.NRConversationIdListener;
import nanorep.nanowidget.interfaces.NRCustomViewAdapter;
import nanorep.nanowidget.interfaces.NRPrivatePersonalQueries;
import nanorep.nanowidget.interfaces.NRPublicPersonalQueries;
import nanorep.nanowidget.interfaces.NRSearchBarListener;
import nanorep.nanowidget.interfaces.NRSuggestionsListener;
import nanorep.nanowidget.interfaces.OnPublicDataFetched;
import nanorep.nanowidget.interfaces.OnSpeechListener;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class NRCMainFragment
extends Fragment
implements NRSearchBarListener,
NRResultTopView.Listener,
NRChannelItem.OnChannelSelectedListener,
NRSuggestionsListener,
NRContentView.Listener {
    private static final String BASE_URL = "http://ec2-54-245-13-126.us-west-2.compute.amazonaws.com/";
    private static final String INDEX = "index.html";
    private static final String ICC = "icici.html";
    public static final String TAG = NRCMainFragment.class.getName();
    public static final String SUPPORT_CENTER_LINK = "supportCenterLink";
    public static final String READ_MORE = "readMore";
    public static final String CHANNEL = "channel";
    public static final String ANSWER = "answer";
    public static final String READY = "ready";
    public static final String KIND = "kind";
    public static final String CONVERSATIONAL = "conversational";
    public static final String HTTP = "http";
    public static final String WAS_HELPFUL = "wasHelpful";
    public static final String USER_OPTION = "userOption";
    public static final String LOCATION = "location";
    public static final String CONVERSATION_NOT_FOUND = "Conversation_not_found";
    private Pattern mPattern;
    private NRCustomViewAdapter viewAdapter;
    private String conversationId;
    private boolean onSpeechInitialized;
    LinearLayout searchBarContainer;
    NRCustomSearchBarView searchBarView;
    NRCWebView nrcWebView;
    NRConversationIdListener conversationIdListener;
    private NRCustomSuggestionsView suggestionsView;
    private LinearLayout suggestionViewContainer;
    private RelativeLayout fragment_place_holder;
    private RelativeLayout main_linear;
    private boolean loadingFinished = true;
    private boolean redirect = false;
    private OnSpeechListener mSpeechListener;
    private ArrayList<NRPersonalQuery> queries;
    NRChannelPresentor channelPresentorListener;
    JSONArray jsons = new JSONArray();
    FrameLayout content_main;
    NRPublicPersonalQueries nrPublicPersonalQueries;
    NRPrivatePersonalQueries nrPrivatePersonalQueries;
    ArrayList<NRPublicUserQuery> requests;
    private Object reflectionObject;

    public static NRCMainFragment newInstance(String conversationId) {
        Bundle args = new Bundle();
        args.putString("conversationId", conversationId);
        NRCMainFragment fragment = new NRCMainFragment();
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requests = new ArrayList();
        this.queries = new ArrayList();
        this.mPattern = Pattern.compile("(\\{\\{[^{{\"]*\\}\\})");
    }

    private void getConversationID(Nanorep.OnCreateConversationalListener onCreateConversationalListener) {
        Nanorep.getInstance().createConversation(onCreateConversationalListener);
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (context instanceof NRCustomViewAdapter) {
            this.viewAdapter = (NRCustomViewAdapter)context;
        }
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        final View view = inflater.inflate(R.layout.nrc_fragment_main, container, false);
        if (Nanorep.getInstance().getAccountParams().getAccount().equals("icicibot")) {
            this.updateTitleNormalText();
        }
        this.conversationId = this.getArguments().getString("conversationId");
        if (this.conversationId == null) {
            this.getConversationID(new Nanorep.OnCreateConversationalListener(){

                public void onConversationalCreated(NRCreateConversation createConversation, NRError error) {
                    if (error == null) {
                        NRCMainFragment.this.conversationId = createConversation.id;
                        if (NRCMainFragment.this.conversationIdListener != null) {
                            NRCMainFragment.this.conversationIdListener.onConversationIdFetched(NRCMainFragment.this.conversationId);
                        }
                        NRCMainFragment.this.setViews(view);
                    }
                }
            });
        } else {
            this.setViews(view);
        }
        return view;
    }

    private void setViews(final View view) {
        this.content_main = (FrameLayout)view.findViewById(R.id.content_main);
        this.fragment_place_holder = (RelativeLayout)view.findViewById(R.id.fragment_place_holder);
        this.main_linear = (RelativeLayout)view.findViewById(R.id.main_linear);
        this.nrcWebView = (NRCWebView)view.findViewById(R.id.nrcWebView);
        this.initWebView();
        this.nrcWebView.requestFocus(130);
        this.searchBarContainer = (LinearLayout)view.findViewById(R.id.nrcSearchBarContainer);
        this.searchBarView = this.viewAdapter.getSearchBar(this.getContext());
        if (this.searchBarView == null) {
            this.searchBarView = new NRCSearchBar(this.getContext());
        }
        this.searchBarView.setListener(this);
        this.searchBarContainer.addView((View)this.searchBarView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        this.suggestionViewContainer = (LinearLayout)view.findViewById(R.id.suggestionViewContainer);
        this.suggestionsView = this.viewAdapter.getSuggestionsView(this.getContext());
        if (this.suggestionsView == null) {
            this.suggestionsView = new NRSuggestionsView(this.getContext());
        }
        this.suggestionsView.setListener(this);
        this.suggestionViewContainer.addView((View)this.suggestionsView);
        Nanorep.getInstance().getNRConfiguration().getAutoComplete().setDividerVisible(true);
        view.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                Rect r = new Rect();
                view.getWindowVisibleDisplayFrame(r);
                int heightDiff = view.getRootView().getHeight() - (r.bottom - r.top);
                if (heightDiff > 150) {
                    NRCMainFragment.this.nrcWebView.loadUrl("javascript:scrollToBottom();");
                }
            }
        });
    }

    private void initWebView() {
        this.nrcWebView.clearCache(true);
        this.nrcWebView.getSettings().setJavaScriptEnabled(true);
        this.nrcWebView.setWebViewClient(new NRCWebClient());
        this.nrcWebView.setWebChromeClient(new WebChromeClient(){});
        String url = BASE_URL;
        url = Nanorep.getInstance().getAccountParams().getAccount().equals("icicibot") ? url + ICC : url + INDEX;
        this.nrcWebView.loadUrl(url);
    }

    public void setSpeechListener(OnSpeechListener mSpeechListener) {
        this.mSpeechListener = mSpeechListener;
    }

    @Override
    public void onStartRecording(final ImageButton button) {
        final ObjectAnimator scaleDown = ObjectAnimator.ofPropertyValuesHolder((Object)button, (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((String)"scaleX", (float[])new float[]{0.5f}), PropertyValuesHolder.ofFloat((String)"scaleY", (float[])new float[]{0.5f})});
        scaleDown.setDuration(500L);
        scaleDown.setEvaluator((TypeEvaluator)new FloatEvaluator());
        scaleDown.setRepeatCount(-1);
        scaleDown.setRepeatMode(2);
        scaleDown.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                animation.removeListener((Animator.AnimatorListener)this);
                animation.setDuration(0L);
                ViewCompat.setScaleX((View)button, (float)1.0f);
                ViewCompat.setScaleY((View)button, (float)1.0f);
            }

            public void onAnimationCancel(Animator animation) {
                animation.removeListener((Animator.AnimatorListener)this);
                animation.setDuration(0L);
                ViewCompat.setScaleX((View)button, (float)1.0f);
                ViewCompat.setScaleY((View)button, (float)1.0f);
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        Nanorep.getInstance().getSpeechHandler().setListener(new NRSpeechHandler.Listener(){

            public void onSpeechDetected(String text) {
                Log.d((String)"SPEECH", (String)text);
                if (scaleDown.isRunning()) {
                    scaleDown.end();
                    scaleDown.cancel();
                    button.clearAnimation();
                }
                NRCMainFragment.this.searchBarView.updateText(NRCMainFragment.this.searchBarView.getText() + " " + text);
            }

            public void onSpeechDetectionFailed(int error) {
                if (scaleDown.isRunning()) {
                    scaleDown.end();
                    scaleDown.cancel();
                    button.clearAnimation();
                }
            }

            public void onPermissionNeeded() {
                NRCMainFragment.this.requestPermissions(new String[]{"android.permission.RECORD_AUDIO"}, 100);
            }
        });
        scaleDown.start();
        Nanorep.getInstance().getSpeechHandler().startRecording();
    }

    @Override
    public void fetchSuggestionsForText(String text) {
    }

    @Override
    public void searchForText(String text) {
        this.sendQuestion(text);
    }

    private void sendQuestion(String text) {
        this.nrcWebView.loadUrl("javascript:addText(true,{\"text\":\"" + text + "\"});");
        if (this.conversationId != null) {
            this.sendStatement(text, null);
        }
    }

    private void sendStatement(final String text, String entitites) {
        if ("reset".equals(text)) {
            this.getConversationID(new Nanorep.OnCreateConversationalListener(){

                public void onConversationalCreated(NRCreateConversation createConversation, NRError error) {
                    if (error == null) {
                        NRCMainFragment.this.initWebView();
                    }
                }
            });
        } else {
            Nanorep.getInstance().handleConversationStatement(new Nanorep.OnHandleConversationStatementListener(){

                public void onRecievedStatement(NRHandleConversationStatement handleConversationStatement, NRError error) {
                    NRCMainFragment.this.onRecievedStatement(handleConversationStatement, error, text);
                }
            }, this.conversationId, text, null, entitites);
        }
    }

    private void onRecievedStatement(NRHandleConversationStatement handleConversationStatement, NRError error, final String text) {
        this.searchBarView.requestFocus();
        if (error == null) {
            String errorStr = this.getStringFromJSONObject(handleConversationStatement.json, "error");
            if (CONVERSATION_NOT_FOUND.equals(errorStr)) {
                this.getConversationID(new Nanorep.OnCreateConversationalListener(){

                    public void onConversationalCreated(NRCreateConversation createConversation, NRError error) {
                        if (error == null) {
                            NRCMainFragment.this.conversationId = createConversation.id;
                            if (NRCMainFragment.this.conversationIdListener != null) {
                                NRCMainFragment.this.conversationIdListener.onConversationIdFetched(NRCMainFragment.this.conversationId);
                            }
                            NRCMainFragment.this.sendStatement(text, null);
                        }
                    }
                });
            } else if (!handleConversationStatement.json.isNull("missingEntities")) {
                this.onAnswerRejected(handleConversationStatement, text);
            } else {
                String answer = this.getStringFromJSONObject(handleConversationStatement.json, "text");
                this.queries = new ArrayList();
                answer = this.replace(answer);
                try {
                    handleConversationStatement.json.put("text", (Object)answer);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                this.nrcWebView.loadUrl("javascript:addText(false," + handleConversationStatement.json + ");");
                this.jsons.put((Object)handleConversationStatement.json);
            }
        }
    }

    private void onAnswerRejected(NRHandleConversationStatement handleConversationStatement, final String text) {
        if (!this.requests.isEmpty()) {
            return;
        }
        for (String missingEntity : handleConversationStatement.missingEntities) {
            NRPublicUserQuery userQuery = new NRPublicUserQuery();
            NRCEntity entity = new NRCEntity();
            NRCEntity.ResultEntity resultEntity = new NRCEntity.ResultEntity(entity);
            resultEntity.setKind(missingEntity);
            entity.setResultEntity(resultEntity);
            userQuery.setEntity(entity);
            this.requests.add(userQuery);
        }
        this.nrPublicPersonalQueries.fetchPublicPersonalInfo(this.requests, new OnPublicDataFetched(){

            @Override
            public void onDataFetched(NRPublicUserQuery query) {
                boolean send = true;
                for (NRPublicUserQuery userQuery : NRCMainFragment.this.requests) {
                    if (userQuery.getEntity().getResultEntity().getKind().equals(query.getEntity().getResultEntity().getKind())) {
                        userQuery.getEntity().setResultEntity(query.getEntity().getResultEntity());
                    }
                    if (userQuery.getEntity().getResultEntity().getValue() != null) continue;
                    send = false;
                }
                if (send) {
                    JSONArray jsonArray = new JSONArray();
                    for (NRPublicUserQuery userQuery : NRCMainFragment.this.requests) {
                        JSONObject jsonObject = userQuery.getEntity().getJson();
                        jsonArray.put((Object)jsonObject);
                    }
                    NRCMainFragment.this.sendStatement(text, jsonArray.toString());
                    NRCMainFragment.this.requests = new ArrayList();
                }
            }
        });
    }

    private String getStringFromJSONObject(JSONObject jsonObject, String key) {
        String str = "";
        if (!jsonObject.isNull(key)) {
            try {
                str = jsonObject.getString(key);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return str;
    }

    public void setReflectionObject(Object reflectionObject) {
        this.reflectionObject = reflectionObject;
    }

    private String replace(String answer) {
        if (!this.answerContainPrivatePlaceHolders(answer)) {
            return answer;
        }
        ArrayList<String> placeHolders = new ArrayList<String>();
        Matcher matcher = this.mPattern.matcher(answer);
        while (matcher.find()) {
            String privateHolder = "";
            try {
                privateHolder = matcher.group(1);
                placeHolders.add(privateHolder);
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
        }
        for (String privateHolder : placeHolders) {
            privateHolder = privateHolder.replace("{{", "");
            privateHolder = privateHolder.replace("}}", "");
            String[] parts = privateHolder.split("[\\(\\)]");
            Object[] paramsArr = parts[1].split(",");
            Object returnValue = this.callMethod(this.isMethodImplemented(this.reflectionObject, parts[0]), paramsArr);
            answer = answer.replace("{{" + privateHolder + "}}", returnValue.toString());
        }
        return answer;
    }

    private boolean answerContainPrivatePlaceHolders(String answer) {
        return answer.contains("{{") && answer.contains("}}");
    }

    @Override
    public void onClearClicked(boolean byUser) {
        this.suggestionsView.setSuggestions(null);
    }

    @Override
    public void onEmptyQuery() {
    }

    @Override
    public void onFoldItemFinished(boolean beforeGoingDown) {
    }

    @Override
    public void fetchBodyForResult(NRCustomContentView view, String resultID, Integer resultHash) {
    }

    @Override
    public void closeAnswer() {
    }

    @Override
    public void onLikeClicked(NRResultTopView view, NRCustomLikeView likeView, String resultId, boolean isLike) {
        NRResult result = view.getmResult();
        if (isLike) {
            this.onLike(result, view, likeView);
        } else if (!isLike) {
            this.onDislike(result, view, likeView, NRLikeType.INCORRECT_ANSWER);
        }
        this.getView().requestFocus();
    }

    private void onLike(NRResult result, final NRResultTopView view, final NRCustomLikeView likeView) {
        result.getFetchedResult().setLikeState(NRQueryResult.LikeState.positive);
        NRFAQLikeParams likeParams = new NRFAQLikeParams(result.getFetchedResult());
        likeParams.setLikeType(NRLikeType.POSITIVE);
        likeParams.setAnswerId(result.getFetchedResult().getId());
        Nanorep.getInstance().likeForFAQResult(likeParams, new Nanorep.OnLikeSentListener(){

            public void onLikeSent(boolean success) {
                if (!success) {
                    view.getmResult().getFetchedResult().setLikeState(NRQueryResult.LikeState.notSelected);
                    likeView.resetLikeView();
                }
            }
        });
    }

    private void onDislike(NRResult result, final NRResultTopView view, final NRCustomLikeView likeView, NRLikeType type) {
        result.getFetchedResult().setLikeState(NRQueryResult.LikeState.negative);
        NRFAQLikeParams likeParams = new NRFAQLikeParams(result.getFetchedResult());
        likeParams.setLikeType(NRLikeType.INCORRECT_ANSWER);
        likeParams.setAnswerId(result.getFetchedResult().getId());
        Nanorep.getInstance().likeForFAQResult(likeParams, new Nanorep.OnLikeSentListener(){

            public void onLikeSent(boolean success) {
                if (!success) {
                    view.getmResult().getFetchedResult().setLikeState(NRQueryResult.LikeState.notSelected);
                    likeView.resetLikeView();
                }
            }
        });
    }

    @Override
    public void onChannelSelected(NRChanneling channeling) {
        NRChannelPresentor presentor = NRChannelStrategy.presentor(this.getContext(), channeling, Nanorep.getInstance());
        String url = presentor.getUrl();
        if (url != null) {
            final RelativeLayout holder = (RelativeLayout)this.getView().findViewById(R.id.fragment_place_holder);
            holder.setVisibility(0);
            NRWebContentFragment webContentFragment = NRWebContentFragment.newInstance(url, null);
            webContentFragment.setListener(new NRWebContentFragment.Listener(){

                @Override
                public void onDismiss() {
                    NRCMainFragment.this.getChildFragmentManager().popBackStack();
                    holder.setVisibility(4);
                    NRCMainFragment.this.getView().requestFocus();
                }
            });
            this.getChildFragmentManager().beginTransaction().setCustomAnimations(R.anim.fade_in, R.anim.fade_out, R.anim.fade_in, R.anim.fade_out).add(R.id.fragment_place_holder, (Fragment)webContentFragment).addToBackStack("linked").commit();
            this.getView().requestFocus();
        } else {
            String permission2 = presentor.getPermission();
            if (permission2 != null) {
                this.setChannelPresentorListener(presentor);
                this.requestPermissions(new String[]{permission2}, 1);
            } else {
                presentor.present();
            }
        }
    }

    @Override
    public void onShareClicked() {
        this.getView().requestFocus();
    }

    @Override
    public void onSelectSuggestion(String suggestion) {
        this.searchBarView.updateEditTextView("");
        this.sendQuestion(suggestion);
    }

    @Override
    public void onLinkedArticleClicked(String articleId) {
    }

    @Override
    public void onLinkClicked(String url) {
        MyWebView webView = new MyWebView(this.getContext(), url, new MyWebView.Listener(){

            @Override
            public void onDismiss() {
                NRCMainFragment.this.content_main.removeViewAt(NRCMainFragment.this.content_main.getChildCount() - 1);
                if (NRCMainFragment.this.content_main.getChildCount() == 0) {
                    NRCMainFragment.this.content_main.setVisibility(8);
                }
                NRCMainFragment.this.getView().requestFocus();
            }
        });
        this.content_main.addView((View)webView);
        this.content_main.setVisibility(0);
        this.getView().requestFocus();
    }

    @Override
    public void onDismiss() {
    }

    private void initConversationFromCache() {
        this.jsons = Nanorep.getInstance().getCachedConversation(this.conversationId);
        if (this.jsons != null) {
            for (int i = 0; i < this.jsons.length(); ++i) {
                JSONObject row = null;
                try {
                    row = this.jsons.getJSONObject(i);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                boolean client = false;
                if (row.names().length() == 1) {
                    client = true;
                }
                this.nrcWebView.loadUrl("javascript:addText(" + client + "," + row + ");");
            }
        } else {
            this.jsons = new JSONArray();
        }
    }

    private void onLocationNeeded() {
        Nanorep.getInstance().getLocationHandler().setListener(new NRLocationHandler.Listener(){

            public void onLocationFound(double lat, double lang) {
                Log.d((String)"Location", (String)("location " + lat + " " + lang));
                NRCMainFragment.this.nrcWebView.loadUrl("javascript:addMap();");
                Nanorep.getInstance().handleConversationStatement(new Nanorep.OnHandleConversationStatementListener(){

                    public void onRecievedStatement(NRHandleConversationStatement handleConversationStatement, NRError error) {
                        NRCMainFragment.this.onRecievedStatement(handleConversationStatement, error, null);
                    }
                }, NRCMainFragment.this.conversationId, "" + lat + "," + lang, null, null);
            }

            public void onPermissionNeeded() {
                NRCMainFragment.this.requestPermissions(new String[]{"android.permission.ACCESS_COARSE_LOCATION"}, 101);
            }
        });
        Nanorep.getInstance().getLocationHandler().fetchCurrentLocation();
    }

    private void answer(final String text, String postback) {
        this.nrcWebView.loadUrl("javascript:addText(true,{\"text\":\"" + text + "\"});");
        Nanorep.getInstance().handleConversationStatement(new Nanorep.OnHandleConversationStatementListener(){

            public void onRecievedStatement(NRHandleConversationStatement handleConversationStatement, NRError error) {
                NRCMainFragment.this.onRecievedStatement(handleConversationStatement, error, text);
            }
        }, this.conversationId, null, postback, null);
    }

    public void onPause() {
        super.onPause();
        if (this.conversationId != null) {
            Nanorep.getInstance().addCachedConversation(this.conversationId, this.jsons);
        }
    }

    private void channeling(String postback) {
        NRChanneling channeling = NRChanneling.channelForParams((HashMap)((HashMap)NRUtilities.jsonStringToPropertyList((String)postback)));
        this.onChannelSelected(channeling);
    }

    private void readMore(final String articleId) {
        if (this.fragment_place_holder.getVisibility() == 0) {
            this.getView().requestFocus();
            return;
        }
        this.fragment_place_holder.setVisibility(0);
        Nanorep.getInstance().getArticleData(articleId, new Nanorep.OnArticleFetchedListener(){

            public void onArticleFetched(NRFAQAnswer faqAnswer, NRError error) {
                if (error == null) {
                    NRCMainFragment.this.searchBarView.dismissKeyboard();
                    faqAnswer.setId(articleId);
                    NRResult result = new NRResult((NRQueryResult)faqAnswer, NRResultItem.RowType.TITLE);
                    NRResultTopView resultTopView = NRCMainFragment.this.getTopView(result);
                    NRCMainFragment.this.content_main.addView((View)resultTopView);
                    NRCMainFragment.this.fragment_place_holder.setVisibility(8);
                    NRCMainFragment.this.content_main.setVisibility(0);
                    resultTopView.openOpenedView(result);
                    NRCMainFragment.this.getView().requestFocus();
                }
            }
        });
    }

    private void openSupportCenterLink(String url) {
        Intent i = new Intent("android.intent.action.VIEW");
        i.setData(Uri.parse((String)url));
        this.startActivity(i);
    }

    private NRResultTopView getTopView(NRResult result) {
        NRResultTopView resultTopView = new NRResultTopView((Context)this.getActivity());
        resultTopView.setListener(this);
        NRCTitleView titleView = new NRCTitleView(this.getContext());
        NRContentView contentView = new NRContentView(this.getContext());
        NRLikeView likeView = new NRLikeView(this.getContext());
        NRCChannelingView channelView = new NRCChannelingView(this.getContext());
        NRCFeedbackView feedbackView = new NRCFeedbackView(this.getContext());
        NRCNegativeFeedbackView negativeFeedbackView = new NRCNegativeFeedbackView(this.getContext());
        resultTopView.setTitleView(titleView);
        resultTopView.setContentView(contentView, this);
        resultTopView.setLikeView(likeView);
        resultTopView.setChannelView(channelView, this);
        ((NRCustomFeedbackView)feedbackView).setCustomLikeView(likeView);
        if (result.getFetchedResult().getChanneling() != null && result.getFetchedResult().getChanneling().size() > 0) {
            ((NRCustomFeedbackView)feedbackView).setCustomChannelView(channelView);
        }
        feedbackView.setCustomNegativeFeedbackView(negativeFeedbackView);
        resultTopView.setFeedbackView(feedbackView);
        return resultTopView;
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.nrPublicPersonalQueries = (NRPublicPersonalQueries)this.getActivity();
        this.nrPrivatePersonalQueries = (NRPrivatePersonalQueries)this.getActivity();
        this.getView().setFocusableInTouchMode(true);
        this.getView().requestFocus();
        View.OnKeyListener onKeyListener = new View.OnKeyListener(){

            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (event.getAction() == 0 && keyCode == 4 && NRCMainFragment.this.content_main.getChildCount() > 0) {
                    NRCMainFragment.this.content_main.removeViewAt(NRCMainFragment.this.content_main.getChildCount() - 1);
                    if (NRCMainFragment.this.content_main.getChildCount() == 0) {
                        NRCMainFragment.this.content_main.setVisibility(8);
                    }
                    return true;
                }
                return false;
            }
        };
        this.getView().setOnKeyListener(onKeyListener);
    }

    public void setConversationIdListener(NRConversationIdListener conversationIdListener) {
        this.conversationIdListener = conversationIdListener;
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == 1 && grantResults[0] == 0) {
            this.channelPresentorListener.present();
        } else if (requestCode == 100 && grantResults[0] == 0) {
            Nanorep.getInstance().getSpeechHandler().initializeVoiceRecognition();
        } else if (requestCode == 101 && grantResults[0] == 0) {
            Nanorep.getInstance().getLocationHandler().fetchCurrentLocation();
        }
    }

    public void setChannelPresentorListener(NRChannelPresentor channelPresentorListener) {
        this.channelPresentorListener = channelPresentorListener;
    }

    private void updateTitleNormalText() {
        ActionBar actionBar = ((AppCompatActivity)this.getActivity()).getSupportActionBar();
        actionBar.setBackgroundDrawable((Drawable)new ColorDrawable(Color.parseColor((String)"#e77817")));
        actionBar.setTitle((CharSequence)"ICICI Bank Demobot");
    }

    public Method isMethodImplemented(Object obj, String methodName) {
        Method[] methods;
        for (Method m : methods = obj.getClass().getDeclaredMethods()) {
            if (!m.getName().contains(methodName)) continue;
            return m;
        }
        return null;
    }

    private Object callMethod(Method bridgeMethod, Object ... args) {
        block5: {
            Object object = this.reflectionObject;
            if (bridgeMethod != null) {
                try {
                    if (args == null) {
                        Class<?>[] params = bridgeMethod.getParameterTypes();
                        if (params.length != 1) {
                            bridgeMethod.invoke(object, new Object[0]);
                        }
                        break block5;
                    }
                    return bridgeMethod.invoke(object, args);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private class NRCWebClient
    extends WebViewClient {
        private NRCWebClient() {
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            return this.openUrl(url);
        }

        @TargetApi(value=21)
        public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
            return this.openUrl(request.getUrl().toString());
        }

        private boolean openUrl(String link) {
            if (link.startsWith(NRCMainFragment.CONVERSATIONAL)) {
                HashMap map = (HashMap)NRUtilities.jsonStringToPropertyList((String)link.replace("conversational://", ""));
                switch ((String)map.get(NRCMainFragment.KIND)) {
                    case "supportCenterLink": {
                        NRCMainFragment.this.openSupportCenterLink((String)map.get("url"));
                        break;
                    }
                    case "readMore": {
                        NRCMainFragment.this.readMore((String)map.get("articleId"));
                        break;
                    }
                    case "channel": {
                        NRCMainFragment.this.channeling((String)map.get("postback"));
                        break;
                    }
                    case "answer": {
                        NRCMainFragment.this.answer((String)map.get("text"), (String)map.get("postback"));
                        break;
                    }
                    case "ready": {
                        NRCMainFragment.this.initConversationFromCache();
                        break;
                    }
                    case "wasHelpful": {
                        break;
                    }
                    case "userOption": {
                        NRCMainFragment.this.answer((String)map.get("text"), (String)map.get("postback"));
                        break;
                    }
                    case "location": {
                        NRCMainFragment.this.onLocationNeeded();
                    }
                }
                return true;
            }
            if (link.startsWith(NRCMainFragment.HTTP)) {
                NRCMainFragment.this.onLinkClicked(link);
                return true;
            }
            return false;
        }

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            NRCMainFragment.this.loadingFinished = false;
            NRCMainFragment.this.fragment_place_holder.setVisibility(0);
        }

        public void onPageFinished(WebView view, String url) {
            if (!NRCMainFragment.this.redirect) {
                NRCMainFragment.this.loadingFinished = true;
            }
            if (NRCMainFragment.this.loadingFinished && !NRCMainFragment.this.redirect) {
                NRCMainFragment.this.fragment_place_holder.setVisibility(8);
                view.clearCache(true);
            } else {
                NRCMainFragment.this.redirect = false;
            }
        }
    }

    public class myJavaScriptInterface {
        @JavascriptInterface
        public void showHTML() {
            NRCMainFragment.this.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    NRCMainFragment.this.nrcWebView.scrollTo(0, NRCMainFragment.this.nrcWebView.computeVerticalScrollRange());
                }
            });
        }
    }

    private static interface Listener {
        public void onAnswerComplete(String var1);
    }
}

