/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Components;

import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.nanorep.nanoclient.Channeling.NRChanneling;
import nanorep.nanowidget.R;

public class NRChannelItem
extends RecyclerView.ViewHolder
implements View.OnClickListener {
    private OnChannelSelectedListener mListener;
    protected NRChanneling mChanneling;
    protected ImageView mIcon;
    protected TextView mTextView;

    public NRChannelItem(View itemView) {
        super(itemView);
        this.mIcon = (ImageView)itemView.findViewById(R.id.channelIcon);
        this.mTextView = (TextView)itemView.findViewById(R.id.channelName);
        itemView.setOnClickListener((View.OnClickListener)this);
    }

    public void setListener(OnChannelSelectedListener listener) {
        this.mListener = listener;
    }

    public NRChanneling getChanneling() {
        return this.mChanneling;
    }

    public void setChanneling(NRChanneling channeling) {
        this.mChanneling = channeling;
        if (this.mTextView != null) {
            this.mTextView.setText((CharSequence)channeling.getButtonText());
        }
        String resName = null;
        switch (channeling.getType()) {
            case PhoneNumber: {
                resName = "channel_call_icon";
                break;
            }
            case ChatForm: {
                resName = "channel_chat_icon";
                break;
            }
            case OpenCustomURL: 
            case ContactForm: {
                resName = "channel_form_icon";
            }
        }
        if (resName != null) {
            this.mIcon.setImageResource(this.itemView.getResources().getIdentifier(resName, "drawable", this.itemView.getContext().getPackageName()));
        }
    }

    public void onClick(View v) {
        this.mListener.onChannelSelected(this.getChanneling());
    }

    public static interface OnChannelSelectedListener {
        public void onChannelSelected(NRChanneling var1);
    }
}

