/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Components;

import android.content.Context;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.ImageButton;
import android.widget.TextView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomSearchBarView;
import nanorep.nanowidget.Components.NREditText;
import nanorep.nanowidget.R;

public class NRCSearchBar
extends NRCustomSearchBarView
implements View.OnClickListener,
TextWatcher,
TextView.OnEditorActionListener {
    ImageButton speechButton;
    TextView sendTextView;
    NREditText editText;

    public NRCSearchBar(Context context) {
        super(context);
        LayoutInflater.from((Context)context).inflate(R.layout.nrc_search_bar, (ViewGroup)this);
    }

    public void onViewAdded(View child) {
        super.onViewAdded(child);
        this.editText = (NREditText)child.findViewById(R.id.searchText);
        this.editText.addTextChangedListener(this);
        this.editText.setOnEditorActionListener(this);
        this.speechButton = (ImageButton)child.findViewById(R.id.speechButton);
        this.speechButton.setOnClickListener((View.OnClickListener)this);
        this.editText.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (event.getAction() == 0 && keyCode == 4) {
                    NRCSearchBar.this.clear();
                    return true;
                }
                return false;
            }
        });
        this.sendTextView = (TextView)child.findViewById(R.id.sendTextView);
        this.sendTextView.setOnClickListener((View.OnClickListener)this);
    }

    private void clear() {
        this.editText.clearFocus();
        this.dismissKeyboard();
        this.mListener.onClearClicked(true);
        this.updateEditTextView("");
    }

    @Override
    public String getText() {
        return this.editText.getText().toString();
    }

    @Override
    public void dismissKeyboard() {
        InputMethodManager imm = (InputMethodManager)this.getContext().getSystemService("input_method");
        imm.hideSoftInputFromWindow(this.editText.getWindowToken(), 0);
    }

    @Override
    public void updateText(String text) {
        this.editText.clearFocus();
        this.editText.setText(text);
    }

    @Override
    public void updateEditTextView(String text) {
        this.editText.removeTextChangedListener(this);
        this.setSpeechSendButtonsVisability(text.length());
        this.updateText(text);
        this.editText.addTextChangedListener(this);
    }

    @Override
    public void setHint(String text) {
        this.editText.setHint(text);
    }

    public void onClick(View v) {
        if (v.equals(this.sendTextView)) {
            this.mListener.searchForText(this.editText.getText().toString());
            this.updateEditTextView("");
            this.editText.requestFocus();
        } else if (v.equals(this.speechButton)) {
            this.mListener.onStartRecording((ImageButton)v);
        }
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    private void setSpeechSendButtonsVisability(int length) {
        this.speechButton.setVisibility(length > 0 ? 8 : 0);
        this.sendTextView.setVisibility(length > 0 ? 0 : 8);
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
        this.setSpeechSendButtonsVisability(s.length());
        if (s.length() == 0) {
            this.mListener.onClearClicked(true);
        }
    }

    public void afterTextChanged(Editable s) {
        if (s != null && s.length() > 0) {
            this.mListener.fetchSuggestionsForText(this.editText.getText().toString());
        } else {
            this.mListener.onEmptyQuery();
        }
    }

    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
        if (actionId == 4) {
            this.mListener.searchForText(this.editText.getText().toString());
            this.updateEditTextView("");
            return true;
        }
        return false;
    }
}

