/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Components;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.nanorep.nanoclient.Channeling.NRChanneling;
import nanorep.nanowidget.Components.AbstractViews.NRCustomChannelView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomFeedbackView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomLikeView;
import nanorep.nanowidget.R;

public class NRCFeedbackView
extends NRCustomFeedbackView {
    private LinearLayout feedbackLayout;
    private LinearLayout negativeFeedbcakContainer;
    private LinearLayout likeChannelContainer;

    public NRCFeedbackView(Context context) {
        super(context);
        LayoutInflater.from((Context)context).inflate(R.layout.nrc_feedback, (ViewGroup)this);
    }

    public void onViewAdded(View child) {
        super.onViewAdded(child);
        this.feedbackLayout = (LinearLayout)child.findViewById(R.id.feedback_layout);
        this.likeChannelContainer = (LinearLayout)child.findViewById(R.id.likeChannelContainer);
        this.negativeFeedbcakContainer = (LinearLayout)child.findViewById(R.id.negativeFeedbcakContainer);
    }

    @Override
    public void addLikeView() {
        this.likeChannelContainer.addView((View)this.customLikeView);
    }

    @Override
    public void addChannelView() {
        this.likeChannelContainer.addView((View)this.customChannelView);
    }

    @Override
    public void addNegativeFeedbackView() {
        this.negativeFeedbcakContainer.addView((View)this.customNegativeFeedbackView);
    }

    @Override
    public void setCustomLikeView(NRCustomLikeView customLikeView) {
        super.setCustomLikeView(customLikeView);
        this.addLikeView();
    }

    @Override
    public void setCustomChannelView(NRCustomChannelView customChannelView) {
        super.setCustomChannelView(customChannelView);
        this.addChannelView();
    }

    @Override
    public void onChannelSelected(NRChanneling channeling) {
        this.mListener.onChannelSelected(channeling);
    }

    @Override
    public void onLikeClicked(NRCustomLikeView likeView, String resultId, boolean isLike) {
        if (!isLike) {
            this.addNegativeFeedbackView();
        }
    }

    @Override
    public void onSubmitClicked(String text) {
        this.mListener.onLikeClicked(this.customLikeView, null, false);
        this.customLikeView.updateText(this.getResources().getString(R.string.thank_you));
        this.customNegativeFeedbackView.dismissKeyboard();
        this.negativeFeedbcakContainer.removeAllViews();
    }

    @Override
    public void onClearClicked() {
        this.customNegativeFeedbackView.dismissKeyboard();
        this.negativeFeedbcakContainer.removeAllViews();
        this.customLikeView.resetLikeView();
    }
}

