package nanorep.nanowidget.Components;

import android.content.Context;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputMethodManager;
import android.widget.ImageButton;
import android.widget.TextView;

import nanorep.nanowidget.Components.AbstractViews.NRCustomSearchBarView;
import nanorep.nanowidget.R;

/**
 * Created by noat on 05/12/2016.
 */
public class NRCSearchBar extends NRCustomSearchBarView implements View.OnClickListener, TextWatcher, TextView.OnEditorActionListener{//, View.OnTouchListener {

    ImageButton speechButton;
    TextView sendTextView;
    NREditText editText;

    public NRCSearchBar(Context context) {
        super(context);
        LayoutInflater.from(context).inflate(R.layout.nrc_search_bar, this);
    }

    @Override
    public void onViewAdded(View child) {
        super.onViewAdded(child);

        editText = (NREditText) child.findViewById(R.id.searchText);
        editText.addTextChangedListener(this);
        editText.setOnEditorActionListener(this);
//        editText.setOnTouchListener(this);


//        InputMethodManager imm = (InputMethodManager) getContext().getSystemService(Context.INPUT_METHOD_SERVICE);
//        imm.toggleSoftInput(InputMethodManager.SHOW_FORCED, 0);

        speechButton = (ImageButton) child.findViewById(R.id.speechButton);
        speechButton.setOnClickListener(this);

        editText.setOnKeyListener(new OnKeyListener() {
            @Override
            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (event.getAction() == KeyEvent.ACTION_DOWN) {
                    if (keyCode == KeyEvent.KEYCODE_BACK) {
                        clear();
                        return true;
                    }
                }
                return false;
            }
        });

        sendTextView = (TextView) child.findViewById(R.id.sendTextView);
        sendTextView.setOnClickListener(this);
    }

    private void clear() {
        editText.clearFocus();
        dismissKeyboard();
        mListener.onClearClicked(true);
        updateEditTextView("");
    }


    @Override
    public String getText() {
        return editText.getText().toString();
    }

    @Override
    public void dismissKeyboard() {
        InputMethodManager imm = (InputMethodManager)getContext().getSystemService(Context.INPUT_METHOD_SERVICE);
        imm.hideSoftInputFromWindow(editText.getWindowToken(), 0);
    }


    @Override
    public void updateText(String text) {
        editText.clearFocus();
        editText.setText(text);
    }

    @Override
    public void updateEditTextView(String text) {
        editText.removeTextChangedListener(this);
        setSpeechSendButtonsVisability(text.length());
        updateText(text);
        editText.addTextChangedListener(this);
    }

    @Override
    public void setHint(String text) {
        editText.setHint(text);
    }

    @Override
    public void onClick(View v) {
        if (v.equals(sendTextView)) {
            mListener.searchForText(editText.getText().toString());
            updateEditTextView("");
            editText.requestFocus();
        } else if (v.equals(speechButton)) {
            mListener.onStartRecording((ImageButton) v);
        }
    }

    @Override
    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    private void setSpeechSendButtonsVisability(int length) {
        speechButton.setVisibility(length > 0 ? GONE : VISIBLE);
        sendTextView.setVisibility(length > 0 ? VISIBLE : GONE);
    }

    @Override
    public void onTextChanged(CharSequence s, int start, int before, int count) {
        setSpeechSendButtonsVisability(s.length());

        if (s.length() == 0) {
//            dismissKeyboard();
            mListener.onClearClicked(true);
        }
    }

    @Override
    public void afterTextChanged(Editable s) {
        if (s != null && s.length() > 0) {
            mListener.fetchSuggestionsForText(editText.getText().toString());
        } else {
            mListener.onEmptyQuery();
        }
    }

    @Override
    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
        if (actionId == EditorInfo.IME_ACTION_SEND) {
            mListener.searchForText(editText.getText().toString());
            updateEditTextView("");
            return true;
        }
        return false;
    }

//    @Override
//    public boolean onTouch(View v, MotionEvent event) {
//        editText.requestFocus();
//        return false;
//    }
}
