/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Components;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.text.Layout;
import android.text.StaticLayout;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import com.nanorep.nanoclient.Response.NRConfiguration;
import nanorep.nanowidget.Components.AbstractViews.NRCustomTitleView;
import nanorep.nanowidget.R;

public class NRTitleView
extends NRCustomTitleView {
    private Button mTitleButton;
    private ImageButton mUnFoldButton;
    private ImageButton mShareButton;
    private LinearLayout titleLayout;
    private Context context;
    private String textColorAnswer = "#0aa0ff";
    private String textColorFaq = "#4a4a4a";
    private String textFontAnswer = "sans-serif-medium";
    private String textFontFaq = "sans-serif-light";
    private boolean closed = true;

    public NRTitleView(Context context) {
        super(context);
        this.context = context;
        LayoutInflater.from((Context)context).inflate(R.layout.title, (ViewGroup)this);
    }

    public void onViewAdded(View child) {
        super.onViewAdded(child);
        this.titleLayout = (LinearLayout)child.findViewById(R.id.titleLayout);
        this.mTitleButton = (Button)child.findViewById(R.id.titleButton);
        this.mUnFoldButton = (ImageButton)child.findViewById(R.id.unFoldButton);
        this.mUnFoldButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                NRTitleView.this.mListener.onTitleClicked();
            }
        });
        this.mTitleButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                NRTitleView.this.mListener.onTitleClicked();
            }
        });
        this.mShareButton = (ImageButton)child.findViewById(R.id.shareButton);
        this.mShareButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                NRTitleView.this.mListener.onShareClicked();
            }
        });
    }

    private void setUnfoldButtonImage() {
        if (this.mUnFoldButton != null) {
            if (!this.closed) {
                this.mUnFoldButton.setVisibility(4);
            } else {
                this.mUnFoldButton.setVisibility(0);
            }
        }
    }

    @Override
    public void setTitleText(String text) {
        this.mTitleButton.setText((CharSequence)text);
        this.mTitleButton.setMaxLines(2);
    }

    @Override
    public void unfold(boolean closed) {
        this.closed = !closed;
        this.setTitleColor();
        this.setTitleFont();
        this.setUnfoldButtonImage();
        this.setShareImage();
        if (!this.closed) {
            this.collapseTextView(100, 1000L);
            this.mListener.onTitleCollapsed(this.getCollapsedHeight(this.mTitleButton.getText()));
        } else {
            this.collapseTextView(2, 100L);
        }
    }

    private void setTitleFont() {
        String font = this.textFontFaq;
        if (!this.closed) {
            font = this.textFontAnswer;
        }
        this.mTitleButton.setTypeface(Typeface.create((String)font, (int)0));
    }

    private void setShareImage() {
        if (this.closed) {
            this.mShareButton.setVisibility(8);
        }
    }

    private void setTitleColor() {
        String color2 = this.textColorFaq;
        if (!this.closed) {
            color2 = this.textColorAnswer;
        }
        if (!color2.startsWith("#")) {
            color2 = "#" + color2;
        }
        this.mTitleButton.setTextColor(Color.parseColor((String)color2));
    }

    @Override
    public int getTitleHeight(String text) {
        return this.titleLayout.getHeight();
    }

    @Override
    public void resetView() {
        LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)this.titleLayout.getLayoutParams();
        params.leftMargin = 0;
        params.rightMargin = 0;
        this.titleLayout.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    private void collapseTextView(int lines, long duration) {
        ObjectAnimator animation = ObjectAnimator.ofInt((Object)this.mTitleButton, (String)"maxLines", (int[])new int[]{lines});
        animation.setDuration(duration).start();
        animation.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                if (NRTitleView.this.closed) {
                    NRTitleView.this.mListener.onTitleCollapsed(NRTitleView.this.mTitleButton.getHeight());
                }
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
    }

    public int getCollapsedHeight(CharSequence text) {
        int mMeasuredHeight = new StaticLayout(text, this.mTitleButton.getPaint(), this.mTitleButton.getWidth(), Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, true).getHeight();
        if (mMeasuredHeight < this.mTitleButton.getHeight()) {
            mMeasuredHeight = this.mTitleButton.getHeight();
        }
        return mMeasuredHeight;
    }

    public void configViewObjects(NRConfiguration nrConfiguration) {
        NRConfiguration.NRContent content = nrConfiguration.getContent();
        if (content.getAnswerTitleColor() != null && !"".equals(content.getAnswerTitleColor())) {
            this.textColorAnswer = content.getAnswerTitleColor();
        }
        if (content.getAnswerTextFont() != null && !"".equals(content.getAnswerTextFont())) {
            this.textFontAnswer = content.getAnswerTitleFont();
        }
    }

    @Override
    public void setTitleMaxLines(int lines) {
        this.mTitleButton.setMaxLines(lines);
    }
}

