/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Components;

import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Color;
import android.support.annotation.NonNull;
import android.support.v7.app.AlertDialog;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.nanorep.nanoclient.RequestParams.NRLikeType;
import java.util.ArrayList;
import nanorep.nanowidget.R;

public class DislikeDialog
extends AlertDialog.Builder {
    private ListView reasonsList;
    private Listener mListener;
    private ImageView closeButton;
    private Button okButton;
    private NRLikeAdapter adapter;
    private AlertDialog alert;

    public void setListener(Listener listener) {
        this.mListener = listener;
    }

    public DislikeDialog(@NonNull Context context, View dislikeView) {
        super(context);
        this.setView(dislikeView);
        this.reasonsList = (ListView)dislikeView.findViewById(R.id.reasonsList);
        this.closeButton = (ImageView)dislikeView.findViewById(R.id.closeButton);
        this.closeButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DislikeDialog.this.mListener.onCancel();
                DislikeDialog.this.alert.dismiss();
            }
        });
        this.okButton = (Button)dislikeView.findViewById(R.id.okButton);
        this.okButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DislikeDialog.this.mListener.onDislike(DislikeDialog.this.adapter.getSelection());
                DislikeDialog.this.alert.dismiss();
            }
        });
    }

    public void setDislikeOptions(String[] options) {
        this.adapter = new NRLikeAdapter(this.getContext(), R.layout.dislike_row, options);
        DialogInterface.OnClickListener dialogClickListener = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (which == -1 && DislikeDialog.this.adapter.getSelection() != NRLikeType.POSITIVE) {
                    DislikeDialog.this.mListener.onDislike(DislikeDialog.this.adapter.getSelection());
                } else {
                    DislikeDialog.this.mListener.onCancel();
                }
            }
        };
        this.reasonsList.setAdapter((ListAdapter)this.adapter);
        this.alert = this.create();
        this.alert.show();
    }

    public class NRLikeAdapter
    extends ArrayAdapter<String>
    implements View.OnClickListener {
        private String[] mObjects;
        private ArrayList<ImageView> bullets;
        private NRLikeType mSelection;

        public NRLikeAdapter(Context context, int resource, String[] objects) {
            super(context, resource, (Object[])objects);
            this.mSelection = NRLikeType.INCORRECT_ANSWER;
            this.mObjects = objects;
        }

        public NRLikeType getSelection() {
            return this.mSelection;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
            if (convertView == null) {
                convertView = inflater.inflate(R.layout.dislike_row, null);
                convertView.setTag((Object)position);
                convertView.setOnClickListener((View.OnClickListener)this);
                TextView titleView = (TextView)convertView.findViewById(R.id.dislike);
                titleView.setText((CharSequence)this.mObjects[position]);
                if (this.bullets == null) {
                    this.bullets = new ArrayList();
                }
                this.bullets.add((ImageView)convertView.findViewById(R.id.imageView));
            }
            return convertView;
        }

        private int resId(String resName) {
            return this.getContext().getResources().getIdentifier(resName, "drawable", this.getContext().getPackageName());
        }

        public void onClick(View v) {
            switch ((Integer)v.getTag()) {
                case 0: {
                    this.mSelection = NRLikeType.MISSING_INFORMATION;
                    break;
                }
                case 1: {
                    this.mSelection = NRLikeType.IRRELEVANT;
                }
            }
            DislikeDialog.this.okButton.setEnabled(true);
            DislikeDialog.this.okButton.setBackgroundColor(Color.parseColor((String)"#0aa0ff"));
            for (int i = 0; i < this.bullets.size(); ++i) {
                int id2 = (Integer)v.getTag() == i ? this.resId("bullet_on") : this.resId("bullet_off");
                this.bullets.get(i).setImageResource(id2);
            }
        }
    }

    public static interface Listener {
        public void onCancel();

        public void onDislike(NRLikeType var1);
    }
}

