/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Components.ChannelPresenters;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.RequiresApi;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Toast;
import nanorep.nanowidget.R;
import nanorep.nanowidget.Utilities.NRChannelDismissType;

public class NRWebContentFragment
extends Fragment {
    private static final String ARG_PARAM1 = "param1";
    private static final String ARG_PARAM2 = "param2";
    private WebView mWebView;
    private Listener mListener;
    private ValueCallback<Uri[]> mValueCallback;
    private WebChromeClient.FileChooserParams mFileChooserParams;

    public static NRWebContentFragment newInstance(String param1, String param2) {
        NRWebContentFragment fragment = new NRWebContentFragment();
        Bundle args = new Bundle();
        args.putString(ARG_PARAM1, param1);
        args.putString(ARG_PARAM2, param2);
        fragment.setArguments(args);
        return fragment;
    }

    public void setListener(Listener listener) {
        this.mListener = listener;
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_nrweb_content, container, false);
        this.mWebView = (WebView)view.findViewById(R.id.webContentView);
        this.mWebView.loadUrl(this.getArguments().getString(ARG_PARAM1));
        this.mWebView.getSettings().setJavaScriptEnabled(true);
        this.mWebView.getSettings().setAllowFileAccess(true);
        this.mWebView.getSettings().setAllowContentAccess(true);
        this.mWebView.getSettings().setAllowFileAccessFromFileURLs(true);
        this.mWebView.setWebChromeClient(new WebChromeClient(){

            @RequiresApi(api=21)
            public boolean onShowFileChooser(WebView webView, ValueCallback<Uri[]> filePathCallback, WebChromeClient.FileChooserParams fileChooserParams) {
                NRWebContentFragment.this.mValueCallback = filePathCallback;
                NRWebContentFragment.this.mFileChooserParams = fileChooserParams;
                if (ContextCompat.checkSelfPermission((Context)NRWebContentFragment.this.getActivity(), (String)"android.permission.READ_EXTERNAL_STORAGE") != 0) {
                    ActivityCompat.requestPermissions((Activity)NRWebContentFragment.this.getActivity(), (String[])new String[]{"android.permission.READ_EXTERNAL_STORAGE"}, (int)100);
                }
                Intent intent = NRWebContentFragment.this.mFileChooserParams.createIntent();
                try {
                    NRWebContentFragment.this.startActivityForResult(intent, 100);
                }
                catch (ActivityNotFoundException e) {
                    Toast.makeText((Context)NRWebContentFragment.this.getActivity().getApplicationContext(), (CharSequence)"Cannot Open File Chooser", (int)1).show();
                }
                return true;
            }
        });
        this.mWebView.setWebViewClient((WebViewClient)new NRPresentorWebClient());
        return view;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 100 && data != null) {
            this.mValueCallback.onReceiveValue((Object)new Uri[]{data.getData()});
        }
    }

    public void onDetach() {
        super.onDetach();
        this.mWebView.stopLoading();
    }

    public class NRPresentorWebClient
    extends WebViewClient {
        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            if (url.startsWith("nanorep")) {
                switch (NRChannelDismissType.fromUrl(url)) {
                    case Cancelled: {
                        NRWebContentFragment.this.mListener.onDismiss();
                    }
                }
                return true;
            }
            return false;
        }

        @TargetApi(value=21)
        public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
            return request.getUrl().getAuthority().equals("nanorep");
        }
    }

    public static interface Listener {
        public void onDismiss();
    }
}

