/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Fragments;

import android.animation.Animator;
import android.animation.ArgbEvaluator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.text.Spannable;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.nanorep.nanoclient.Handlers.NRErrorHandler;
import com.nanorep.nanoclient.Interfaces.NRQueryResult;
import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.RequestParams.NRLikeType;
import com.nanorep.nanoclient.Response.NRAnswer;
import com.nanorep.nanoclient.Response.NRConfiguration;
import com.nanorep.nanoclient.Response.NRFAQGroupItem;
import java.util.ArrayList;
import java.util.HashMap;
import nanorep.nanowidget.Components.AbstractViews.NRCustomChannelView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomContentView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomLikeView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomSearchBarView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomSuggestionsView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomTitleView;
import nanorep.nanowidget.Components.ChannelPresenters.NRChannelPresentor;
import nanorep.nanowidget.Components.ChannelPresenters.NRChannelStrategy;
import nanorep.nanowidget.Components.ChannelPresenters.NRCustomScriptChannelPresentor;
import nanorep.nanowidget.Components.DislikeDialog;
import nanorep.nanowidget.Components.MyWebView;
import nanorep.nanowidget.Components.NRCategoriesView;
import nanorep.nanowidget.Components.NRChannelItem;
import nanorep.nanowidget.Components.NRChannelingView;
import nanorep.nanowidget.Components.NRContentView;
import nanorep.nanowidget.Components.NRErrorView;
import nanorep.nanowidget.Components.NRLikeView;
import nanorep.nanowidget.Components.NRResultItem;
import nanorep.nanowidget.Components.NRResultTopView;
import nanorep.nanowidget.Components.NRResultsView;
import nanorep.nanowidget.Components.NRSearchBar;
import nanorep.nanowidget.Components.NRSuggestionsView;
import nanorep.nanowidget.Components.NRTitleView;
import nanorep.nanowidget.Components.NRViewAdapter;
import nanorep.nanowidget.DataClasse.NRFetchedDataManager;
import nanorep.nanowidget.DataClasse.NRResult;
import nanorep.nanowidget.DataClasse.NRResultsAdapter;
import nanorep.nanowidget.Fragments.NRWebContentFragment;
import nanorep.nanowidget.R;
import nanorep.nanowidget.Utilities.Calculate;
import nanorep.nanowidget.interfaces.NRConfigFetcherListener;
import nanorep.nanowidget.interfaces.NRCustomViewAdapter;
import nanorep.nanowidget.interfaces.NRFetcherListener;
import nanorep.nanowidget.interfaces.NRSearchBarListener;
import nanorep.nanowidget.interfaces.NRSuggestionsListener;
import nanorep.nanowidget.interfaces.OnFAQAnswerFetched;

public class NRMainFragment
extends Fragment
implements NRSearchBarListener,
NRSuggestionsListener,
NRCategoriesView.Listener,
NRResultsView.Listener,
NRContentView.Listener,
NRChannelItem.OnChannelSelectedListener,
NRResultTopView.Listener,
NRErrorHandler.Listener {
    public static final String TAG = NRMainFragment.class.getName();
    private static final int NO_TITLE_HEIGHT = 100;
    private static final int NO_CONNECTION_HEIGHT = 24;
    private NRFetchedDataManager mFetchedDataManager;
    private NRCustomViewAdapter viewAdapter;
    private RelativeLayout mLoadingView;
    private RelativeLayout fragmentMainLayout;
    private FrameLayout contentMain;
    private LinearLayout searchBarContainer;
    private NRCustomSearchBarView searchBarView;
    private NRCustomSuggestionsView mSuggestionsView;
    private LinearLayout mSuggestionViewContainer;
    private NRCategoriesView categoriesView;
    private boolean resetSuggestions = false;
    private boolean autocompleteEnabled = true;
    private View.OnKeyListener onKeyListener;
    private TextView mNoTitleView;
    private RelativeLayout mNotitleViewHolder;
    private LinearLayout noConnecttionView;
    private boolean animation = false;

    @Override
    public void fetchBodyForResult(final NRCustomContentView view, String resultID, Integer resultHash) {
        this.mFetchedDataManager.faqAnswer(resultID, resultHash, new OnFAQAnswerFetched(){

            @Override
            public void onAnswerFetched(NRQueryResult result) {
                if (result != null) {
                    view.loadData(result.getBody(), "text/html", "UTF-8");
                }
            }
        });
    }

    @Override
    public void closeAnswer() {
        View view = this.contentMain.getChildAt(this.contentMain.getChildCount() - 1);
        if (!this.animation) {
            view.startAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.slide_out_left));
        } else if (view instanceof NRResultTopView && !((NRResultTopView)view).getmResult().isSingle()) {
            ((NRResultTopView)view).setResultUnFoldState(false);
            ((NRResultTopView)view).removeTopView();
        }
        this.contentMain.removeView(view);
    }

    @Override
    public void onChannelSelected(NRChannelItem channelItem) {
        NRChannelPresentor presentor = NRChannelStrategy.presentor(this.getContext(), channelItem.getChanneling(), Nanorep.getInstance());
        if (presentor instanceof NRCustomScriptChannelPresentor) {
            presentor.present();
        } else {
            String url = presentor.getUrl();
            if (url != null) {
                final RelativeLayout holder = (RelativeLayout)this.getView().findViewById(R.id.fragment_place_holder);
                holder.setVisibility(0);
                NRWebContentFragment webContentFragment = NRWebContentFragment.newInstance(url, null);
                webContentFragment.setListener(new NRWebContentFragment.Listener(){

                    @Override
                    public void onDismiss() {
                        NRMainFragment.this.getChildFragmentManager().popBackStack();
                        holder.setVisibility(4);
                        NRMainFragment.this.getView().requestFocus();
                    }
                });
                this.getChildFragmentManager().beginTransaction().setCustomAnimations(R.anim.fade_in, R.anim.fade_out, R.anim.fade_in, R.anim.fade_out).add(R.id.fragment_place_holder, (Fragment)webContentFragment).addToBackStack("linked").commit();
                this.getView().requestFocus();
            }
        }
    }

    private NRQueryResult getCurrentResult() {
        View view = this.contentMain.getChildAt(this.contentMain.getChildCount() - 1);
        if (view instanceof NRResultTopView) {
            return ((NRResultTopView)view).getmResult().getFetchedResult();
        }
        return null;
    }

    @Override
    public void onLinkedArticleClicked(String articleId) {
        this.mFetchedDataManager.faqAnswer(articleId, null, new OnFAQAnswerFetched(){

            @Override
            public void onAnswerFetched(NRQueryResult result) {
                NRResult newResult = new NRResult(result, NRResultItem.RowType.TITLE);
                newResult.setHeight((int)Calculate.pxFromDp(NRMainFragment.this.getContext(), 45.0f));
                newResult.setSingle(true);
                NRResultTopView resultTopView = NRMainFragment.this.getTopView();
                NRMainFragment.this.contentMain.addView((View)resultTopView);
                resultTopView.startAnimation(AnimationUtils.loadAnimation((Context)NRMainFragment.this.getContext(), (int)R.anim.slide_in_left));
                resultTopView.openOpenedView(newResult);
                NRMainFragment.this.getView().requestFocus();
            }
        });
    }

    @Override
    public void onLinkClicked(String url) {
        MyWebView webView = new MyWebView(this.getContext(), url, new MyWebView.Listener(){

            @Override
            public void onDismiss() {
                NRMainFragment.this.contentMain.removeViewAt(NRMainFragment.this.contentMain.getChildCount() - 1);
                NRMainFragment.this.getView().requestFocus();
            }
        });
        this.contentMain.addView((View)webView);
        this.getView().requestFocus();
    }

    @Override
    public void onDismiss() {
        View view = this.contentMain.getChildAt(this.contentMain.getChildCount() - 1);
        if (view instanceof NRResultTopView) {
            view.startAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.slide_out_left));
        }
        this.removeTopView();
    }

    @Override
    public void onLikeClicked(final NRResultTopView view, final NRCustomLikeView likeView, String resultId, boolean isLike) {
        NRResult result = view.getmResult();
        if (isLike) {
            result.getFetchedResult().setLikeState(NRQueryResult.LikeState.positive);
            this.mFetchedDataManager.sendLike(NRLikeType.POSITIVE, result.getFetchedResult(), new Nanorep.OnLikeSentListener(){

                public void onLikeSent(boolean success) {
                    if (!success) {
                        view.getmResult().getFetchedResult().setLikeState(NRQueryResult.LikeState.notSelected);
                        likeView.resetLikeView();
                    }
                }
            });
        } else {
            this.openDislikeDialog(result, view, likeView);
        }
    }

    private void openDislikeDialog(final NRResult result, final NRResultTopView view, final NRCustomLikeView likeView) {
        String[] reasons = new String[]{this.getString(R.string.Incorrect_answer), this.getString(R.string.missing_information), this.getString(R.string.didnt_find)};
        View dislikeView = this.getActivity().getLayoutInflater().inflate(R.layout.dislike_dialog, null);
        DislikeDialog dislikeAlert = new DislikeDialog(this.getContext(), dislikeView);
        dislikeAlert.setListener(new DislikeDialog.Listener(){

            @Override
            public void onCancel() {
                likeView.resetLikeView();
            }

            @Override
            public void onDislike(NRLikeType type) {
                result.getFetchedResult().setLikeState(NRQueryResult.LikeState.negative);
                NRMainFragment.this.mFetchedDataManager.sendLike(type, result.getFetchedResult(), new Nanorep.OnLikeSentListener(){

                    public void onLikeSent(boolean success) {
                        if (!success) {
                            view.getmResult().getFetchedResult().setLikeState(NRQueryResult.LikeState.notSelected);
                            likeView.resetLikeView();
                        }
                    }
                });
            }
        });
        dislikeAlert.setDislikeOptions(reasons);
    }

    public static NRMainFragment newInstance() {
        Bundle args = new Bundle();
        NRMainFragment fragment = new NRMainFragment();
        fragment.setArguments(args);
        return fragment;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (context instanceof NRCustomViewAdapter) {
            this.viewAdapter = (NRCustomViewAdapter)context;
        }
    }

    private void initDataManager() {
        this.mFetchedDataManager = new NRFetchedDataManager(this.getContext(), new NRConfigFetcherListener(){

            @Override
            public void onConfigurationReady() {
                View view = NRMainFragment.this.contentMain.getChildAt(NRMainFragment.this.contentMain.getChildCount() - 1);
                if (view instanceof NRErrorView) {
                    NRMainFragment.this.contentMain.removeView(view);
                }
                NRMainFragment.this.updateTitleNormalText();
                NRMainFragment.this.updateSearchBar();
                NRMainFragment.this.showSuggestionsView();
                NRMainFragment.this.mLoadingView.setVisibility(8);
            }

            @Override
            public void insertRows(ArrayList<NRFAQGroupItem> groups) {
                if (groups.size() > 1) {
                    NRMainFragment.this.categoriesView = new NRCategoriesView((Context)NRMainFragment.this.getActivity());
                    NRMainFragment.this.categoriesView.setListener(NRMainFragment.this);
                    NRMainFragment.this.categoriesView.setCategories(groups, NRMainFragment.this.viewAdapter);
                    NRMainFragment.this.contentMain.addView((View)NRMainFragment.this.categoriesView);
                } else if (groups.size() == 1) {
                    NRMainFragment.this.mFetchedDataManager;
                    NRMainFragment.this.openNRResultView(NRFetchedDataManager.generateNRResultArray(groups.get(0).getAnswers(), NRMainFragment.this.getContext()), groups.get(0).getTitle());
                }
            }

            @Override
            public void onError() {
                NRMainFragment.this.mLoadingView.setVisibility(8);
                ((NRMainFragment)NRMainFragment.this).noConnecttionView.getLayoutParams().height = 0;
                NRMainFragment.this.noConnecttionView.requestLayout();
                NRErrorView errorView = new NRErrorView(NRMainFragment.this.getContext());
                errorView.setListener(new NRErrorView.Listener(){

                    @Override
                    public void tryAgain() {
                        NRMainFragment.this.mFetchedDataManager.fetchConfiguration();
                        NRMainFragment.this.mLoadingView.setVisibility(0);
                    }
                });
                NRMainFragment.this.contentMain.addView((View)errorView);
            }
        });
        this.mFetchedDataManager.setFetcherListener(new NRFetcherListener(){

            @Override
            public void reloadWithAimation() {
            }

            @Override
            public void reload() {
            }

            @Override
            public void insertRows(ArrayList<NRResult> results) {
                if (results == null || results != null && results.size() == 0) {
                    if (NRMainFragment.this.searchBarView.getText() != null) {
                        ((NRMainFragment)NRMainFragment.this).mNotitleViewHolder.getLayoutParams().height = (int)Calculate.pxFromDp(NRMainFragment.this.getContext(), 100.0f);
                        NRMainFragment.this.mNoTitleView.setText((CharSequence)Nanorep.getInstance().getNRConfiguration().getCustomNoAnswersTextContext(NRMainFragment.this.searchBarView.getText()));
                        while (NRMainFragment.this.contentMain.getChildCount() > 2) {
                            NRMainFragment.this.contentMain.removeViewAt(NRMainFragment.this.contentMain.getChildCount() - 1);
                        }
                        NRMainFragment.this.contentMain.setVisibility(0);
                        NRMainFragment.this.getView().requestFocus();
                    }
                } else if (results.size() == 1) {
                    NRResultTopView resultTopView = NRMainFragment.this.getTopView();
                    NRMainFragment.this.contentMain.setVisibility(0);
                    NRMainFragment.this.contentMain.addView((View)resultTopView);
                    Animation animation = AnimationUtils.loadAnimation((Context)NRMainFragment.this.getContext(), (int)R.anim.slide_in_left);
                    animation.setAnimationListener(new Animation.AnimationListener(){

                        public void onAnimationStart(Animation animation) {
                            for (int i = 0; i <= NRMainFragment.this.contentMain.getChildCount() - 2; ++i) {
                                View view = NRMainFragment.this.contentMain.getChildAt(i);
                                view.setVisibility(4);
                            }
                            NRMainFragment.this.contentMain.getChildAt(NRMainFragment.this.contentMain.getChildCount() - 1).setVisibility(0);
                        }

                        public void onAnimationEnd(Animation animation) {
                            for (int i = 0; i <= NRMainFragment.this.contentMain.getChildCount() - 2; ++i) {
                                View view = NRMainFragment.this.contentMain.getChildAt(i);
                                view.setVisibility(0);
                            }
                        }

                        public void onAnimationRepeat(Animation animation) {
                        }
                    });
                    resultTopView.setAnimation(animation);
                    resultTopView.startAnimation(animation);
                    NRResult result = results.get(0);
                    result.setSingle(true);
                    resultTopView.openOpenedView(result);
                    NRMainFragment.this.getView().requestFocus();
                } else if (results.size() > 1) {
                    NRMainFragment.this.contentMain.setVisibility(0);
                    NRMainFragment.this.openNRResultView(results, null);
                }
            }

            @Override
            public void presentSuggestion(String querytext, ArrayList<Spannable> suggestions) {
                if (!NRMainFragment.this.resetSuggestions && NRMainFragment.this.searchBarView.getText().length() - querytext.length() <= 1 && NRMainFragment.this.autocompleteEnabled) {
                    NRMainFragment.this.mSuggestionsView.setSuggestions(suggestions);
                    NRMainFragment.this.contentMain.setVisibility(4);
                }
            }

            @Override
            public void onConnectionFailed(HashMap<String, Object> errorParams) {
            }
        });
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.viewAdapter == null) {
            this.viewAdapter = new NRViewAdapter();
        }
        NRErrorHandler.getInstance().setListener((NRErrorHandler.Listener)this);
    }

    public void onDestroyView() {
        super.onDestroyView();
        Nanorep.getInstance().reset();
    }

    public void onPause() {
        super.onPause();
        NRErrorHandler.getInstance().setListener(null);
    }

    private NRResultTopView getTopView() {
        NRCustomChannelView channelView;
        NRCustomLikeView likeView;
        NRCustomContentView contentView;
        NRResultTopView resultTopView = new NRResultTopView((Context)this.getActivity());
        resultTopView.setListener(this);
        NRCustomTitleView titleView = this.viewAdapter.getTitle(this.getContext());
        if (titleView == null) {
            titleView = new NRTitleView(this.getContext());
            ((NRTitleView)titleView).configViewObjects(Nanorep.getInstance().getNRConfiguration());
        }
        if ((contentView = this.viewAdapter.getContent(this.getContext())) == null) {
            contentView = new NRContentView(this.getContext());
        }
        if ((likeView = this.viewAdapter.getLikeView(this.getContext())) == null) {
            likeView = new NRLikeView(this.getContext());
        }
        if ((channelView = this.viewAdapter.getChannelView(this.getContext())) == null) {
            channelView = new NRChannelingView(this.getContext());
        }
        resultTopView.setTitleView(titleView);
        resultTopView.setContentView(contentView, this);
        resultTopView.setLikeView(likeView);
        resultTopView.setChannelView(channelView, this);
        return resultTopView;
    }

    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_main, container, false);
        this.mLoadingView = (RelativeLayout)view.findViewById(R.id.fragment_place_holder);
        this.contentMain = (FrameLayout)view.findViewById(R.id.content_main);
        this.fragmentMainLayout = (RelativeLayout)view.findViewById(R.id.fragment_main_layout);
        this.mNotitleViewHolder = (RelativeLayout)view.findViewById(R.id.noTiltleView);
        this.mNoTitleView = (TextView)view.findViewById(R.id.noTitleTextView);
        this.noConnecttionView = (LinearLayout)view.findViewById(R.id.noConnecttionView);
        this.setViews(view);
        this.initDataManager();
        return view;
    }

    private void updateSearchBar() {
        NRConfiguration.NRTitle titleConfig = Nanorep.getInstance().getNRConfiguration().getTitle();
        NRConfiguration.NRSearchBar searchBarConfig = Nanorep.getInstance().getNRConfiguration().getSearchBar();
        this.searchBarView.setHint(searchBarConfig.getInitialText());
        String titleBGColor = "#0aa0ff";
        if (!NRMainFragment.isEmpty(titleConfig.getTitleBGColor())) {
            titleBGColor = titleConfig.getTitleBGColor();
        }
        this.searchBarView.setBackgroundColor(Color.parseColor((String)titleBGColor));
    }

    private void updateTitleNormalText() {
        NRConfiguration.NRTitle title = Nanorep.getInstance().getNRConfiguration().getTitle();
        ActionBar actionBar = ((AppCompatActivity)this.getActivity()).getSupportActionBar();
        View customActionBar = this.getActivity().getLayoutInflater().inflate(R.layout.nr_title_bar, null);
        ActionBar.LayoutParams layout2 = new ActionBar.LayoutParams(-1, -1);
        actionBar.setCustomView(customActionBar, layout2);
        actionBar.setDisplayShowHomeEnabled(false);
        actionBar.setDisplayShowTitleEnabled(false);
        actionBar.setDisplayShowCustomEnabled(true);
        Toolbar parent = (Toolbar)customActionBar.getParent();
        parent.setPadding(0, 0, 0, 0);
        parent.setContentInsetsAbsolute(0, 0);
        TextView tv = (TextView)actionBar.getCustomView().findViewById(R.id.titleBarTv);
        String titleText = this.getString(R.string.default_title);
        if (!NRMainFragment.isEmpty(title.getTitle())) {
            titleText = title.getTitle();
        }
        tv.setText((CharSequence)titleText);
        if (!NRMainFragment.isEmpty(title.getTitleColor())) {
            String titleColor = title.getTitleColor();
            tv.setTextColor(Color.parseColor((String)titleColor));
        }
        if (!NRMainFragment.isEmpty(title.getTitleBGColor())) {
            String titleBGColor = title.getTitleBGColor();
            RelativeLayout relativeLayout = (RelativeLayout)actionBar.getCustomView().findViewById(R.id.nrTitleBarLayout);
            relativeLayout.setBackgroundColor(Color.parseColor((String)titleBGColor));
        }
        if (!NRMainFragment.isEmpty(title.getTitleFont())) {
            String titleFont = title.getTitleFont();
            tv.setTypeface(Typeface.create((String)titleFont, (int)0));
        }
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    private void setViews(View nanoView) {
        this.mSuggestionViewContainer = (LinearLayout)nanoView.findViewById(R.id.suggestion_view_container);
        this.mSuggestionsView = this.viewAdapter.getSuggestionsView(this.getContext());
        if (this.mSuggestionsView == null) {
            this.mSuggestionsView = new NRSuggestionsView(this.getContext());
        }
        this.mSuggestionsView.setListener(this);
        this.mSuggestionViewContainer.addView((View)this.mSuggestionsView);
        this.searchBarContainer = (LinearLayout)nanoView.findViewById(R.id.search_bar_container);
        this.searchBarView = this.viewAdapter.getSearchBar(this.getContext());
        if (this.searchBarView == null) {
            this.searchBarView = new NRSearchBar(this.getContext());
        }
        this.searchBarView.setListener(this);
        this.searchBarContainer.addView((View)this.searchBarView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
    }

    @Override
    public void onStartRecording(ImageButton button) {
    }

    @Override
    public void fetchSuggestionsForText(String text) {
        this.hideNoTitleView();
        this.resetSuggestions = false;
        this.mFetchedDataManager.searchSuggestion(text);
    }

    @Override
    public void searchForText(String text) {
        this.resetSuggestions = true;
        this.mSuggestionsView.setSuggestions(null);
        this.mFetchedDataManager.searchText(text);
    }

    @Override
    public void onClearClicked(boolean byUser) {
        if (this.mNotitleViewHolder.getLayoutParams().height > 0) {
            this.mNotitleViewHolder.getLayoutParams().height = 0;
        }
        this.resetSuggestions = true;
        this.mSuggestionsView.setSuggestions(null);
        while (this.contentMain.getChildCount() > 1) {
            this.contentMain.removeViewAt(this.contentMain.getChildCount() - 1);
        }
        this.contentMain.setVisibility(0);
    }

    @Override
    public void onEmptyQuery() {
    }

    private void hideNoTitleView() {
        if (this.mNotitleViewHolder.getLayoutParams().height > 0) {
            this.mNotitleViewHolder.getLayoutParams().height = 0;
        }
    }

    @Override
    public void onSelectSuggestion(String suggestion) {
        this.resetSuggestions = true;
        this.searchBarView.dismissKeyboard();
        this.searchBarView.updateEditTextView(suggestion);
        this.resetSuggestions = true;
        this.mSuggestionsView.setSuggestions(null);
        this.mFetchedDataManager.searchText(suggestion);
    }

    private void showSuggestionsView() {
        if (!Nanorep.getInstance().getNRConfiguration().getAutocompleteEnabled()) {
            this.autocompleteEnabled = false;
        }
    }

    @Override
    public void onCategorySelected(NRFAQGroupItem groupItem) {
        this.openNRResultView(NRFetchedDataManager.generateNRResultArray(groupItem.getAnswers(), this.getContext()), groupItem.getTitle());
    }

    private void openNRResultView(ArrayList<NRResult> results, String title) {
        NRResultsView resultsView = new NRResultsView((Context)this.getActivity());
        resultsView.setListener(this);
        resultsView.setResults(results, title, this.viewAdapter);
        resultsView.setIsAnimated(this.animation);
        this.contentMain.addView((View)resultsView);
        if (this.getView() != null) {
            this.getView().requestFocus();
        }
    }

    @Override
    public void onResultSelected(int y, NRResultsAdapter.ViewHolder titleViewHolder) {
        NRResultTopView resultTopView = this.getTopView();
        this.contentMain.addView((View)resultTopView);
        this.animateBGColor(500, (View)resultTopView, true, titleViewHolder);
        NRResult result = titleViewHolder.getResult();
        result.setUnfolded(true);
        if (this.animation) {
            resultTopView.openView(y, result);
        } else {
            resultTopView.startAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.slide_in_left));
            resultTopView.openOpenedView(result);
        }
        this.getView().requestFocus();
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.getView().setFocusableInTouchMode(true);
        this.getView().requestFocus();
        this.onKeyListener = new View.OnKeyListener(){

            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (event.getAction() == 0) {
                    if (keyCode == 4) {
                        NRMainFragment.this.hideNoTitleView();
                        NRMainFragment.this.searchBarView.updateEditTextView("");
                        if (NRMainFragment.this.getChildFragmentManager().getBackStackEntryCount() > 0) {
                            NRMainFragment.this.getChildFragmentManager().popBackStack();
                            NRMainFragment.this.getView().findViewById(R.id.fragment_place_holder).setVisibility(4);
                            NRMainFragment.this.getView().requestFocus();
                            return true;
                        }
                        if (NRMainFragment.this.mSuggestionsView.getHeight() > 0) {
                            NRMainFragment.this.resetSuggestions = true;
                            NRMainFragment.this.mSuggestionsView.setSuggestions(null);
                            NRMainFragment.this.contentMain.setVisibility(0);
                            return true;
                        }
                        if (NRMainFragment.this.contentMain.getChildCount() > 1) {
                            View view = NRMainFragment.this.contentMain.getChildAt(NRMainFragment.this.contentMain.getChildCount() - 1);
                            if (!NRMainFragment.this.animation) {
                                if (view instanceof NRResultTopView) {
                                    view.startAnimation(AnimationUtils.loadAnimation((Context)NRMainFragment.this.getContext(), (int)R.anim.slide_out_left));
                                }
                                NRMainFragment.this.removeTopView();
                            } else if (view instanceof NRResultTopView) {
                                if (!((NRResultTopView)view).getmResult().isSingle()) {
                                    ((NRResultTopView)view).setResultUnFoldState(false);
                                    ((NRResultTopView)view).removeTopView();
                                    NRMainFragment.this.updateSearchBarTextForResultTop(view);
                                } else {
                                    view.startAnimation(AnimationUtils.loadAnimation((Context)NRMainFragment.this.getContext(), (int)R.anim.slide_out_left));
                                    NRMainFragment.this.removeTopView();
                                }
                            } else {
                                NRMainFragment.this.removeTopView();
                            }
                            return true;
                        }
                        return false;
                    }
                    return false;
                }
                return false;
            }
        };
        this.getView().setOnKeyListener(this.onKeyListener);
    }

    private void removeTopView() {
        this.contentMain.removeViewAt(this.contentMain.getChildCount() - 1);
        View currentView = this.contentMain.getChildAt(this.contentMain.getChildCount() - 1);
        if (currentView instanceof NRResultTopView) {
            this.updateSearchBarTextForResultTop(currentView);
        } else {
            this.searchBarView.updateEditTextView("");
            this.getView().requestFocus();
        }
    }

    private void updateSearchBarTextForResultTop(View view) {
        if (((NRResultTopView)view).getmResult().getFetchedResult() instanceof NRAnswer) {
            this.searchBarView.updateEditTextView(((NRResultTopView)view).getmResult().getFetchedResult().getTitle());
            this.resetSuggestions = true;
            this.mSuggestionsView.setSuggestions(null);
            this.contentMain.setVisibility(0);
            this.getView().requestFocus();
        }
    }

    private void fadeViews(View view, float f, long duration, final boolean removeTopTitle) {
        view.animate().alpha(f).setDuration(duration).setListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                if (removeTopTitle) {
                    NRMainFragment.this.contentMain.removeViewAt(NRMainFragment.this.contentMain.getChildCount() - 1);
                }
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
    }

    @Override
    public void onFoldItemFinished(boolean beforeGoingDown) {
        if (beforeGoingDown) {
            this.animateBGColor(50, this.contentMain.getChildAt(this.contentMain.getChildCount() - 1), false, null);
        } else {
            this.fadeViews(this.contentMain.getChildAt(this.contentMain.getChildCount() - 1), 0.0f, 500L, true);
        }
    }

    private void animateBGColor(int milliseconds, final View view, final boolean unfold, final NRResultsAdapter.ViewHolder titleViewHolder) {
        int colorFrom = this.getResources().getColor(R.color.nr_background_color);
        int colorTo = this.getResources().getColor(R.color.white);
        if (!unfold) {
            colorFrom = -1;
            colorTo = this.getResources().getColor(R.color.nr_background_color);
        }
        ValueAnimator colorAnimation = ValueAnimator.ofObject((TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{colorFrom, colorTo});
        colorAnimation.setDuration((long)milliseconds);
        colorAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animator) {
                view.setBackgroundColor(((Integer)animator.getAnimatedValue()).intValue());
            }
        });
        colorAnimation.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                if (unfold) {
                    titleViewHolder.getTitleView().setVisibility(0);
                }
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        if (unfold) {
            colorAnimation.setStartDelay(300L);
        }
        colorAnimation.start();
    }

    public void show(NRErrorHandler.ErrorType errorType) {
        switch (errorType) {
            case TIMEOUT_UPPER_LINE: {
                View view = this.contentMain.getChildAt(this.contentMain.getChildCount() - 1);
                if (view instanceof NRErrorView) break;
                this.noConnecttionView.getLayoutParams().height = (int)Calculate.pxFromDp(this.getContext(), 24.0f);
                this.searchBarView.dismissKeyboard();
            }
        }
    }

    public void dismiss() {
        this.noConnecttionView.getLayoutParams().height = 0;
        this.noConnecttionView.requestLayout();
    }
}

