/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Components;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.RelativeLayout;
import com.nanorep.nanoclient.Response.NRHtmlParser;
import nanorep.nanowidget.Components.AbstractViews.NRCustomContentView;
import nanorep.nanowidget.R;

public class NRContentView
extends NRCustomContentView
implements View.OnKeyListener {
    private WebView mWebView;
    private RelativeLayout mLoadingView;
    boolean loadingFinished = true;
    boolean redirect = false;

    public NRContentView(Context context) {
        super(context);
        LayoutInflater.from((Context)context).inflate(R.layout.content, (ViewGroup)this);
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    public void onViewAdded(View child) {
        super.onViewAdded(child);
        this.mWebView = (WebView)child.findViewById(R.id.nrWebview);
        this.mWebView.setOnKeyListener((View.OnKeyListener)this);
        this.mWebView.getSettings().setJavaScriptEnabled(true);
        this.mWebView.setWebViewClient((WebViewClient)new NRWebClient(){

            public void onPageStarted(WebView view, String url, Bitmap facIcon) {
                NRContentView.this.loadingFinished = false;
                NRContentView.this.mLoadingView.setVisibility(0);
            }

            public void onPageFinished(WebView view, String url) {
                if (!NRContentView.this.redirect) {
                    NRContentView.this.loadingFinished = true;
                }
                if (NRContentView.this.loadingFinished && !NRContentView.this.redirect) {
                    NRContentView.this.mLoadingView.setVisibility(4);
                } else {
                    NRContentView.this.redirect = false;
                }
            }
        });
        this.mWebView.setWebChromeClient(new WebChromeClient(){});
        this.mLoadingView = (RelativeLayout)child.findViewById(R.id.webLoadingView);
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.mWebView.requestDisallowInterceptTouchEvent(true);
        return super.onTouchEvent(event);
    }

    @Override
    public void setListener(Listener listener) {
        this.mListener = listener;
    }

    @Override
    public void loadData(String data, String mimeType, String encoding) {
        NRHtmlParser parser = new NRHtmlParser(data);
        String parsed = parser.getParsedHtml();
        String script = "\n<style>\n        img {\n            max-width: 100% !important;\n            height: auto !important;\n            }\n        body {\n            font-family: Roboto-Light;\n            color: #6c6c6c;\n            }\n</style>\n\n\n<script>\n\t\t(function() {\n\t\t\tvar embeds = document.querySelectorAll('iframe');\n\t\t\tfor (var i = 0, embed, content, width, height, ratio, wrapper; i < embeds.length; i++) {\n\t\t\t\tembed = embeds[i];\n\t\t\t\twidth = embed.getAttribute('width'),\n\t\t\t\theight = embed.getAttribute('height')\n\t\t\t\tratio = width / height;\n\n\t\t\t\t// skip frames with relative dimensions\n\t\t\t\tif (isNaN(ratio)) continue;\n\n\t\t\t\t// set wrapper styles\n\t\t\t\twrapper = document.createElement('div');\n\t\t\t\twrapper.style.position = 'relative';\n\t\t\t\twrapper.style.width = width.indexOf('%') < 0 ? parseFloat(width) + 'px' : width;\n\t\t\t\twrapper.style.maxWidth = '100%';\n\n\t\t\t\t// set content styles\n\t\t\t\tcontent = document.createElement('div');\n\t\t\t\tcontent.style.paddingBottom = 100 / ratio + '%';\n\n\t\t\t\t// set embed styles\n\t\t\t\tembed.style.position = 'absolute';\n\t\t\t\tembed.style.width = '100%';\n\t\t\t\tembed.style.height = '100%';\n\n\t\t\t\t// update DOM structure\n\t\t\t\tembed.parentNode.insertBefore(wrapper, embed);\n\t\t\t\tcontent.appendChild(embed);\n\t\t\t\twrapper.appendChild(content);\n\t\t\t}\n\t\t}());\n\t</script>";
        parsed = parsed + script;
        this.mWebView.loadDataWithBaseURL("file://", parsed, mimeType, encoding, "file://");
    }

    @Override
    public void loadUrl(String url) {
        this.mWebView.loadUrl(url);
    }

    public boolean onKey(View v, int keyCode, KeyEvent event) {
        if (event.getAction() == 0 && keyCode == 4) {
            this.mListener.onDismiss();
            return true;
        }
        return false;
    }

    private class NRWebClient
    extends WebViewClient {
        private NRWebClient() {
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            return this.linkedArticle(url);
        }

        @TargetApi(value=21)
        public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
            return this.linkedArticle(request.getUrl().toString());
        }

        private boolean linkedArticle(String link) {
            if (link.startsWith("nanorep")) {
                String[] comps = link.split("/");
                if (comps != null && comps.length > 0) {
                    NRContentView.this.mListener.onLinkedArticleClicked(comps[comps.length - 1]);
                }
                return true;
            }
            if (link.startsWith("http")) {
                NRContentView.this.mListener.onLinkClicked(link);
                return true;
            }
            return false;
        }
    }

    public static interface Listener {
        public void onLinkedArticleClicked(String var1);

        public void onLinkClicked(String var1);

        public void onDismiss();
    }
}

