/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Components;

import android.content.Context;
import android.content.DialogInterface;
import android.support.annotation.NonNull;
import android.support.v7.app.AlertDialog;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.nanorep.nanoclient.RequestParams.NRLikeType;
import nanorep.nanowidget.DataClasse.NRLikeAdapter;
import nanorep.nanowidget.R;

public class DislikeDialog
extends AlertDialog.Builder {
    private ListView reasonsList;
    private Listener mListener;
    private ImageView closeButton;
    private Button okButton;
    private NRLikeAdapter adapter;
    private AlertDialog alert;

    public void setListener(Listener listener) {
        this.mListener = listener;
    }

    public DislikeDialog(@NonNull Context context, View dislikeView) {
        super(context);
        this.setView(dislikeView);
        this.reasonsList = (ListView)dislikeView.findViewById(R.id.reasonsList);
        this.closeButton = (ImageView)dislikeView.findViewById(R.id.closeButton);
        this.closeButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DislikeDialog.this.mListener.onCancel();
                DislikeDialog.this.alert.dismiss();
            }
        });
        this.okButton = (Button)dislikeView.findViewById(R.id.okButton);
        this.okButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DislikeDialog.this.mListener.onDislike(DislikeDialog.this.adapter.getSelection());
                DislikeDialog.this.alert.dismiss();
            }
        });
    }

    public void setDislikeOptions(String[] options) {
        this.adapter = new NRLikeAdapter(this.getContext(), R.layout.dislike_row, options);
        DialogInterface.OnClickListener dialogClickListener = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (which == -1 && DislikeDialog.this.adapter.getSelection() != NRLikeType.POSITIVE) {
                    DislikeDialog.this.mListener.onDislike(DislikeDialog.this.adapter.getSelection());
                } else {
                    DislikeDialog.this.mListener.onCancel();
                }
            }
        };
        this.reasonsList.setAdapter((ListAdapter)this.adapter);
        this.alert = this.create();
        this.alert.show();
    }

    public static interface Listener {
        public void onCancel();

        public void onDislike(NRLikeType var1);
    }
}

