/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.DataClasse;

import android.content.Context;
import android.util.Log;
import com.nanorep.nanoclient.Connection.NRError;
import com.nanorep.nanoclient.Interfaces.NRQueryResult;
import com.nanorep.nanoclient.Interfaces.NRSpeechRecognizerCompletion;
import com.nanorep.nanoclient.NRImpl;
import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.RequestParams.NRFAQLikeParams;
import com.nanorep.nanoclient.RequestParams.NRLikeType;
import com.nanorep.nanoclient.Response.NRFAQAnswer;
import com.nanorep.nanoclient.Response.NRFAQData;
import com.nanorep.nanoclient.Response.NRFAQGroupItem;
import com.nanorep.nanoclient.Response.NRSearchResponse;
import com.nanorep.nanoclient.Response.NRSuggestions;
import java.util.ArrayList;
import nanorep.nanowidget.Components.NRResultItem;
import nanorep.nanowidget.DataClasse.NRResult;
import nanorep.nanowidget.Utilities.Calculate;
import nanorep.nanowidget.interfaces.NRConfigFetcherListener;
import nanorep.nanowidget.interfaces.NRFetcherListener;
import nanorep.nanowidget.interfaces.OnFAQAnswerFetched;

public class NRFetchedDataManager {
    public static final int ROW_HEIGHT = 45;
    private NRFAQData mFaqData;
    private NRFetcherListener mFetcherListener;
    private NRConfigFetcherListener mconfigFetcherListener;
    Context mContext;

    public NRFetchedDataManager(Context context, NRConfigFetcherListener configFetcherListener) {
        this.mContext = context;
        this.mconfigFetcherListener = configFetcherListener;
        this.fetchConfiguration();
    }

    public void fetchConfiguration() {
        NRImpl.getInstance().fetchConfiguration(new Nanorep.OnConfigurationFetchedListener(){

            public void onConfigurationFetched(NRError error) {
                if (error == null) {
                    NRFetchedDataManager.this.mFaqData = NRImpl.getInstance().getNRConfiguration().getFaqData();
                    if (NRImpl.getInstance().getNRConfiguration() != null) {
                        NRFetchedDataManager.this.mconfigFetcherListener.onConfigurationReady();
                        NRFetchedDataManager.this.prepareDatasource();
                    }
                } else if (error != null) {
                    NRFetchedDataManager.this.mconfigFetcherListener.onError();
                }
            }
        }, false);
    }

    public void setFetcherListener(NRFetcherListener listener) {
        this.mFetcherListener = listener;
    }

    public void setConfigFetcherListener(NRConfigFetcherListener mconfigFetcherListener) {
        this.mconfigFetcherListener = mconfigFetcherListener;
    }

    private void prepareDatasource() {
        if (this.mFaqData != null && this.mFaqData.getGroups() != null && this.mFaqData.getGroups().size() > 0) {
            ArrayList groups = this.mFaqData.getGroups();
            this.updateCategoriesResults(groups);
        }
    }

    private void updateCategoriesResults(ArrayList<NRFAQGroupItem> groups) {
        if (groups != null) {
            this.mconfigFetcherListener.insertRows(groups);
        } else {
            this.mconfigFetcherListener.insertRows(null);
        }
    }

    public static ArrayList<NRResult> generateNRResultArray(ArrayList<NRQueryResult> queryResults, Context context) {
        if (queryResults != null) {
            ArrayList<NRResult> results = new ArrayList<NRResult>();
            for (NRQueryResult result : queryResults) {
                NRResult currentResult = new NRResult(result, NRResultItem.RowType.TITLE);
                currentResult.setHeight((int)Calculate.pxFromDp(context, 45.0f));
                results.add(currentResult);
            }
            return results;
        }
        return null;
    }

    public void searchText(String text) {
        NRImpl.getInstance().searchText(text, new Nanorep.OnSearchResultsFetchedListener(){

            public void onSearchResponse(NRSearchResponse response, NRError error) {
                if (error == null) {
                    ArrayList<NRResult> results = NRFetchedDataManager.generateNRResultArray(response.getAnswerList(), NRFetchedDataManager.this.mContext);
                    NRFetchedDataManager.this.mFetcherListener.insertRows(results);
                }
            }
        });
    }

    public void searchSuggestion(final String suggestion) {
        NRImpl.getInstance().suggestionsForText(suggestion, new Nanorep.OnSuggestionsFetchedListener(){

            public void onSuggestionsFetched(NRSuggestions suggestions, NRError error) {
                if (error != null) {
                    Log.d((String)"Fetcher", (String)error.getDomain());
                } else if (suggestions != null && suggestions.getSuggestions() != null) {
                    NRFetchedDataManager.this.mFetcherListener.presentSuggestion(suggestion, suggestions.getSuggestions());
                }
            }
        });
    }

    public void startSpeech(NRSpeechRecognizerCompletion completion) {
    }

    public void sendLike(NRLikeType likeType, NRQueryResult result, Nanorep.OnLikeSentListener completion) {
        NRFAQLikeParams likeParams = new NRFAQLikeParams(result);
        likeParams.setLikeType(likeType);
        likeParams.setAnswerId(result.getId());
        NRImpl.getInstance().likeForFAQResult(likeParams, completion);
    }

    public void resetLike(String resultId) {
        for (NRQueryResult result : ((NRFAQGroupItem)this.mFaqData.getGroups().get(0)).getAnswers()) {
            if (!result.getId().equals(resultId)) continue;
            result.setLikeState(NRQueryResult.LikeState.notSelected);
        }
    }

    public void faqAnswer(String answerId, Integer answerHash, final OnFAQAnswerFetched answerFetcher) {
        NRImpl.getInstance().fetchFAQAnswer(answerId, answerHash, new Nanorep.OnFAQAnswerFetchedListener(){

            public void onFAQAnswerFetched(NRFAQAnswer faqAnswer, NRError error) {
                if (error == null) {
                    answerFetcher.onAnswerFetched((NRQueryResult)faqAnswer);
                } else {
                    answerFetcher.onAnswerFetched(null);
                }
            }
        });
    }

    private void onRequestError(NRError error) {
    }
}

