/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Components;

import android.content.Context;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.Spannable;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import java.util.ArrayList;
import nanorep.nanowidget.Components.AbstractViews.NRCustomSuggestionsView;
import nanorep.nanowidget.Components.NRSuggestionItem;
import nanorep.nanowidget.R;

public class NRSuggestionsView
extends NRCustomSuggestionsView {
    private ArrayList<Spannable> mSuggestions;
    private RecyclerView.Adapter mAdapter;
    private RecyclerView mRecyclerView;

    public NRSuggestionsView(Context context) {
        super(context);
        LayoutInflater.from((Context)context).inflate(R.layout.suggestion_view, (ViewGroup)this);
    }

    @Override
    public void setSuggestions(ArrayList<Spannable> suggestions) {
        if (suggestions == null) {
            this.setHeight(0);
        } else {
            this.setHeight(suggestions.size() * 40);
        }
        this.mSuggestions = suggestions;
        this.mAdapter.notifyDataSetChanged();
    }

    public void onViewAdded(View child) {
        super.onViewAdded(child);
        this.mRecyclerView = (RecyclerView)child.findViewById(R.id.recyclerSuggestions);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.mAdapter = new SuggestionsAdapter();
        this.mRecyclerView.setAdapter(this.mAdapter);
    }

    public void setHeight(int height) {
        LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)this.getLayoutParams();
        params.height = (int)TypedValue.applyDimension((int)1, (float)height, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    public class SuggestionsAdapter
    extends RecyclerView.Adapter<NRSuggestionItem>
    implements NRSuggestionItem.OnSuggestionSelectedListener {
        public NRSuggestionItem onCreateViewHolder(ViewGroup parent, int viewType) {
            View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.suggestion_item, parent, false);
            NRSuggestionItem item = new NRSuggestionItem(view);
            item.setListener(this);
            return item;
        }

        public void onBindViewHolder(NRSuggestionItem holder, int position) {
            holder.setText((Spannable)NRSuggestionsView.this.mSuggestions.get(position));
        }

        public int getItemCount() {
            if (NRSuggestionsView.this.mSuggestions != null) {
                return NRSuggestionsView.this.mSuggestions.size();
            }
            return 0;
        }

        @Override
        public void onSuggestionSelected(String text) {
            NRSuggestionsView.this.mListener.onSelectSuggestion(text);
        }
    }
}

