/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Components;

import android.content.Context;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import java.util.ArrayList;
import java.util.List;
import nanorep.nanowidget.DataClasse.NRResult;
import nanorep.nanowidget.DataClasse.NRResultsAdapter;
import nanorep.nanowidget.R;
import nanorep.nanowidget.Utilities.Calculate;
import nanorep.nanowidget.interfaces.NRCustomViewAdapter;

public class NRResultsView
extends LinearLayout
implements NRResultsAdapter.Listener {
    private RecyclerView mResultsRecyclerView;
    private NRResultsAdapter adapter;
    private Listener listener;
    private boolean isAnimated;

    public void setIsAnimated(boolean isAnimated) {
        this.isAnimated = isAnimated;
    }

    public boolean isAnimated() {
        return this.isAnimated;
    }

    public void setAnimated(boolean isAnimated) {
        this.isAnimated = isAnimated;
    }

    public NRResultsView(Context context) {
        super(context);
        LayoutInflater.from((Context)context).inflate(R.layout.results_view, (ViewGroup)this);
    }

    public void onViewAdded(View child) {
        super.onViewAdded(child);
        this.adapter = new NRResultsAdapter();
        this.mResultsRecyclerView = (RecyclerView)child.findViewById(R.id.resultsView);
        this.mResultsRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.mResultsRecyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public void setResults(ArrayList<NRResult> results, NRCustomViewAdapter viewAdapter) {
        this.adapter.setListener(this);
        this.adapter.setViewAdapter(viewAdapter);
        this.adapter.addItems((List<NRResult>)results);
    }

    @Override
    public void onResultItemSelected(NRResultsAdapter.ViewHolder titleViewHolder, int pos) {
        int marginTop = titleViewHolder.getTitle_container().getHeight() * pos;
        int offSet = this.mResultsRecyclerView.computeVerticalScrollOffset();
        int divider = (int)Calculate.pxFromDp(this.getContext(), 5.0f) * pos;
        int y = marginTop - offSet + (int)Calculate.pxFromDp(this.getContext(), 16.0f) + divider;
        if (this.isAnimated) {
            titleViewHolder.getTitleView().setVisibility(4);
        }
        this.listener.onResultSelected(y, titleViewHolder);
    }

    public static interface Listener {
        public void onResultSelected(int var1, NRResultsAdapter.ViewHolder var2);
    }
}

