/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Components;

import android.content.Context;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import nanorep.nanowidget.R;

public class MyWebView
extends FrameLayout
implements View.OnKeyListener {
    WebView webView;
    RelativeLayout webLoadingView;
    private Listener mListener;

    public MyWebView(Context context, String url, Listener listener) {
        super(context);
        View view = LayoutInflater.from((Context)context).inflate(R.layout.nr_webview_view, (ViewGroup)this);
        this.webView = (WebView)view.findViewById(R.id.nrWebview);
        this.webLoadingView = (RelativeLayout)view.findViewById(R.id.webLoadingView);
        this.webLoadingView.setVisibility(0);
        this.mListener = listener;
        this.webView.setOnKeyListener((View.OnKeyListener)this);
        this.webView.setWebViewClient(new WebViewClient(){

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                MyWebView.this.webLoadingView.setVisibility(8);
            }
        });
        this.webView.loadUrl(url);
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.requestDisallowInterceptTouchEvent(true);
        return super.onTouchEvent(event);
    }

    public boolean onKey(View v, int keyCode, KeyEvent event) {
        if (event.getAction() == 0 && keyCode == 4) {
            if (this.webView.canGoBack()) {
                this.webView.goBack();
            } else {
                this.mListener.onDismiss();
            }
            return true;
        }
        return false;
    }

    public static interface Listener {
        public void onDismiss();
    }
}

