/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Components;

import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.nanorep.nanoclient.Channeling.NRChanneling;
import com.nanorep.nanoclient.Interfaces.NRQueryResult;
import com.nanorep.nanoclient.Response.NRAnswer;
import java.util.ArrayList;
import nanorep.nanowidget.Components.NRChannelingView;
import nanorep.nanowidget.Components.NRLikeView;
import nanorep.nanowidget.Components.NRResultItem;
import nanorep.nanowidget.Components.NRWebView;
import nanorep.nanowidget.DataClasse.NRResult;
import nanorep.nanowidget.R;
import nanorep.nanowidget.Utilities.Calculate;
import nanorep.nanowidget.interfaces.NRResultItemListener;
import nanorep.nanowidget.interfaces.NRViewHolder;

public class NRContentItem
extends NRResultItem {
    private NRWebView mWebView;
    private RelativeLayout mFeedbackView;
    private NRLikeView mLikeView;
    private NRChannelingView mChannelingView;
    private NRResultItemListener mListener;
    private NRResult mResult;
    private String mDomain = "http://my.nanorep.com";

    public NRContentItem(View itemView, int height) {
        super(itemView);
        itemView.getLayoutParams().height = height - (int)Calculate.pxFromDp(itemView.getContext(), 80.0f);
        this.mWebView = (NRWebView)itemView.findViewById(R.id.cv_webview);
        this.mFeedbackView = (RelativeLayout)itemView.findViewById(R.id.cv_feedbackView);
        this.mLikeView = (NRLikeView)itemView.findViewById(R.id.cv_likeView);
        this.mChannelingView = (NRChannelingView)itemView.findViewById(R.id.cv_channelingView);
    }

    public void setDomain(String domain) {
        this.mDomain = domain;
    }

    @Override
    public void setListener(NRResultItemListener listener) {
        this.mListener = listener;
        this.mWebView.setListener(listener);
        this.mLikeView.setListener(listener);
        this.mChannelingView.setListener(listener);
    }

    @Override
    public void setBody(String body) {
        this.mResult.getFetchedResult().setBody(body);
        this.mWebView.loadData(body, "text/html", "UTF-8", this.mDomain);
    }

    public void setChanneling(ArrayList<NRChanneling> channelings) {
        this.mResult.getFetchedResult().setChanneling(channelings);
        if (this.mFeedbackView != null) {
            RelativeLayout.LayoutParams params = null;
            if (channelings == null) {
                params = (RelativeLayout.LayoutParams)this.mFeedbackView.getLayoutParams();
                params.height = (int)Calculate.pxFromDp(this.itemView.getContext(), 50.0f);
            } else if (this.mChannelingView != null) {
                for (NRChanneling channeling : channelings) {
                    channeling.setQueryResult(this.mResult.getFetchedResult());
                }
                this.mChannelingView.setChannelings(channelings);
                params = (RelativeLayout.LayoutParams)this.mFeedbackView.getLayoutParams();
                params.height = (int)Calculate.pxFromDp(this.itemView.getContext(), 100.0f);
            }
            this.mFeedbackView.setLayoutParams((ViewGroup.LayoutParams)params);
            this.mFeedbackView.requestLayout();
        }
    }

    public void resetBody() {
        this.mWebView.loadUrl("about:blank");
    }

    @Override
    public void setResult(NRResult result) {
        this.mResult = result;
        this.mLikeView.setResultId(result.getFetchedResult().getId());
        if (result.getFetchedResult().getLikeState() == NRQueryResult.LikeState.notSelected) {
            this.mLikeView.resetLikeView();
        } else {
            this.mLikeView.updateLikeButton(result.getFetchedResult().getLikeState() == NRQueryResult.LikeState.positive);
        }
        if (!(this.mResult.getFetchedResult() instanceof NRAnswer)) {
            this.mListener.fetchBodyForResult(this, this.mResult.getFetchedResult().getId(), this.mResult.getFetchedResult().getHash());
            return;
        }
        this.setBody(this.mResult.getFetchedResult().getBody());
        if (this.mResult.getFetchedResult().getChanneling() != null) {
            this.setChanneling(this.mResult.getFetchedResult().getChanneling());
        } else {
            RelativeLayout.LayoutParams params = null;
            params = (RelativeLayout.LayoutParams)this.mFeedbackView.getLayoutParams();
            params.height = (int)Calculate.pxFromDp(this.itemView.getContext(), 50.0f);
            this.mFeedbackView.setLayoutParams((ViewGroup.LayoutParams)params);
            this.mFeedbackView.requestLayout();
        }
    }

    @Override
    public NRViewHolder.RowType getRowType() {
        return NRViewHolder.RowType.unfolded;
    }
}

