/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.DataClasse;

import android.content.Context;
import android.util.Log;
import com.nanorep.nanoclient.Connection.NRError;
import com.nanorep.nanoclient.Interfaces.NRQueryResult;
import com.nanorep.nanoclient.Interfaces.NRSpeechRecognizerCompletion;
import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.RequestParams.NRFAQLikeParams;
import com.nanorep.nanoclient.RequestParams.NRLikeType;
import com.nanorep.nanoclient.RequestParams.NRSearchLikeParams;
import com.nanorep.nanoclient.Response.NRConfiguration;
import com.nanorep.nanoclient.Response.NRFAQAnswer;
import com.nanorep.nanoclient.Response.NRFAQData;
import com.nanorep.nanoclient.Response.NRFAQGroupItem;
import com.nanorep.nanoclient.Response.NRSearchResponse;
import com.nanorep.nanoclient.Response.NRSuggestions;
import java.util.ArrayList;
import nanorep.nanowidget.DataClasse.NRResult;
import nanorep.nanowidget.Utilities.Calculate;
import nanorep.nanowidget.interfaces.NRFetcherListener;
import nanorep.nanowidget.interfaces.OnFAQAnswerFetched;

public class NRFetchedDataManager {
    private Nanorep mNanoRep;
    private NRFAQData mFaqData;
    private NRFetcherListener mFetcherListener;
    Context mContext;
    private NRConfiguration mConfiguration;
    private int mRows;

    public NRFetchedDataManager(Nanorep nanoRep, Context context) {
        this.mContext = context;
        if (nanoRep != null) {
            this.mNanoRep = nanoRep;
            this.mNanoRep.fetchConfiguration(new Nanorep.OnConfigurationFetchedListener(){

                public void onConfigurationFetched(NRConfiguration configuration, NRError error) {
                    if (error == null && configuration != null) {
                        NRFetchedDataManager.this.mConfiguration = configuration;
                        NRFetchedDataManager.this.mFaqData = configuration.getFaqData();
                        if (configuration.getTitle() != null) {
                            NRFetchedDataManager.this.mFetcherListener.updateTitle(configuration.getTitle());
                            NRFetchedDataManager.this.prepareDatasource();
                        }
                    } else if (error != null) {
                        NRFetchedDataManager.this.onRequestError(error);
                    }
                }
            });
        }
    }

    public void setFetcherListener(NRFetcherListener listener) {
        this.mFetcherListener = listener;
    }

    public NRConfiguration getConfiguration() {
        return this.mConfiguration;
    }

    private void prepareDatasource() {
        if (this.mFaqData != null && this.mFaqData.getGroups() != null && this.mFaqData.getGroups().size() > 0) {
            ArrayList answers = ((NRFAQGroupItem)this.mFaqData.getGroups().get(0)).getAnswers();
            this.updateResults(answers);
        } else {
            this.mFetcherListener.noFAQs();
        }
    }

    private void updateResults(ArrayList<NRQueryResult> queryResults) {
        if (queryResults != null) {
            ArrayList<NRResult> results = new ArrayList<NRResult>();
            for (NRQueryResult result : queryResults) {
                NRResult currentResult = new NRResult(result);
                currentResult.setHeight((int)Calculate.pxFromDp(this.mContext, 62.0f));
                results.add(currentResult);
            }
            this.mRows = queryResults.size();
            this.mFetcherListener.insertRows(results);
        } else {
            this.mFetcherListener.insertRows(null);
        }
    }

    public Nanorep getNanoRep() {
        return this.mNanoRep;
    }

    public int getRows() {
        return 0;
    }

    public float getHeightForRow(int row) {
        return 0.0f;
    }

    public NRResult resultForRow(int row) {
        return null;
    }

    public void suggestionsForText(String text, Nanorep.OnSuggestionsFetchedListener completion) {
    }

    public void searchText(String text) {
        this.mNanoRep.searchText(text, new Nanorep.OnSearchResultsFetchedListener(){

            public void onSearchResponse(NRSearchResponse response, NRError error) {
                if (error == null) {
                    NRFetchedDataManager.this.updateResults(response.getAnswerList());
                }
            }
        });
    }

    public void searchSuggestion(final String suggestion) {
        this.mNanoRep.suggestionsForText(suggestion, new Nanorep.OnSuggestionsFetchedListener(){

            public void onSuggestionsFetched(NRSuggestions suggestions, NRError error) {
                if (error != null) {
                    Log.d((String)"Fetcher", (String)error.getDomain());
                } else if (suggestions != null && suggestions.getSuggestions() != null) {
                    NRFetchedDataManager.this.mFetcherListener.presentSuggestion(suggestion, suggestions.getSuggestions());
                }
            }
        });
    }

    public void startSpeech(NRSpeechRecognizerCompletion completion) {
    }

    public void sendLike(NRLikeType likeType, NRQueryResult result, Nanorep.OnLikeSentListener completion) {
        if (result.isCNF()) {
            NRFAQLikeParams likeParams = new NRFAQLikeParams(result);
            likeParams.setLikeType(likeType);
            likeParams.setAnswerId(result.getId());
            this.mNanoRep.likeForFAQResult(likeParams, completion);
        } else {
            NRSearchLikeParams likeParams = new NRSearchLikeParams(result);
            likeParams.setFeedbackType(likeType);
            this.mNanoRep.likeForSearchResult(likeParams, completion);
        }
    }

    public void resetLike(String resultId) {
        for (NRQueryResult result : ((NRFAQGroupItem)this.mFaqData.getGroups().get(0)).getAnswers()) {
            if (!result.getId().equals(resultId)) continue;
            result.setLikeState(NRQueryResult.LikeState.notSelected);
        }
    }

    public void faqAnswer(String answerId, Integer answerHash, final OnFAQAnswerFetched answerFetcher) {
        this.mNanoRep.fetchFAQAnswer(answerId, answerHash, new Nanorep.OnFAQAnswerFetchedListener(){

            public void onFAQAnswerFetched(NRFAQAnswer faqAnswer, NRError error) {
                if (error == null) {
                    answerFetcher.onAnswerFetched((NRQueryResult)faqAnswer);
                } else {
                    answerFetcher.onAnswerFetched(null);
                }
            }
        });
    }

    private void onRequestError(NRError error) {
    }
}

