/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Components;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.nanorep.nanoclient.Response.NRHtmlParser;
import nanorep.nanowidget.Components.MyWebView;
import nanorep.nanowidget.R;

public class NRWebView
extends FrameLayout {
    private Listener mListener;
    private MyWebView mWebView;
    private RelativeLayout mLoadingView;

    public NRWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
        LayoutInflater.from((Context)context).inflate(R.layout.webview, (ViewGroup)this);
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    public void onViewAdded(View child) {
        super.onViewAdded(child);
        this.mWebView = (MyWebView)child.findViewById(R.id.nrWebview);
        if (this.mWebView != null) {
            this.mWebView.getSettings().setJavaScriptEnabled(true);
            this.mWebView.setWebViewClient(new NRWebClient());
            this.mWebView.setWebChromeClient(new WebChromeClient(){

                public void onProgressChanged(WebView view, int newProgress) {
                    if (newProgress == 100 && NRWebView.this.mLoadingView.getVisibility() == 0) {
                        NRWebView.this.mLoadingView.setVisibility(4);
                    }
                }
            });
            this.mLoadingView = (RelativeLayout)child.findViewById(R.id.webLoadingView);
        }
    }

    public void setListener(Listener listener) {
        this.mListener = listener;
    }

    public void loadData(String data, String mimeType, String encoding) {
        this.mLoadingView.setVisibility(0);
        NRHtmlParser parser = new NRHtmlParser(data);
        String parsed = parser.getParsedHtml();
        String script = "\n<style>\n        img {\n            max-width: 100% !important;\n            height: auto !important;\n            }\n</style>\n\n\n<script>\n\t\t(function() {\n\t\t\tvar embeds = document.querySelectorAll('iframe');\n\t\t\tfor (var i = 0, embed, content, width, height, ratio, wrapper; i < embeds.length; i++) {\n\t\t\t\tembed = embeds[i];\n\t\t\t\twidth = embed.getAttribute('width'),\n\t\t\t\theight = embed.getAttribute('height')\n\t\t\t\tratio = width / height;\n\n\t\t\t\t// skip frames with relative dimensions\n\t\t\t\tif (isNaN(ratio)) continue;\n\n\t\t\t\t// set wrapper styles\n\t\t\t\twrapper = document.createElement('div');\n\t\t\t\twrapper.style.position = 'relative';\n\t\t\t\twrapper.style.width = width.indexOf('%') < 0 ? parseFloat(width) + 'px' : width;\n\t\t\t\twrapper.style.maxWidth = '100%';\n\n\t\t\t\t// set content styles\n\t\t\t\tcontent = document.createElement('div');\n\t\t\t\tcontent.style.paddingBottom = 100 / ratio + '%';\n\n\t\t\t\t// set embed styles\n\t\t\t\tembed.style.position = 'absolute';\n\t\t\t\tembed.style.width = '100%';\n\t\t\t\tembed.style.height = '100%';\n\n\t\t\t\t// update DOM structure\n\t\t\t\tembed.parentNode.insertBefore(wrapper, embed);\n\t\t\t\tcontent.appendChild(embed);\n\t\t\t\twrapper.appendChild(content);\n\t\t\t}\n\t\t}());\n\t</script>";
        parsed = parsed + script;
        this.mWebView.loadDataWithBaseURL("http://nanorep.invalid/", parsed, mimeType, encoding, null);
    }

    public void loadUrl(String url) {
        this.mWebView.loadUrl(url);
    }

    private class NRWebClient
    extends WebViewClient {
        private NRWebClient() {
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            return this.linkedArticle(url);
        }

        @TargetApi(value=21)
        public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
            return this.linkedArticle(request.getUrl().toString());
        }

        private boolean linkedArticle(String link) {
            if (link.startsWith("nanorep")) {
                String[] comps = link.split("/");
                if (comps != null && comps.length > 0) {
                    NRWebView.this.mListener.onLinkedArticleClicked(comps[comps.length - 1]);
                }
                return true;
            }
            if (link.startsWith("http")) {
                NRWebView.this.mListener.onLinkClicked(link);
                return true;
            }
            return false;
        }
    }

    public static interface Listener {
        public void onLinkedArticleClicked(String var1);

        public void onLinkClicked(String var1);
    }
}

