/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v7.widget.RecyclerView;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.nanorep.nanoclient.Interfaces.NRQueryResult;
import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.RequestParams.NRLikeType;
import java.util.ArrayList;
import java.util.HashMap;
import nanorep.nanowidget.Components.ChannelPresenters.NRChannelStrategy;
import nanorep.nanowidget.Components.ChannelPresenters.NRWebContentFragment;
import nanorep.nanowidget.Components.DislikeDialog;
import nanorep.nanowidget.Components.NRChannelItem;
import nanorep.nanowidget.Components.NRContentItem;
import nanorep.nanowidget.Components.NRLikeView;
import nanorep.nanowidget.Components.NRResultFragment;
import nanorep.nanowidget.Components.NRResultItem;
import nanorep.nanowidget.Components.NRSearchBar;
import nanorep.nanowidget.Components.NRSuggestionsView;
import nanorep.nanowidget.DataClasse.NRFetchedDataManager;
import nanorep.nanowidget.DataClasse.NRResult;
import nanorep.nanowidget.R;
import nanorep.nanowidget.Utilities.Calculate;
import nanorep.nanowidget.Utilities.NRItemAnimator;
import nanorep.nanowidget.Utilities.NRLinearLayoutManager;
import nanorep.nanowidget.interfaces.NRFetcherListener;
import nanorep.nanowidget.interfaces.NRResultItemListener;
import nanorep.nanowidget.interfaces.NRSearchBarListener;
import nanorep.nanowidget.interfaces.NRSuggestionsListener;
import nanorep.nanowidget.interfaces.NRViewHolder;
import nanorep.nanowidget.interfaces.OnFAQAnswerFetched;

public class NRWidgetFragment
extends Fragment
implements NRSearchBarListener,
NRSuggestionsListener,
NRResultItemListener {
    private static final String ARG_PARAM1 = "param1";
    private static final String ARG_PARAM2 = "param2";
    private Nanorep mNanoRep;
    private String mParam1;
    private String mParam2;
    private NRFetchedDataManager mFetchedDataManager;
    private NRSearchBar mSearchBar;
    private NRSuggestionsView mSuggestionsView;
    private ArrayList<NRResult> mQueryResults;
    private ArrayList<NRResult> mQueryCopyResults;
    private NRResutlsAdapter mResutlsAdapter;
    private RecyclerView mResultsRecyclerView;
    private NRWidgetFragmentListener mListener;
    private NRResultFragment mResultFragment;
    private RelativeLayout mLoadingView;
    private ArrayList<ArrayList<NRResult>> mResultStack;
    private ArrayList<String> mSearchStrings;
    private NRResult mUnfoldedResult;
    private boolean resetSuggestions = false;
    private TextView mNoTitleView;
    private RelativeLayout mNotitleViewHolder;

    private ArrayList<String> getSearchStrings() {
        if (this.mSearchStrings == null) {
            this.mSearchStrings = new ArrayList();
            this.mSearchStrings.add("");
        }
        return this.mSearchStrings;
    }

    @Override
    public void onChannelSelected(NRChannelItem channelItem) {
        String url = NRChannelStrategy.presentor(this.getContext(), channelItem.getChanneling(), this.mNanoRep).getUrl();
        if (url != null) {
            this.onLinkClicked(url);
        }
    }

    @Override
    public void onLinkedArticleClicked(String articleId) {
        this.mFetchedDataManager.faqAnswer(articleId, null, new OnFAQAnswerFetched(){

            @Override
            public void onAnswerFetched(final NRQueryResult result) {
                NRWidgetFragment.this.clearResults();
                NRWidgetFragment.this.mResultsRecyclerView.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        NRWidgetFragment.this.getSearchStrings().add("");
                        NRResult newResult = new NRResult(result);
                        newResult.getFetchedResult().setIsCNF(true);
                        newResult.setHeight((int)Calculate.pxFromDp(NRWidgetFragment.this.getContext(), 62.0f));
                        ArrayList<NRResult> linkedArray = new ArrayList<NRResult>();
                        linkedArray.add(newResult);
                        NRWidgetFragment.this.loadResults(linkedArray, true);
                    }
                }, 500L);
            }
        });
    }

    @Override
    public void onLinkClicked(String url) {
        final RelativeLayout holder = (RelativeLayout)this.getView().findViewById(R.id.fragment_place_holder);
        holder.setVisibility(0);
        NRWebContentFragment webContentFragment = NRWebContentFragment.newInstance(url, null);
        webContentFragment.setListener(new NRWebContentFragment.Listener(){

            @Override
            public void onDismiss() {
                NRWidgetFragment.this.getChildFragmentManager().popBackStack();
                holder.setVisibility(4);
                NRWidgetFragment.this.getView().requestFocus();
            }
        });
        this.getChildFragmentManager().beginTransaction().setCustomAnimations(R.anim.fade_in, R.anim.fade_out, R.anim.fade_in, R.anim.fade_out).add(R.id.fragment_place_holder, (Fragment)webContentFragment).addToBackStack("linked").commit();
    }

    @Override
    public void onLikeClicked(final NRLikeView likeView, String resultId, boolean isLike) {
        if (this.mQueryResults == null || this.mQueryResults.size() == 0) {
            return;
        }
        final NRResult likedResult = this.mQueryResults.get(0);
        if (!likedResult.getFetchedResult().getId().equals(resultId)) {
            return;
        }
        if (isLike) {
            likedResult.getFetchedResult().setLikeState(NRQueryResult.LikeState.positive);
            this.mFetchedDataManager.sendLike(NRLikeType.POSITIVE, likedResult.getFetchedResult(), new Nanorep.OnLikeSentListener(){

                public void onLikeSent(String resultId, int type, boolean success) {
                    for (NRResult result : NRWidgetFragment.this.mQueryResults) {
                        if (!result.getFetchedResult().getId().equals(resultId) || success) continue;
                        result.getFetchedResult().setLikeState(NRQueryResult.LikeState.notSelected);
                        break;
                    }
                }
            });
        } else {
            String[] reasons = new String[]{"Incorrect answer", "Missing or incorrect information", "Didn't find what I was looking for"};
            DislikeDialog dislikeAlert = new DislikeDialog(this.getContext());
            dislikeAlert.setTitle("What's wrong with this answer");
            dislikeAlert.setListener(new DislikeDialog.Listener(){

                @Override
                public void onCancel() {
                    likeView.resetLikeView();
                }

                @Override
                public void onDislike(NRLikeType type) {
                    likedResult.getFetchedResult().setLikeState(NRQueryResult.LikeState.negative);
                    NRWidgetFragment.this.mFetchedDataManager.sendLike(type, likedResult.getFetchedResult(), new Nanorep.OnLikeSentListener(){

                        public void onLikeSent(String resultId, int type, boolean success) {
                            for (NRResult result : NRWidgetFragment.this.mQueryResults) {
                                if (!result.getFetchedResult().getId().equals(resultId) || success) continue;
                                result.getFetchedResult().setLikeState(NRQueryResult.LikeState.notSelected);
                                break;
                            }
                        }
                    });
                }
            });
            dislikeAlert.setDislikeOptions(reasons);
        }
    }

    public static NRWidgetFragment newInstance(String param1, String param2) {
        NRWidgetFragment fragment = new NRWidgetFragment();
        Bundle args = new Bundle();
        args.putString(ARG_PARAM1, param1);
        args.putString(ARG_PARAM2, param2);
        fragment.setArguments(args);
        return fragment;
    }

    public void setNanoRep(Nanorep nanoRep) {
        this.mNanoRep = nanoRep;
    }

    private NRResultFragment getResultFragment() {
        if (this.mResultFragment == null) {
            this.mResultFragment = new NRResultFragment();
        }
        return this.mResultFragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            this.mParam1 = this.getArguments().getString(ARG_PARAM1);
            this.mParam2 = this.getArguments().getString(ARG_PARAM2);
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View nanoView = inflater.inflate(R.layout.fragment_nrwidget, container, false);
        this.mLoadingView = (RelativeLayout)nanoView.findViewById(R.id.fragment_place_holder);
        this.mResutlsAdapter = new NRResutlsAdapter();
        this.mFetchedDataManager = new NRFetchedDataManager(this.mNanoRep, this.getContext());
        this.mFetchedDataManager.setFetcherListener(new NRFetcherListener(){

            @Override
            public void updateTitle(String title) {
            }

            @Override
            public void reloadWithAimation() {
            }

            @Override
            public void reload() {
            }

            @Override
            public void insertRows(ArrayList<NRResult> rows) {
                NRWidgetFragment.this.mLoadingView.setVisibility(4);
                if (rows == null && NRWidgetFragment.this.mSearchBar.getText() != null) {
                    ((NRWidgetFragment)NRWidgetFragment.this).mNotitleViewHolder.getLayoutParams().height = (int)Calculate.pxFromDp(NRWidgetFragment.this.getContext(), 120.0f);
                    NRWidgetFragment.this.mNoTitleView.setText((CharSequence)NRWidgetFragment.this.mFetchedDataManager.getConfiguration().getCustomNoAnswersTextContext(NRWidgetFragment.this.mSearchBar.getText()));
                    if (NRWidgetFragment.this.mResultStack != null) {
                        rows = (ArrayList)NRWidgetFragment.this.mResultStack.get(0);
                    }
                }
                NRWidgetFragment.this.loadResults(rows, true);
            }

            @Override
            public void noFAQs() {
                NRWidgetFragment.this.mLoadingView.setVisibility(4);
            }

            @Override
            public void presentSuggestion(String query, ArrayList<String> suggestions) {
                if (!NRWidgetFragment.this.resetSuggestions && NRWidgetFragment.this.mSearchBar.getText().equals(query)) {
                    NRWidgetFragment.this.mSuggestionsView.setSuggestions(suggestions);
                }
            }

            @Override
            public void onConnectionFailed(HashMap<String, Object> errorParams) {
            }
        });
        this.mSearchBar = (NRSearchBar)nanoView.findViewById(R.id.searchBar);
        this.mSearchBar.setListener(this);
        this.mNotitleViewHolder = (RelativeLayout)nanoView.findViewById(R.id.noTiltleView);
        this.mNoTitleView = (TextView)nanoView.findViewById(R.id.noTitleTextView);
        this.mSuggestionsView = (NRSuggestionsView)nanoView.findViewById(R.id.suggestions);
        this.mSuggestionsView.setListener(this);
        this.mResultsRecyclerView = (RecyclerView)nanoView.findViewById(R.id.resultsView);
        this.mResultsRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new NRLinearLayoutManager(this.getContext()));
        this.mResultsRecyclerView.setAdapter((RecyclerView.Adapter)this.mResutlsAdapter);
        NRItemAnimator animator = new NRItemAnimator();
        animator.setListener(new NRItemAnimator.OnAnimation(){

            @Override
            public void onItemRemoved(NRResultItem item) {
                if (item instanceof NRContentItem) {
                    ((NRContentItem)item).resetBody();
                }
            }
        });
        this.mResultsRecyclerView.setItemAnimator((RecyclerView.ItemAnimator)animator);
        if (Build.VERSION.SDK_INT >= 23) {
            this.mResultsRecyclerView.setOnScrollChangeListener(new View.OnScrollChangeListener(){

                public void onScrollChange(View v, int scrollX, int scrollY, int oldScrollX, int oldScrollY) {
                }
            });
        }
        return nanoView;
    }

    private void loadResults(ArrayList<NRResult> rows, boolean addToStack) {
        if (rows == null) {
            return;
        }
        if (this.mQueryResults == null) {
            this.mQueryResults = new ArrayList();
        }
        if (rows.size() == 1) {
            rows.get(0).setSingle(true);
        }
        for (NRResult addedResult : rows) {
            this.mQueryResults.add(addedResult);
            this.mResutlsAdapter.notifyItemInserted(this.mQueryResults.size());
        }
        if (rows.size() == 1) {
            this.mQueryResults.get(0).setUnfolded(false);
            this.unfoldItem(this.mQueryResults.get(0), false);
        }
        if (addToStack) {
            if (this.mResultStack == null) {
                this.mResultStack = new ArrayList();
            }
            if (!this.mResultStack.contains(this.mQueryResults)) {
                this.mResultStack.add(new ArrayList<NRResult>(this.mQueryResults));
            }
        }
        this.mQueryCopyResults = new ArrayList<NRResult>(this.mQueryResults);
        if (this.getView() != null) {
            this.getView().requestFocus();
        }
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.getView().setFocusableInTouchMode(true);
        this.getView().requestFocus();
        this.getView().setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (event.getAction() == 0 && keyCode == 4) {
                    if (NRWidgetFragment.this.mResultStack != null && NRWidgetFragment.this.mResultStack.size() > 1) {
                        ((NRResultItem)NRWidgetFragment.this.mResultsRecyclerView.findViewHolderForAdapterPosition(0)).resetArrow();
                        NRWidgetFragment.this.clearResults();
                        NRWidgetFragment.this.mResultsRecyclerView.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                if (NRWidgetFragment.this.mUnfoldedResult != null) {
                                    NRWidgetFragment.this.mUnfoldedResult = null;
                                }
                                if (NRWidgetFragment.this.mResultStack.size() >= 2) {
                                    NRWidgetFragment.this.loadResults((ArrayList)NRWidgetFragment.this.mResultStack.get(NRWidgetFragment.this.mResultStack.size() - 2), false);
                                    NRWidgetFragment.this.mSearchBar.updateText((String)NRWidgetFragment.this.getSearchStrings().get(NRWidgetFragment.this.getSearchStrings().size() - 2), true);
                                }
                                NRWidgetFragment.this.getSearchStrings().remove(NRWidgetFragment.this.getSearchStrings().size() - 1);
                                NRWidgetFragment.this.mResultStack.remove(NRWidgetFragment.this.mResultStack.size() - 1);
                            }
                        }, 500L);
                    } else if (NRWidgetFragment.this.mUnfoldedResult != null && NRWidgetFragment.this.mUnfoldedResult.isUnfolded()) {
                        NRWidgetFragment.this.unfoldItem(NRWidgetFragment.this.mUnfoldedResult, false);
                    } else {
                        return false;
                    }
                    return true;
                }
                return false;
            }
        });
    }

    public void setListener(NRWidgetFragmentListener listener) {
        this.mListener = listener;
    }

    public void onCreateOptionsMenu(Menu menu2, MenuInflater inflater) {
        inflater.inflate(R.menu.nano_menu, menu2);
    }

    @Override
    public void onStartRecording(ImageButton button) {
    }

    @Override
    public void fetchSuggestionsForText(String text) {
        if (this.mNotitleViewHolder.getLayoutParams().height > 0) {
            this.mNotitleViewHolder.getLayoutParams().height = 0;
            this.clearResults();
        }
        this.resetSuggestions = false;
        this.mFetchedDataManager.searchSuggestion(text);
        if (this.mUnfoldedResult != null) {
            this.unfoldItem(this.mUnfoldedResult, true);
        } else {
            this.clearResults();
        }
    }

    private void clearResults() {
        if (this.mQueryResults != null) {
            ArrayList<NRResult> temp = new ArrayList<NRResult>(this.mQueryResults);
            if (this.mUnfoldedResult != null) {
                this.unfoldItem(this.mUnfoldedResult, true);
            }
            for (NRResult queryResult : temp) {
                int index = this.mQueryResults.indexOf(queryResult);
                this.mQueryResults.remove(queryResult);
                this.mResutlsAdapter.notifyItemRemoved(index);
            }
            temp.clear();
            this.mQueryResults = null;
        }
    }

    @Override
    public void searchForText(String text) {
        this.mLoadingView.setVisibility(0);
        this.resetSuggestions = true;
        this.mSuggestionsView.setSuggestions(null);
        if (!this.getSearchStrings().get(this.getSearchStrings().size() - 1).equals(text)) {
            this.getSearchStrings().add(text);
            this.mFetchedDataManager.searchText(text);
        }
    }

    @Override
    public void onClearClicked(boolean byUser) {
        if (this.mNotitleViewHolder.getLayoutParams().height > 0) {
            this.mNotitleViewHolder.getLayoutParams().height = 0;
        }
        this.resetSuggestions = true;
        this.mSuggestionsView.setSuggestions(null);
        if (byUser) {
            if (this.mUnfoldedResult != null) {
                this.unfoldItem(this.mUnfoldedResult, true);
            }
            this.clearResults();
            this.mResultsRecyclerView.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (NRWidgetFragment.this.mResultStack != null && NRWidgetFragment.this.mResultStack.size() > 0) {
                        NRWidgetFragment.this.loadResults((ArrayList)NRWidgetFragment.this.mResultStack.get(0), false);
                        NRWidgetFragment.this.mQueryResults = (ArrayList)NRWidgetFragment.this.mResultStack.get(0);
                    }
                    if (NRWidgetFragment.this.mResultStack != null) {
                        NRWidgetFragment.this.mResultStack.clear();
                        NRWidgetFragment.this.getSearchStrings().clear();
                        NRWidgetFragment.this.mResultStack.add(new ArrayList(NRWidgetFragment.this.mQueryResults));
                        NRWidgetFragment.this.getSearchStrings().add("");
                    }
                }
            }, 500L);
        }
    }

    @Override
    public void onEmptyQuery() {
        this.mSuggestionsView.setSuggestions(null);
    }

    @Override
    public void onSelectSuggestion(String suggestion) {
        this.mLoadingView.setVisibility(0);
        this.getSearchStrings().add(suggestion);
        this.mSearchBar.dismissKeyboard();
        this.mSearchBar.updateText(suggestion);
        this.resetSuggestions = true;
        this.mSuggestionsView.setSuggestions(null);
        this.mFetchedDataManager.searchText(suggestion);
    }

    @Override
    public void unfoldItem(NRResult result, boolean clear) {
        if (result.isUnfolded()) {
            this.mUnfoldedResult.setUnfolded(false);
            this.mUnfoldedResult = null;
            this.mQueryResults.remove(1);
            this.mResutlsAdapter.notifyItemRemoved(1);
            if (clear) {
                this.mQueryResults.remove(0);
                this.mResutlsAdapter.notifyItemRemoved(0);
            } else {
                int pos = this.mQueryCopyResults.indexOf(result);
                for (int i = 0; i < this.mQueryCopyResults.size(); ++i) {
                    if (i != pos && this.mQueryCopyResults.size() >= i) {
                        this.mQueryResults.add(i, this.mQueryCopyResults.get(i));
                        this.mResutlsAdapter.notifyItemInserted(i);
                        continue;
                    }
                    ((NRResultItem)this.mResultsRecyclerView.findViewHolderForAdapterPosition(i)).resetArrow();
                }
            }
        } else {
            ArrayList<NRResult> temp = new ArrayList<NRResult>(this.mQueryResults);
            for (NRResult item1 : temp) {
                int pos = this.mQueryResults.indexOf(item1);
                if (item1.equals(result)) continue;
                this.mQueryResults.remove(item1);
                this.mResutlsAdapter.notifyItemRemoved(pos);
            }
            if (this.mQueryResults != null && this.mQueryResults.size() > 0) {
                this.mUnfoldedResult = this.mQueryResults.get(0);
                this.mUnfoldedResult.setUnfolded(true);
                temp.clear();
                NRResult content = new NRResult(result.getFetchedResult());
                content.setRowType(NRViewHolder.RowType.unfolded);
                this.mQueryResults.add(content);
                this.mResutlsAdapter.notifyItemInserted(1);
            }
        }
    }

    private void deleteResult(NRResult result) {
    }

    @Override
    public void onShareClicked(NRResultItem item, String linkToShare) {
        Intent sharingIntent = new Intent("android.intent.action.SEND");
        sharingIntent.setType("text/plain");
        sharingIntent.putExtra("android.intent.extra.SUBJECT", "nanorep Result");
        sharingIntent.putExtra("android.intent.extra.TEXT", linkToShare);
        this.startActivity(Intent.createChooser((Intent)sharingIntent, (CharSequence)"Share via"));
    }

    @Override
    public void fetchBodyForResult(final NRContentItem item, String resultID, Integer resultHash) {
        this.mFetchedDataManager.faqAnswer(resultID, resultHash, new OnFAQAnswerFetched(){

            @Override
            public void onAnswerFetched(NRQueryResult result) {
                item.setBody(result.getBody());
                item.setChanneling(result.getChanneling());
            }
        });
    }

    private class NRResutlsAdapter
    extends RecyclerView.Adapter<NRResultItem> {
        private boolean mShouldResetLikeView = false;

        private NRResutlsAdapter() {
        }

        public void setShouldResetLikeView(boolean shouldResetLikeView) {
            this.mShouldResetLikeView = shouldResetLikeView;
        }

        public NRResultItem onCreateViewHolder(ViewGroup parent, int viewType) {
            int viewId = 0;
            switch (viewType) {
                case 0: {
                    viewId = R.layout.content_item;
                    break;
                }
                case 1: {
                    viewId = R.layout.result_item;
                }
            }
            View view = LayoutInflater.from((Context)parent.getContext()).inflate(viewId, parent, false);
            NRResultItem item = null;
            switch (viewType) {
                case 0: {
                    item = new NRContentItem(view, NRWidgetFragment.this.mResultsRecyclerView.getHeight());
                    break;
                }
                case 1: {
                    item = new NRResultItem(view, NRWidgetFragment.this.mResultsRecyclerView.getHeight());
                }
            }
            if (item != null) {
                item.setListener(NRWidgetFragment.this);
            }
            return item;
        }

        public void onBindViewHolder(NRResultItem holder, int position) {
            if (NRWidgetFragment.this.mQueryResults != null && NRWidgetFragment.this.mQueryResults.size() >= position) {
                holder.setResult((NRResult)NRWidgetFragment.this.mQueryResults.get(position));
            }
        }

        public int getItemViewType(int position) {
            if (NRWidgetFragment.this.mQueryResults == null || NRWidgetFragment.this.mQueryResults.size() < position) {
                return 0;
            }
            switch (((NRResult)NRWidgetFragment.this.mQueryResults.get(position)).getRowType()) {
                case standard: {
                    return 1;
                }
            }
            return 0;
        }

        public int getItemCount() {
            if (NRWidgetFragment.this.mQueryResults == null) {
                return 0;
            }
            return NRWidgetFragment.this.mQueryResults.size();
        }
    }

    public static interface NRWidgetFragmentListener {
        public void onCancelWidget(NRWidgetFragment var1);
    }
}

