/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Components;

import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.webkit.WebView;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.RelativeLayout;
import nanorep.nanowidget.Components.NRChannelingView;
import nanorep.nanowidget.Components.NRLikeView;
import nanorep.nanowidget.DataClasse.NRResult;
import nanorep.nanowidget.R;
import nanorep.nanowidget.interfaces.NRResultItemListener;
import nanorep.nanowidget.interfaces.NRViewHolder;

public class NRResultItem
extends RecyclerView.ViewHolder
implements View.OnClickListener {
    private NRResultItemListener mListener;
    private View mItemView;
    private Button mTitleButton;
    private ImageButton mUnFoldButton;
    private WebView mWebView;
    private RelativeLayout mFooterView;
    private RelativeLayout mActionView;
    private ImageButton mShareButton;
    private NRLikeView mLikeView;
    private NRResult mResult;
    private NRChannelingView mNRChannelingView;

    public NRResultItem(View view) {
        super(view);
    }

    public NRResultItem(View view, int maxHeight) {
        super(view);
        this.mItemView = view;
        this.setHeight(maxHeight);
        this.mTitleButton = (Button)view.findViewById(R.id.titleButton);
        this.mUnFoldButton = (ImageButton)view.findViewById(R.id.unFoldButton);
        this.mUnFoldButton.setOnClickListener((View.OnClickListener)this);
        this.mTitleButton.setOnClickListener((View.OnClickListener)this);
        this.mShareButton = (ImageButton)view.findViewById(R.id.shareButton);
        this.mShareButton.setOnClickListener((View.OnClickListener)this);
    }

    public void resetArrow() {
        ObjectAnimator.ofFloat((Object)this.mUnFoldButton, (String)"rotation", (float[])new float[]{0.0f, 0.0f}).start();
    }

    public void setListener(NRResultItemListener listener) {
        this.mListener = listener;
    }

    public void setResult(NRResult result) {
        this.mResult = result;
        if (result.getFetchedResult() != null) {
            this.mTitleButton.setText((CharSequence)result.getFetchedResult().getTitle());
        }
        this.setHeight(result.getHeight());
        this.mUnFoldButton.setVisibility(result.isSingle() ? 4 : 0);
        this.mShareButton.setVisibility(8);
    }

    public NRResult getResult() {
        return this.mResult;
    }

    public NRLikeView getLikeView() {
        return this.mLikeView;
    }

    public NRViewHolder.RowType getRowType() {
        return NRViewHolder.RowType.standard;
    }

    public void setBody(String htmlString) {
        if (this.mResult.getFetchedResult().getBody() == null) {
            this.mResult.getFetchedResult().setBody(htmlString);
        }
        this.mWebView.loadData(htmlString, "text/html", "UTF-8");
    }

    private void setHeight(int height) {
        ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{this.mItemView.getHeight(), height});
        animator.setDuration(400L);
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                ((NRResultItem)NRResultItem.this).mItemView.getLayoutParams().height = (Integer)animation.getAnimatedValue();
                NRResultItem.this.mItemView.requestLayout();
            }
        });
        animator.start();
    }

    public String getText() {
        return this.mTitleButton.getText().toString();
    }

    public void onClick(View v) {
        if (v.getId() == R.id.titleButton && this.mResult.isSingle()) {
            return;
        }
        if (v.getId() == R.id.titleButton || v.getId() == R.id.unFoldButton) {
            ObjectAnimator.ofFloat((Object)this.mUnFoldButton, (String)"rotation", (float[])new float[]{0.0f, this.mResult.isUnfolded() ? 0.0f : -180.0f}).start();
            this.mListener.unfoldItem(this.mResult, false);
        } else if (v.getId() == R.id.shareButton) {
            this.mListener.onShareClicked(this, this.mResult.getFetchedResult().getTitle());
        }
    }
}

