/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Components;

import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.RelativeLayout;
import com.nanorep.nanoclient.Channeling.NRChanneling;
import com.nanorep.nanoclient.Interfaces.NRQueryResult;
import java.util.ArrayList;
import nanorep.nanowidget.Components.ChannelPresenters.NRWebContentFragment;
import nanorep.nanowidget.Components.NRChannelItem;
import nanorep.nanowidget.Components.NRChannelingView;
import nanorep.nanowidget.Components.NRLikeView;
import nanorep.nanowidget.Components.NRLinkedArticleFragment;
import nanorep.nanowidget.Components.NRResultTitleView;
import nanorep.nanowidget.Components.NRWebView;
import nanorep.nanowidget.DataClasse.NRResult;
import nanorep.nanowidget.R;
import nanorep.nanowidget.Utilities.Calculate;
import nanorep.nanowidget.interfaces.NRResultView;
import nanorep.nanowidget.interfaces.OnFAQAnswerFetched;
import nanorep.nanowidget.interfaces.OnLikeListener;
import nanorep.nanowidget.interfaces.OnLinkedArticle;

public class NRResultFragment
extends Fragment
implements View.OnClickListener,
OnLikeListener,
NRChannelItem.OnChannelSelectedListener,
NRWebView.Listener,
OnFAQAnswerFetched,
NRResultView {
    private NRResult mResult;
    private NRWebView mWebView;
    private RelativeLayout mFeedbackView;
    private NRResultTitleView mTitle;
    private ImageButton mShareButton;
    private NRLikeView mLikeView;
    private NRChannelingView mChannelingView;
    private Listener mListener;

    public void onClick(View v) {
    }

    @Override
    public void onLinkedArticleClicked(String articleId) {
        this.mListener.onLinkedArticleClicked(this, articleId);
    }

    @Override
    public void onLinkClicked(String url) {
        NRWebContentFragment webContentFragment = NRWebContentFragment.newInstance(url, null);
        webContentFragment.setListener(new NRWebContentFragment.Listener(){

            @Override
            public void onDismiss() {
                NRResultFragment.this.getChildFragmentManager().popBackStack();
            }
        });
        this.getView().findViewById(R.id.linkedArtHolder).setVisibility(0);
        this.getChildFragmentManager().beginTransaction().setCustomAnimations(R.anim.fade_in, R.anim.fade_out, R.anim.fade_in, R.anim.fade_out).add(R.id.linkedArtHolder, (Fragment)webContentFragment).addToBackStack("linked").commit();
    }

    @Override
    public void onAnswerFetched(NRQueryResult result) {
        this.getView().findViewById(R.id.linkedArtHolder).setVisibility(0);
        NRLinkedArticleFragment linkedArticleFragment = new NRLinkedArticleFragment();
        linkedArticleFragment.setListener(this.mListener);
        linkedArticleFragment.setDismissListener(new NRLinkedArticleFragment.OnDismissListener(){

            @Override
            public void onBackClicked() {
                NRResultFragment.this.getChildFragmentManager().popBackStack();
            }
        });
        linkedArticleFragment.setQueryResult(result);
        this.getChildFragmentManager().beginTransaction().setCustomAnimations(R.anim.fade_in, R.anim.fade_out, R.anim.fade_in, R.anim.fade_out).add(R.id.linkedArtHolder, (Fragment)linkedArticleFragment).addToBackStack("linked").commit();
    }

    public void setResult(NRResult result) {
        this.mResult = result;
    }

    public void setListener(Listener listener) {
        this.mListener = listener;
    }

    @Override
    public void setLikeState(String resultId, boolean isPositive) {
        if (!isPositive) {
            if (this.mResult.getFetchedResult().getId().equals(resultId)) {
                this.mLikeView.resetLikeView();
                this.mResult.getFetchedResult().setLikeState(NRQueryResult.LikeState.notSelected);
            } else {
                this.mListener.onLikeFailed(resultId);
            }
        }
    }

    public void setBody(String htmlString) {
        this.mResult.getFetchedResult().setBody(htmlString);
        this.mWebView.loadData(htmlString, "text/html", "UTF-8");
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_nrresult, container, false);
    }

    public void onViewCreated(final View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        view.post(new Runnable(){

            @Override
            public void run() {
                NRResultFragment.this.mTitle = (NRResultTitleView)view.findViewById(R.id.titleView);
                if (NRResultFragment.this.mTitle != null) {
                    NRResultFragment.this.mTitle.setTitle(NRResultFragment.this.mResult.getFetchedResult().getTitle());
                    NRResultFragment.this.mTitle.setListener(new NRResultTitleView.Listener(){

                        @Override
                        public void onSharePressed() {
                        }
                    });
                }
                NRResultFragment.this.mShareButton = (ImageButton)view.findViewById(R.id.shareButton);
                if (NRResultFragment.this.mShareButton != null) {
                    NRResultFragment.this.mShareButton.setOnClickListener((View.OnClickListener)NRResultFragment.this);
                }
                NRResultFragment.this.mWebView = (NRWebView)view.findViewById(R.id.resultWebView);
                if (NRResultFragment.this.mWebView != null) {
                    NRResultFragment.this.mWebView.setListener(NRResultFragment.this);
                    if (NRResultFragment.this.mResult.getFetchedResult().getBody() != null) {
                        NRResultFragment.this.setBody(NRResultFragment.this.mResult.getFetchedResult().getBody());
                    } else {
                        NRResultFragment.this.mListener.fetchBodyForResult(NRResultFragment.this, NRResultFragment.this.mResult.getFetchedResult().getId());
                    }
                }
                NRResultFragment.this.mLikeView = (NRLikeView)view.findViewById(R.id.likeView);
                if (NRResultFragment.this.mLikeView != null) {
                    if (NRResultFragment.this.mResult.getFetchedResult().getLikeState() != NRQueryResult.LikeState.notSelected) {
                        NRResultFragment.this.mLikeView.updateLikeButton(NRResultFragment.this.mResult.getFetchedResult().getLikeState() == NRQueryResult.LikeState.positive);
                    }
                    NRResultFragment.this.mLikeView.setListener(NRResultFragment.this);
                }
                NRResultFragment.this.mFeedbackView = (RelativeLayout)view.findViewById(R.id.feedbackView);
                if (NRResultFragment.this.mFeedbackView != null) {
                    RelativeLayout.LayoutParams params = null;
                    if (NRResultFragment.this.mResult.getFetchedResult().getChanneling() == null) {
                        params = (RelativeLayout.LayoutParams)NRResultFragment.this.mFeedbackView.getLayoutParams();
                        params.height = (int)Calculate.pxFromDp(NRResultFragment.this.getContext(), 50.0f);
                    } else {
                        NRResultFragment.this.mChannelingView = (NRChannelingView)view.findViewById(R.id.channelingView);
                        if (NRResultFragment.this.mChannelingView != null) {
                            NRResultFragment.this.mChannelingView.setListener(NRResultFragment.this);
                            ArrayList channelings = NRResultFragment.this.mResult.getFetchedResult().getChanneling();
                            for (NRChanneling channeling : channelings) {
                                channeling.setQueryResult(NRResultFragment.this.mResult.getFetchedResult());
                            }
                            NRResultFragment.this.mChannelingView.setChannelings(channelings);
                            params = (RelativeLayout.LayoutParams)NRResultFragment.this.mFeedbackView.getLayoutParams();
                            params.height = (int)Calculate.pxFromDp(NRResultFragment.this.getContext(), 100.0f);
                        }
                    }
                    NRResultFragment.this.mFeedbackView.setLayoutParams((ViewGroup.LayoutParams)params);
                }
            }
        });
    }

    @Override
    public void onLikeClicked(NRLikeView likeView, String resultId, boolean isLike) {
    }

    @Override
    public void onChannelSelected(NRChannelItem channelItem) {
        this.mListener.onChannelSelected(this, channelItem);
    }

    public static interface Listener
    extends OnLinkedArticle {
        public void onResultFragmentDismissed(NRResultFragment var1);

        public void resultFragmentWillDismiss(NRResultFragment var1);

        public void fetchBodyForResult(NRResultFragment var1, String var2);

        public void onChannelSelected(NRResultFragment var1, NRChannelItem var2);

        public void onLikeFailed(String var1);
    }
}

