/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Components;

import android.content.Context;
import android.graphics.PorterDuff;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import nanorep.nanowidget.R;
import nanorep.nanowidget.interfaces.OnLikeListener;

public class NRLikeView
extends LinearLayout
implements View.OnClickListener {
    private OnLikeListener mListener;
    private ImageButton mLikeButton;
    private ImageButton mDislikeButton;
    private boolean mLikeSelection;
    private String mResultId;

    public NRLikeView(Context context, AttributeSet attrs) {
        super(context, attrs);
        LayoutInflater.from((Context)context).inflate(R.layout.like_view, (ViewGroup)this);
    }

    public void setListener(OnLikeListener listener) {
        this.mListener = listener;
    }

    public void setResultId(String resultId) {
        this.mResultId = resultId;
    }

    public void updateLikeButton(boolean isLike) {
        this.resetLikeView();
        if (isLike) {
            this.mLikeButton.getBackground().setColorFilter(-13248879, PorterDuff.Mode.MULTIPLY);
            this.mLikeButton.setImageResource(this.resId("white_like_icon"));
        } else {
            this.mDislikeButton.getBackground().setColorFilter(-757916, PorterDuff.Mode.MULTIPLY);
            this.mDislikeButton.setImageResource(this.resId("white_dislike_icon"));
        }
        this.mLikeButton.setEnabled(false);
        this.mDislikeButton.setEnabled(false);
        this.mLikeSelection = isLike;
    }

    public void resetLikeView() {
        this.mLikeButton.setEnabled(true);
        this.mDislikeButton.setEnabled(true);
        this.mLikeButton.setImageResource(this.resId("grey_like_icon"));
        this.mDislikeButton.setImageResource(this.resId("grey_dislike_icon"));
        this.mLikeButton.getBackground().setColorFilter(-3355444, PorterDuff.Mode.MULTIPLY);
        this.mDislikeButton.getBackground().setColorFilter(-3355444, PorterDuff.Mode.MULTIPLY);
    }

    private int resId(String resName) {
        return this.getResources().getIdentifier(resName, "drawable", this.getContext().getPackageName());
    }

    public void onViewAdded(View child) {
        super.onViewAdded(child);
        this.mLikeButton = (ImageButton)child.findViewById(R.id.likeButton);
        this.mDislikeButton = (ImageButton)child.findViewById(R.id.dislikeButton);
        this.mLikeButton.setOnClickListener((View.OnClickListener)this);
        this.mDislikeButton.setOnClickListener((View.OnClickListener)this);
    }

    public boolean getLikeSelection() {
        return this.mLikeSelection;
    }

    public void cancelLike() {
        this.mLikeButton.setEnabled(true);
        this.mDislikeButton.setEnabled(true);
    }

    public void onClick(View v) {
        this.mLikeSelection = v.getId() == R.id.likeButton;
        this.updateLikeButton(this.mLikeSelection);
        this.mListener.onLikeClicked(this, this.mResultId, this.mLikeSelection);
    }
}

