/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Components;

import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.nanorep.nanoclient.Channeling.NRChanneling;
import com.nanorep.nanoclient.Interfaces.NRQueryResult;
import java.util.ArrayList;
import nanorep.nanowidget.Components.NRChannelingView;
import nanorep.nanowidget.Components.NRLikeView;
import nanorep.nanowidget.Components.NRResultItem;
import nanorep.nanowidget.Components.NRWebView;
import nanorep.nanowidget.DataClasse.NRResult;
import nanorep.nanowidget.R;
import nanorep.nanowidget.Utilities.Calculate;
import nanorep.nanowidget.interfaces.NRResultItemListener;
import nanorep.nanowidget.interfaces.NRViewHolder;

public class NRContentItem
extends NRResultItem {
    private NRWebView mWebView;
    private RelativeLayout mFeedbackView;
    private NRLikeView mLikeView;
    private NRChannelingView mChannelingView;
    private NRResultItemListener mListener;
    private NRResult mResult;

    public NRContentItem(View itemView, int height) {
        super(itemView);
        itemView.getLayoutParams().height = height - (int)Calculate.pxFromDp(itemView.getContext(), 80.0f);
        this.mWebView = (NRWebView)itemView.findViewById(R.id.cv_webview);
        this.mFeedbackView = (RelativeLayout)itemView.findViewById(R.id.cv_feedbackView);
        this.mLikeView = (NRLikeView)itemView.findViewById(R.id.cv_likeView);
        this.mChannelingView = (NRChannelingView)itemView.findViewById(R.id.cv_channelingView);
    }

    @Override
    public void setListener(NRResultItemListener listener) {
        this.mListener = listener;
        this.mWebView.setListener(listener);
        this.mLikeView.setListener(listener);
        this.mChannelingView.setListener(listener);
    }

    @Override
    public void setBody(String body) {
        this.mResult.getFetchedResult().setBody(body);
        this.mWebView.loadData(body, "text/html", "UTF-8");
    }

    public void resetBody() {
        this.mWebView.loadUrl("about:blank");
    }

    @Override
    public void setResult(NRResult result) {
        this.mResult = result;
        if (this.mResult.getFetchedResult().getBody() != null) {
            this.setBody(this.mResult.getFetchedResult().getBody());
        } else {
            this.mListener.fetchBodyForResult(this, this.mResult.getFetchedResult().getId(), this.mResult.getFetchedResult().getHash());
        }
        this.mLikeView.setResultId(result.getFetchedResult().getId());
        if (result.getFetchedResult().getLikeState() == NRQueryResult.LikeState.notSelected) {
            this.mLikeView.resetLikeView();
        } else {
            this.mLikeView.updateLikeButton(result.getFetchedResult().getLikeState() == NRQueryResult.LikeState.positive);
        }
        if (this.mFeedbackView != null) {
            RelativeLayout.LayoutParams params = null;
            if (this.mResult.getFetchedResult().getChanneling() == null) {
                params = (RelativeLayout.LayoutParams)this.mFeedbackView.getLayoutParams();
                params.height = (int)Calculate.pxFromDp(this.itemView.getContext(), 50.0f);
            } else if (this.mChannelingView != null) {
                ArrayList channelings = this.mResult.getFetchedResult().getChanneling();
                for (NRChanneling channeling : channelings) {
                    channeling.setQueryResult(this.mResult.getFetchedResult());
                }
                this.mChannelingView.setChannelings(channelings);
                params = (RelativeLayout.LayoutParams)this.mFeedbackView.getLayoutParams();
                params.height = (int)Calculate.pxFromDp(this.itemView.getContext(), 100.0f);
            }
            this.mFeedbackView.setLayoutParams((ViewGroup.LayoutParams)params);
        }
    }

    @Override
    public NRViewHolder.RowType getRowType() {
        return NRViewHolder.RowType.unfolded;
    }
}

