/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Components;

import android.content.Context;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import java.util.ArrayList;
import nanorep.nanowidget.Components.NRSuggestionItem;
import nanorep.nanowidget.R;
import nanorep.nanowidget.interfaces.NRSuggestionsListener;

public class NRSuggestionsView
extends LinearLayout {
    private NRSuggestionsListener mListener;
    private ArrayList<String> mSuggestions;
    private RecyclerView.Adapter mAdapter = new SuggestionsAdapter();
    private RecyclerView mRecyclerView;

    public NRSuggestionsView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setListener(NRSuggestionsListener listener) {
        this.mListener = listener;
    }

    public void setSuggestions(ArrayList<String> suggestions) {
        if (suggestions == null) {
            this.setHeight(0);
        } else {
            this.setHeight(suggestions.size() * 40);
        }
        this.mSuggestions = suggestions;
        this.mAdapter.notifyDataSetChanged();
    }

    public void onViewAdded(View child) {
        super.onViewAdded(child);
        if (child.getId() == R.id.recyclerSuggestions) {
            this.mRecyclerView = (RecyclerView)child;
            this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(this.getContext(), 1));
            this.mRecyclerView.setAdapter(this.mAdapter);
        }
    }

    public void setHeight(int height) {
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.getLayoutParams();
        params.height = (int)TypedValue.applyDimension((int)1, (float)height, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    public class SuggestionsAdapter
    extends RecyclerView.Adapter<NRSuggestionItem>
    implements NRSuggestionItem.OnSuggestionSelectedListener {
        public NRSuggestionItem onCreateViewHolder(ViewGroup parent, int viewType) {
            View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.suggestion_item, null);
            NRSuggestionItem item = new NRSuggestionItem(view);
            item.setListener(this);
            return item;
        }

        public void onBindViewHolder(NRSuggestionItem holder, int position) {
            holder.setText((String)NRSuggestionsView.this.mSuggestions.get(position));
        }

        public int getItemCount() {
            if (NRSuggestionsView.this.mSuggestions != null) {
                return NRSuggestionsView.this.mSuggestions.size();
            }
            return 0;
        }

        @Override
        public void onSuggestionSelected(String text) {
            NRSuggestionsView.this.mListener.onSelectSuggestion(text);
        }
    }
}

