/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Components;

import android.content.Context;
import android.graphics.PorterDuff;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.ImageButton;
import android.widget.RelativeLayout;
import android.widget.TextView;
import nanorep.nanowidget.Components.NREditText;
import nanorep.nanowidget.R;
import nanorep.nanowidget.interfaces.NRSearchBarListener;

public class NRSearchBar
extends RelativeLayout
implements View.OnClickListener,
TextWatcher,
TextView.OnEditorActionListener {
    private NRSearchBarListener mListener;
    private ImageButton mSpeechButton;
    private NREditText mSearchEditText;

    public NRSearchBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        LayoutInflater.from((Context)context).inflate(R.layout.search_bar, (ViewGroup)this);
    }

    public void onViewAdded(View child) {
        super.onViewAdded(child);
        this.mSearchEditText = (NREditText)child.findViewById(R.id.searchText);
        this.mSearchEditText.addTextChangedListener(this);
        this.mSearchEditText.setHint("Type Your Question Here");
        this.mSearchEditText.setTextColor(-1);
        this.mSearchEditText.setHintTextColor(-3355444);
        this.mSearchEditText.getBackground().setColorFilter(0, PorterDuff.Mode.SRC_IN);
        this.mSearchEditText.setOnEditorActionListener(this);
        this.mSpeechButton = (ImageButton)child.findViewById(R.id.speechButton);
        this.mSpeechButton.setOnClickListener((View.OnClickListener)this);
    }

    public void setListener(NRSearchBarListener listener) {
        this.mListener = listener;
    }

    private int resId(String resName) {
        return this.getResources().getIdentifier(resName, "drawable", this.getContext().getPackageName());
    }

    public void dismissKeyboard() {
        InputMethodManager imm = (InputMethodManager)this.getContext().getSystemService("input_method");
        imm.hideSoftInputFromWindow(this.mSearchEditText.getWindowToken(), 0);
    }

    public void updateText(String text) {
        this.mSearchEditText.setText(text);
        this.mSearchEditText.clearFocus();
    }

    public void updateText(String text, boolean withListener) {
        this.mSearchEditText.removeTextChangedListener(this);
        this.mSpeechButton.setVisibility(text.length() > 0 ? 0 : 4);
        this.updateText(text);
        this.mSearchEditText.addTextChangedListener(this);
    }

    public String getText() {
        return this.mSearchEditText.getText().toString();
    }

    public void onClick(View v) {
        if (((Boolean)v.getTag()).booleanValue()) {
            this.mSearchEditText.clearFocus();
            this.dismissKeyboard();
            this.mListener.onClearClicked(true);
            this.mSearchEditText.setText("");
        }
    }

    public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
    }

    public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
        this.mSpeechButton.setVisibility(charSequence.length() > 0 ? 0 : 4);
        this.mSpeechButton.setImageResource(this.resId(charSequence.length() > 0 ? "searchbar_x_icon" : "searchbar_mic_icon"));
        Boolean state = charSequence.length() > 0;
        this.mSpeechButton.setTag((Object)state);
        if (charSequence.length() == 0) {
            // empty if block
        }
    }

    public void afterTextChanged(Editable editable) {
        if (editable != null && editable.length() > 0) {
            this.mListener.fetchSuggestionsForText(this.mSearchEditText.getText().toString());
        }
    }

    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
        if (actionId == 3) {
            this.mListener.searchForText(this.mSearchEditText.getText().toString());
            this.dismissKeyboard();
            return true;
        }
        return false;
    }
}

