@file:JvmName("VoiceRecognizerSpace")

package com.nanorep.accessibility.voice

import android.content.Context
import android.view.View
import android.widget.TextView
import com.nanorep.sdkcore.utils.NRError
import java.util.*


/**
 * Created by tehila on 27/11/2017.
 */

const val AUDIO_RECORD_PERMISSION_CODE:Int = 309
const val VOICE_RECOGNITION_NOT_AVAILABLE = "VOICE_RECOGNITION_NOT_AVAILABLE"
const val TEXT_TO_VOICE_NOT_AVAILABLE = "TEXT_TO_VOICE_NOT_AVAILABLE"
const val VoiceRecognizerTag = "VoiceRecognition"

object RecognitionErrorCodes {
    const val ERROR_RECORDING = "VOICE_ERROR_RECORDING"
    const val ERROR_PERMISSIONS = "VOICE_ERROR_PERMISSIONS"
    const val ERROR_NETWORK = "VOICE_ERROR_NETWORK"
    const val ERROR_NO_RESULTS = "VOICE_ERROR_NO_RESULTS"
    const val ERROR_RECOGNIZER_BUSY = "VOICE_ERROR_RECOGNIZER_BUSY"
    const val ERROR_GENERAL = "VOICE_ERROR_GENERAL"
    const val ERROR_TIMEOUT = "VOICE_ERROR_TIMEOUT"

    const val ERROR_READING = "VOICE_ERROR_READING"
}


abstract class VoiceRecognizer protected constructor(protected var context: Context) {

    protected var textView: TextView? = null
    protected var actionView: View? = null

    fun bindOutputView(textView: TextView) = apply { this.textView = textView }
}

interface SpeechRecognitionProvider {
    fun registerListener(speechedTextListener: SpeechedTextListener = object: SpeechedTextListener {}){}
    fun enable(enable:Boolean){}
    fun start(language: Locale = Locale.getDefault()){}
    fun stop(){}
    fun cancel(){}
    fun release(){}
    var speechCompleteSilenceTimeout: Int?
    var partialResultsEnabled: Boolean
}

interface SpeechedTextListener {
    fun onReady(){} // called once when speech engine was set
    fun onStart(){} // when voice listening requested
    fun onPrepared(){} // engine started listening
    fun onActive(){} // recorder recognized voice
    fun onIdle(){} // recorder recognized voice end
    fun onResults(text:String){} // voice recognized results
    fun onPartialResults(text:String){} // voice recognized results
    fun onError(error: NRError) {}
    fun onStop() {}
    fun onCancel() {}
}

