/*
 * Decompiled with CFR 0.152.
 */
package com.nanorep.accessibility.voice.engines;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.speech.RecognitionListener;
import android.speech.SpeechRecognizer;
import android.util.Log;
import android.view.View;
import com.nanorep.accessibility.voice.SpeechRecognitionProvider;
import com.nanorep.accessibility.voice.SpeechedTextListener;
import com.nanorep.accessibility.voice.VoiceRecognizer;
import com.nanorep.accessibility.voice.engines.SpeechToText;
import com.nanorep.sdkcore.types.NRError;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0002J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0007H\u0016J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\b\u0010\u0019\u001a\u00020\u0015H\u0002J\b\u0010\u001a\u001a\u00020\u0015H\u0002J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\fH\u0016J\b\u0010\u001d\u001a\u00020\u0015H\u0016J\b\u0010\u001e\u001a\u00020\u0015H\u0002J\u0010\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u0015H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/nanorep/accessibility/voice/engines/SpeechToText;", "Lcom/nanorep/accessibility/voice/VoiceRecognizer;", "Lcom/nanorep/accessibility/voice/SpeechRecognitionProvider;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "isSupported", "", "listeningStarted", "recognitionListener", "Landroid/speech/RecognitionListener;", "speechListener", "Lcom/nanorep/accessibility/voice/SpeechedTextListener;", "speechRecognizer", "Landroid/speech/SpeechRecognizer;", "timeoutJob", "Lkotlinx/coroutines/Job;", "bindActionView", "view", "Landroid/view/View;", "cancel", "", "cancelTimeout", "enable", "isSpeechToTextAvailable", "onListeningEnd", "onListeningStart", "registerListener", "speechedTextListener", "release", "setSpeechSilenceTimeout", "start", "languge", "Ljava/util/Locale;", "stop", "accessibility_release"})
public final class SpeechToText
extends VoiceRecognizer
implements SpeechRecognitionProvider {
    private final boolean isSupported;
    private SpeechRecognizer speechRecognizer;
    private SpeechedTextListener speechListener;
    private final RecognitionListener recognitionListener;
    private Job timeoutJob;
    private boolean listeningStarted;

    private final boolean isSpeechToTextAvailable(Context context) {
        return SpeechRecognizer.isRecognitionAvailable((Context)context) && context.getPackageManager().hasSystemFeature("android.hardware.microphone");
    }

    @NotNull
    public final SpeechToText bindActionView(@NotNull View view) {
        SpeechToText speechToText;
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
            speechToText = this;
            boolean bl = false;
            boolean bl2 = false;
            SpeechToText $receiver = speechToText;
            boolean bl3 = false;
            $receiver.setActionView(view);
            View view2 = $receiver.getActionView();
            if (view2 == null) break block0;
            view2.setOnClickListener(new View.OnClickListener($receiver){
                final /* synthetic */ SpeechToText $this_apply;

                public final void onClick(View it) {
                    SpeechRecognitionProvider.DefaultImpls.start$default(this.$this_apply, null, 1, null);
                }
                {
                    this.$this_apply = speechToText;
                }
            });
        }
        return speechToText;
    }

    @Override
    public void registerListener(@NotNull SpeechedTextListener speechedTextListener) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)speechedTextListener, (String)"speechedTextListener");
            SpeechToText speechToText = this;
            boolean bl = false;
            boolean bl2 = false;
            SpeechToText $receiver = speechToText;
            boolean bl3 = false;
            $receiver.speechListener = speechedTextListener;
            if ($receiver.isSupported) break block1;
            SpeechedTextListener speechedTextListener2 = $receiver.speechListener;
            if (speechedTextListener2 != null) {
                speechedTextListener2.onError(new NRError("VOICE_RECOGNITION_NOT_AVAILABLE", "Speech to text is not available on your device", null, 4, null));
            }
        }
    }

    @Override
    public void start(@NotNull Locale languge) {
        Intrinsics.checkParameterIsNotNull((Object)languge, (String)"languge");
        Intent recognizeIntent = new Intent("android.speech.action.RECOGNIZE_SPEECH");
        recognizeIntent.putExtra("android.speech.extra.LANGUAGE_MODEL", "free_form");
        recognizeIntent.putExtra("android.speech.extra.MAX_RESULTS", 3);
        recognizeIntent.putExtra("android.speech.extra.LANGUAGE", (Serializable)languge);
        SpeechedTextListener speechedTextListener = this.speechListener;
        if (speechedTextListener != null) {
            speechedTextListener.onStart();
        }
        SpeechRecognizer speechRecognizer = this.speechRecognizer;
        if (speechRecognizer != null) {
            speechRecognizer.cancel();
        }
        SpeechRecognizer speechRecognizer2 = this.speechRecognizer;
        if (speechRecognizer2 != null) {
            speechRecognizer2.startListening(recognizeIntent);
        }
        this.onListeningStart();
    }

    private final void onListeningStart() {
        this.listeningStarted = true;
        this.setSpeechSilenceTimeout();
    }

    private final void onListeningEnd() {
        block0: {
            this.listeningStarted = false;
            SpeechedTextListener speechedTextListener = this.speechListener;
            if (speechedTextListener == null) break block0;
            speechedTextListener.onStop();
        }
    }

    private final void setSpeechSilenceTimeout() {
        this.cancelTimeout();
        this.timeoutJob = BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            private CoroutineScope p$;
            int label;
            final /* synthetic */ SpeechToText this$0;

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object result) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        v0 = result;
                        if (v0 instanceof Result.Failure) {
                            throw ((Result.Failure)v0).exception;
                        }
                        var2_3 = this.p$;
                        this.label = 1;
                        v1 = DelayKt.delay((long)6000L, (Continuation)this);
                        if (v1 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl18
                    }
                    case 1: {
                        v2 = result;
                        if (v2 instanceof Result.Failure) {
                            throw ((Result.Failure)v2).exception;
                        }
                        v1 = result;
lbl18:
                        // 2 sources

                        this.label = 2;
                        v3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                            private CoroutineScope p$;
                            int label;
                            final /* synthetic */ setSpeechSilenceTimeout.1 this$0;

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        Object object2 = result;
                                        if (object2 instanceof Result.Failure) {
                                            throw ((Result.Failure)object2).exception;
                                        }
                                        CoroutineScope coroutineScope = this.p$;
                                        SpeechedTextListener speechedTextListener = SpeechToText.access$getSpeechListener$p(this.this$0.this$0);
                                        if (speechedTextListener != null) {
                                            speechedTextListener.onError(new NRError("VOICE_ERROR_TIMEOUT", "recognizer failed to get voice input", null, 4, null));
                                        }
                                        SpeechRecognizer speechRecognizer = SpeechToText.access$getSpeechRecognizer$p(this.this$0.this$0);
                                        if (speechRecognizer != null) {
                                            speechRecognizer.cancel();
                                        }
                                        SpeechToText.access$onListeningEnd(this.this$0.this$0);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }
                            {
                                this.this$0 = var1_1;
                                super(2, continuation);
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                                return function2;
                            }

                            public final Object invoke(Object object, Object object2) {
                                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)this);
                        if (v3 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl28
                    }
                    case 2: {
                        v4 = result;
                        if (v4 instanceof Result.Failure) {
                            throw ((Result.Failure)v4).exception;
                        }
                        v3 = result;
lbl28:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = speechToText;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @Override
    public void stop() {
        Log.i((String)"VoiceRecognition", (String)("stop: " + this.speechRecognizer));
        this.cancelTimeout();
        if (this.listeningStarted) {
            SpeechRecognizer speechRecognizer = this.speechRecognizer;
            if (speechRecognizer != null) {
                speechRecognizer.stopListening();
            }
            this.onListeningEnd();
        }
    }

    @Override
    public void cancel() {
        Log.i((String)"VoiceRecognition", (String)("cancel: " + this.speechRecognizer));
        this.cancelTimeout();
        SpeechRecognizer speechRecognizer = this.speechRecognizer;
        if (speechRecognizer != null) {
            speechRecognizer.cancel();
        }
        this.onListeningEnd();
    }

    @Override
    public void release() {
        Log.i((String)"VoiceRecognition", (String)("release: " + this.speechRecognizer + ", isSupported = " + this.isSupported));
        this.cancelTimeout();
        SpeechRecognizer speechRecognizer = this.speechRecognizer;
        if (speechRecognizer != null) {
            speechRecognizer.setRecognitionListener(null);
        }
        try {
            SpeechRecognizer speechRecognizer2 = this.speechRecognizer;
            if (speechRecognizer2 != null) {
                speechRecognizer2.destroy();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e((String)"srDestroyException", (String)"speechRecognizer destroy failed");
        }
        this.onListeningEnd();
    }

    private final void cancelTimeout() {
        block3: {
            if (this.timeoutJob == null) break block3;
            Job job = this.timeoutJob;
            if (job == null) {
                Intrinsics.throwNpe();
            }
            if (job.isActive()) {
                Job job2 = this.timeoutJob;
                if (job2 != null) {
                    Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
                }
            }
        }
    }

    @Override
    public void enable(boolean enable) {
        block1: {
            if (enable) break block1;
            SpeechRecognizer speechRecognizer = this.speechRecognizer;
            if (speechRecognizer != null) {
                speechRecognizer.cancel();
            }
        }
    }

    public SpeechToText(@NotNull Context context) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            super(context);
            this.speechListener = new SpeechedTextListener(){

                public void onReady() {
                    SpeechedTextListener.DefaultImpls.onReady(this);
                }

                public void onStart() {
                    SpeechedTextListener.DefaultImpls.onStart(this);
                }

                public void onPrepared() {
                    SpeechedTextListener.DefaultImpls.onPrepared(this);
                }

                public void onActive() {
                    SpeechedTextListener.DefaultImpls.onActive(this);
                }

                public void onIdle() {
                    SpeechedTextListener.DefaultImpls.onIdle(this);
                }

                public void onResults(@NotNull String text) {
                    Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                    SpeechedTextListener.DefaultImpls.onResults(this, text);
                }

                public void onError(@NotNull NRError error) {
                    Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                    SpeechedTextListener.DefaultImpls.onError(this, error);
                }

                public void onStop() {
                    SpeechedTextListener.DefaultImpls.onStop(this);
                }
            };
            this.recognitionListener = new RecognitionListener(this){
                final /* synthetic */ SpeechToText this$0;

                public void onRmsChanged(float rmsdB) {
                }

                public void onBufferReceived(@Nullable byte[] buffer) {
                }

                public void onPartialResults(@Nullable Bundle partialResults) {
                    Log.d((String)"ContentValues", (String)"onPartialResults");
                }

                public void onEvent(int eventType, @Nullable Bundle params) {
                    Log.d((String)"ContentValues", (String)"onEvent");
                }

                public void onBeginningOfSpeech() {
                    block0: {
                        SpeechedTextListener speechedTextListener = SpeechToText.access$getSpeechListener$p(this.this$0);
                        if (speechedTextListener == null) break block0;
                        speechedTextListener.onActive();
                    }
                }

                public void onEndOfSpeech() {
                    block0: {
                        SpeechedTextListener speechedTextListener = SpeechToText.access$getSpeechListener$p(this.this$0);
                        if (speechedTextListener == null) break block0;
                        speechedTextListener.onIdle();
                    }
                }

                public void onError(int error) {
                    block12: {
                        String string;
                        SpeechToText.access$cancelTimeout(this.this$0);
                        switch (error) {
                            case 3: {
                                string = "VOICE_ERROR_RECORDING";
                                break;
                            }
                            case 5: {
                                string = "VOICE_ERROR_RECORDING";
                                break;
                            }
                            case 9: {
                                string = "VOICE_ERROR_PERMISSIONS";
                                break;
                            }
                            case 2: {
                                string = "VOICE_ERROR_NETWORK";
                                break;
                            }
                            case 1: {
                                string = "VOICE_ERROR_NETWORK";
                                break;
                            }
                            case 4: {
                                string = "VOICE_ERROR_NETWORK";
                                break;
                            }
                            case 7: {
                                string = "VOICE_ERROR_NO_RESULTS";
                                break;
                            }
                            case 6: {
                                string = "VOICE_ERROR_NO_RESULTS";
                                break;
                            }
                            case 8: {
                                recognitionListener.1 var3_2 = this;
                                boolean bl = false;
                                boolean bl2 = false;
                                recognitionListener.1 it = var3_2;
                                boolean bl3 = false;
                                SpeechRecognizer speechRecognizer = SpeechToText.access$getSpeechRecognizer$p(this.this$0);
                                if (speechRecognizer != null) {
                                    speechRecognizer.cancel();
                                }
                                string = "VOICE_ERROR_RECOGNIZER_BUSY";
                                break;
                            }
                            default: {
                                recognitionListener.1 var3_2 = this;
                                boolean bl = false;
                                boolean bl2 = false;
                                recognitionListener.1 it = var3_2;
                                boolean bl4 = false;
                                string = "VOICE_ERROR_GENERAL";
                            }
                        }
                        String code = string;
                        SpeechedTextListener speechedTextListener = SpeechToText.access$getSpeechListener$p(this.this$0);
                        if (speechedTextListener == null) break block12;
                        speechedTextListener.onError(new NRError(code, null, code, null));
                    }
                }

                public void onResults(@Nullable Bundle results) {
                    block1: {
                        ArrayList<E> data;
                        SpeechToText.access$cancelTimeout(this.this$0);
                        Log.d((String)"ContentValues", (String)("onResults " + results));
                        Bundle bundle = results;
                        ArrayList<E> arrayList = data = bundle != null ? bundle.getStringArrayList("results_recognition") : null;
                        if (data == null || data.size() == 0) {
                            this.onError(7);
                            return;
                        }
                        E e = data.get(0);
                        Intrinsics.checkExpressionValueIsNotNull(e, (String)"data.get(0)");
                        String fullText = (String)e;
                        Log.i((String)"VoiceRecognition", (String)"onReadyForSpeech: ready for recoding, user can start talking");
                        SpeechedTextListener speechedTextListener = SpeechToText.access$getSpeechListener$p(this.this$0);
                        if (speechedTextListener == null) break block1;
                        speechedTextListener.onResults(fullText);
                    }
                }

                public void onReadyForSpeech(@Nullable Bundle params) {
                    block0: {
                        SpeechToText.access$cancelTimeout(this.this$0);
                        Log.i((String)"VoiceRecognition", (String)"onReadyForSpeech: ready for recoding, user can start talking");
                        SpeechedTextListener speechedTextListener = SpeechToText.access$getSpeechListener$p(this.this$0);
                        if (speechedTextListener == null) break block0;
                        speechedTextListener.onPrepared();
                    }
                }
                {
                    this.this$0 = $outer;
                }
            };
            this.isSupported = this.isSpeechToTextAvailable(context);
            if (!this.isSupported) break block1;
            SpeechRecognizer speechRecognizer = this.speechRecognizer = SpeechRecognizer.createSpeechRecognizer((Context)context);
            if (speechRecognizer != null) {
                speechRecognizer.setRecognitionListener(this.recognitionListener);
            }
        }
    }

    public static final /* synthetic */ SpeechedTextListener access$getSpeechListener$p(SpeechToText $this) {
        return $this.speechListener;
    }

    public static final /* synthetic */ void access$setSpeechListener$p(SpeechToText $this, SpeechedTextListener speechedTextListener) {
        $this.speechListener = speechedTextListener;
    }

    public static final /* synthetic */ SpeechRecognizer access$getSpeechRecognizer$p(SpeechToText $this) {
        return $this.speechRecognizer;
    }

    public static final /* synthetic */ void access$setSpeechRecognizer$p(SpeechToText $this, SpeechRecognizer speechRecognizer) {
        $this.speechRecognizer = speechRecognizer;
    }

    public static final /* synthetic */ void access$onListeningEnd(SpeechToText $this) {
        $this.onListeningEnd();
    }

    public static final /* synthetic */ void access$cancelTimeout(SpeechToText $this) {
        $this.cancelTimeout();
    }
}

