/*
 * Decompiled with CFR 0.152.
 */
package fi.iki.elonen;

import fi.iki.elonen.NanoHTTPD;
import fi.iki.elonen.WebServerPlugin;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import org.pegdown.PegDownProcessor;

public class MarkdownWebServerPlugin
implements WebServerPlugin {
    private final PegDownProcessor processor = new PegDownProcessor();

    public void initialize(Map<String, String> commandLineOptions) {
    }

    public boolean canServeUri(String uri, File rootDir) {
        File f = new File(rootDir, uri);
        return f.exists();
    }

    public NanoHTTPD.Response serveFile(String uri, Map<String, String> headers, File file, String mimeType) {
        String markdownSource = this.readSource(file);
        return markdownSource == null ? null : new NanoHTTPD.Response(NanoHTTPD.Response.Status.OK, "text/html", this.processor.markdownToHtml(markdownSource));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readSource(File file) {
        FileReader fileReader = null;
        BufferedReader reader = null;
        try {
            fileReader = new FileReader(file);
            reader = new BufferedReader(fileReader);
            String line = null;
            StringBuilder sb = new StringBuilder();
            do {
                if ((line = reader.readLine()) == null) continue;
                sb.append(line).append("\n");
            } while (line != null);
            reader.close();
            String string = sb.toString();
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ignored) {}
        }
    }
}

