/*
 * Decompiled with CFR 0.152.
 */
package com.gcm.client;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import android.util.Log;
import com.gcm.client.GcmHelper;
import com.google.android.gms.gcm.GcmPubSub;
import com.google.android.gms.iid.InstanceID;
import java.io.IOException;
import java.util.ArrayList;

public class RegistrationIntentService
extends IntentService {
    public static final String REGISTRATION_COMPLETE = "com.gcm.client.REGISTRATION.COMPLETE";
    public static final String ACTION_UNSUBSCRIBE = "com.gcm.client.UNSUBSCRIBE";
    public static final String ACTION_SUBSCRIBE = "com.gcm.client.SUBSCRIBE";
    public static final String ACTION_REGISTER = "com.gcm.client.REGISTER";
    public static final String ACTION_UNREGISTER = "com.gcm.client.UNREGISTER";
    static final String EXTRA_TOPIC_LIST = "topiclist";

    public RegistrationIntentService() {
        super("RegistrationIntentService");
    }

    protected void onHandleIntent(Intent intent) {
        block15: {
            try {
                if (null != intent) {
                    String action = intent.getAction();
                    String senderId = GcmHelper.getInstance().getAuthorizedEntity();
                    InstanceID instanceID = InstanceID.getInstance((Context)this);
                    if (ACTION_REGISTER.equals(action)) {
                        String token = this.registerForToken(instanceID, senderId);
                        ArrayList<String> topics = GcmHelper.getInstance().getSubscribedTopics();
                        if (null != topics && topics.isEmpty()) {
                            String[] stringArray = new String[topics.size()];
                            this.subscribeTopics(token, topics.toArray(stringArray));
                        }
                        Intent registrationComplete = new Intent(REGISTRATION_COMPLETE);
                        LocalBroadcastManager.getInstance((Context)this).sendBroadcast(registrationComplete);
                        if (GcmHelper.DEBUG_ENABLED) {
                            Log.d((String)"GcmLibrary", (String)"RegistrationIntentService: registration completed");
                        }
                        return;
                    }
                    if (ACTION_UNREGISTER.equals(action)) {
                        this.unRegisterToken(instanceID, senderId);
                        if (GcmHelper.DEBUG_ENABLED) {
                            Log.d((String)"GcmLibrary", (String)"RegistrationIntentService: successfully unregistered");
                        }
                        return;
                    }
                    if (intent.hasExtra(EXTRA_TOPIC_LIST)) {
                        String[] topics = intent.getStringArrayExtra(EXTRA_TOPIC_LIST);
                        String pushToken = GcmHelper.getInstance().getPushToken(this.getApplicationContext());
                        if (TextUtils.isEmpty((CharSequence)pushToken)) {
                            return;
                        }
                        if (ACTION_UNSUBSCRIBE.equals(action)) {
                            this.unsubscribeTopics(pushToken, topics);
                            if (GcmHelper.DEBUG_ENABLED) {
                                Log.d((String)"GcmLibrary", (String)"RegistrationIntentService: unsubscribe completed");
                            }
                        } else if (ACTION_SUBSCRIBE.equals(action)) {
                            this.subscribeTopics(pushToken, topics);
                            if (GcmHelper.DEBUG_ENABLED) {
                                Log.d((String)"GcmLibrary", (String)"RegistrationIntentService: subscription completed");
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                if (!GcmHelper.DEBUG_ENABLED) break block15;
                Log.e((String)"GcmLibrary", (String)"PushRegistrationService: Failed to complete token refresh", (Throwable)e);
            }
        }
    }

    private void subscribeTopics(String token, String[] topics) throws IOException {
        GcmPubSub pubSub = GcmPubSub.getInstance((Context)this);
        for (String topic : topics) {
            pubSub.subscribe(token, topic, null);
        }
    }

    private void unsubscribeTopics(String token, String[] topics) throws IOException {
        GcmPubSub pubSub = GcmPubSub.getInstance((Context)this);
        for (String topic : topics) {
            pubSub.unsubscribe(token, topic);
        }
    }

    private void unRegisterToken(InstanceID instanceID, String senderId) throws IOException {
        instanceID.deleteToken(senderId, "GCM");
        GcmHelper.getInstance().onTokenDeleted(this.getApplicationContext());
    }

    private String registerForToken(InstanceID instanceID, String senderId) throws IOException {
        String token = instanceID.getToken(senderId, "GCM", null);
        if (GcmHelper.DEBUG_ENABLED) {
            Log.i((String)"GcmLibrary", (String)("PushRegistrationService: GCM Registration Token: " + token));
        }
        GcmHelper.getInstance().tokenUpdated(this.getApplicationContext(), token);
        return token;
    }
}

