/*
 * Decompiled with CFR 0.152.
 */
package com.gcm.client;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import com.gcm.client.RegistrationIntentService;
import com.google.android.gms.common.GoogleApiAvailability;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.json.JSONArray;
import org.json.JSONException;

public final class GcmHelper {
    public static final String TAG = "GcmLibrary";
    public static boolean DEBUG_ENABLED = false;
    private static GcmHelper _INSTANCE;
    private ArrayList<String> topics;
    private String pushToken;
    private ConcurrentLinkedQueue<GcmMessageListener> messageReceivedCallbacks;
    private ConcurrentLinkedQueue<GcmRegistrationListener> registrationCallbacks;
    private String senderID;
    final String PREF_NAME = "pref_gcm";
    private final String PREF_KEY_TOKEN = "token";
    private final String PREF_KEY_SUBSCRIPTION = "subscribed";
    private boolean initialized = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GcmHelper getInstance() {
        Class<GcmHelper> clazz = GcmHelper.class;
        synchronized (GcmHelper.class) {
            if (null == _INSTANCE) {
                _INSTANCE = new GcmHelper();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return _INSTANCE;
        }
    }

    private GcmHelper() {
    }

    public synchronized void init(@NonNull Context context) {
        SharedPreferences localPref;
        block10: {
            String subscription;
            if (!GcmHelper.isGooglePlayservicesAvailable(context)) {
                throw new IllegalArgumentException("Not using the recommended Play Services version");
            }
            if (TextUtils.isEmpty((CharSequence)this.senderID)) {
                int id = context.getResources().getIdentifier("gcm_authorized_entity", "string", context.getPackageName());
                this.senderID = context.getResources().getString(id);
            }
            if (TextUtils.isEmpty((CharSequence)this.senderID)) {
                throw new IllegalArgumentException("No SenderId provided!! Cannot instantiate");
            }
            localPref = this.getSharedPreference(context);
            if (localPref.contains("subscribed") && !TextUtils.isEmpty((CharSequence)(subscription = localPref.getString("subscribed", null)))) {
                try {
                    JSONArray array = new JSONArray(subscription);
                    int length = array.length();
                    this.topics = new ArrayList();
                    for (int i = 0; i < length; ++i) {
                        this.topics.add(array.getString(i));
                    }
                }
                catch (JSONException ignored) {
                    if (!DEBUG_ENABLED) break block10;
                    Log.e((String)TAG, (String)"init: while processing subscription list", (Throwable)ignored);
                }
            }
        }
        boolean registrationReq = true;
        if (localPref.contains("token")) {
            this.pushToken = localPref.getString("token", null);
            if (!TextUtils.isEmpty((CharSequence)this.pushToken)) {
                registrationReq = false;
            }
        }
        if (registrationReq) {
            Intent registration = new Intent(context, RegistrationIntentService.class);
            registration.setAction("com.gcm.client.REGISTER");
            context.startService(registration);
        }
        DEBUG_ENABLED = 0 != (context.getApplicationInfo().flags & 2);
        this.initialized = true;
    }

    private SharedPreferences getSharedPreference(@NonNull Context context) {
        return context.getSharedPreferences("pref_gcm", 0);
    }

    private void storedPushToken(@NonNull Context context, @NonNull String token) {
        SharedPreferences pref = this.getSharedPreference(context);
        pref.edit().putString("token", token).apply();
    }

    private void saveSubscibedTopics(@NonNull Context context) {
        if (null == this.topics || this.topics.isEmpty()) {
            return;
        }
        SharedPreferences pref = this.getSharedPreference(context);
        JSONArray subscription = new JSONArray(this.topics);
        pref.edit().putString("subscribed", subscription.toString()).apply();
    }

    private static boolean isGooglePlayservicesAvailable(@NonNull Context context) {
        int status = GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(context);
        return status == 0;
    }

    public ArrayList<String> getSubscribedTopics() {
        return this.topics;
    }

    public boolean subscribeTopic(@NonNull Context context, @NonNull String[] newTopics) {
        if (!this.initialized) {
            this.init(context);
        }
        if (newTopics.length == 0) {
            return false;
        }
        if (null == this.topics) {
            this.topics = new ArrayList();
        }
        for (String topic : newTopics) {
            if (this.topics.contains(topic)) {
                return false;
            }
            this.topics.add(topic);
        }
        this.saveSubscibedTopics(context);
        Intent intent = new Intent(context, RegistrationIntentService.class);
        intent.setAction("com.gcm.client.UNSUBSCRIBE");
        intent.putExtra("topiclist", newTopics);
        context.startService(intent);
        return true;
    }

    public boolean unSubscribeTopic(@NonNull Context context, @NonNull String[] removeTopics) {
        if (!this.initialized) {
            this.init(context);
        }
        if (removeTopics.length == 0) {
            return false;
        }
        for (String topic : removeTopics) {
            this.topics.remove(topic);
        }
        Intent intent = new Intent(context, RegistrationIntentService.class);
        intent.setAction("com.gcm.client.UNSUBSCRIBE");
        intent.putExtra("topiclist", removeTopics);
        context.startService(intent);
        return true;
    }

    public String getAuthorizedEntity() {
        return this.senderID;
    }

    public GcmHelper setAuthorizedEntity(@NonNull String senderID) {
        this.senderID = senderID;
        return this;
    }

    public synchronized String getPushToken(Context context) {
        if (!this.initialized) {
            this.init(context);
        }
        return this.pushToken;
    }

    public synchronized GcmHelper addRegistrationCallback(@NonNull Context context, @NonNull GcmRegistrationListener registrationListener, boolean sticky) {
        if (null == this.registrationCallbacks) {
            this.registrationCallbacks = new ConcurrentLinkedQueue();
        }
        this.registrationCallbacks.add(registrationListener);
        if (sticky && !TextUtils.isEmpty((CharSequence)this.pushToken)) {
            registrationListener.onTokenAvailable(context, this.pushToken, false);
        }
        return this;
    }

    public synchronized GcmHelper addOnMessageReceivedCallback(@NonNull GcmMessageListener messageReceivedListener) {
        if (null == this.messageReceivedCallbacks) {
            this.messageReceivedCallbacks = new ConcurrentLinkedQueue();
        }
        this.messageReceivedCallbacks.add(messageReceivedListener);
        return this;
    }

    synchronized void tokenUpdated(Context context, String pushToken) {
        if (!TextUtils.isEmpty((CharSequence)pushToken) && !pushToken.equals(this.pushToken)) {
            this.storedPushToken(context, pushToken);
            this.pushToken = pushToken;
            if (null != this.registrationCallbacks && !this.registrationCallbacks.isEmpty()) {
                for (GcmRegistrationListener registrationListener : this.registrationCallbacks) {
                    try {
                        registrationListener.onTokenAvailable(context, pushToken, true);
                    }
                    catch (Exception e) {
                        if (!DEBUG_ENABLED) continue;
                        Log.e((String)TAG, (String)"tokenUpdated:", (Throwable)e);
                    }
                }
            }
        } else if (DEBUG_ENABLED) {
            Log.d((String)TAG, (String)" No listeners registered for token refresh");
        }
    }

    public synchronized void deleteToken(Context context) {
        if (!TextUtils.isEmpty((CharSequence)this.pushToken)) {
            Intent registration = new Intent(context, RegistrationIntentService.class);
            registration.setAction("com.gcm.client.UNREGISTER");
            context.startService(registration);
            SharedPreferences pref = this.getSharedPreference(context);
            pref.edit().remove("token").apply();
        }
    }

    synchronized void onTokenDeleted(Context context) {
        this.pushToken = null;
        if (null != this.registrationCallbacks && !this.registrationCallbacks.isEmpty()) {
            for (GcmRegistrationListener registrationListener : this.registrationCallbacks) {
                try {
                    registrationListener.onTokenDeleted(context);
                }
                catch (Exception e) {
                    if (!DEBUG_ENABLED) continue;
                    Log.e((String)TAG, (String)"tokenUpdated:", (Throwable)e);
                }
            }
        }
    }

    synchronized void messageReceived(Context context, String from, Bundle data) {
        if (null != this.messageReceivedCallbacks && !this.messageReceivedCallbacks.isEmpty()) {
            for (GcmMessageListener messageListener : this.messageReceivedCallbacks) {
                try {
                    if (!messageListener.canHandleMessage(data)) continue;
                    messageListener.onMessageReceived(context, from, data);
                }
                catch (Exception e) {
                    if (!DEBUG_ENABLED) continue;
                    Log.e((String)TAG, (String)"messageReceived", (Throwable)e);
                }
            }
        } else if (DEBUG_ENABLED) {
            Log.d((String)TAG, (String)" No listeners registered for message callback");
        }
    }

    static void printBundle(Bundle data) {
        block5: {
            try {
                if (null == data) {
                    Log.d((String)TAG, (String)"printBundle:No extras to log");
                    return;
                }
                Set ketSet = data.keySet();
                if (null == ketSet || ketSet.isEmpty()) {
                    return;
                }
                Log.d((String)TAG, (String)"------Start of bundle extras------");
                for (String key : ketSet) {
                    Object obj = data.get(key);
                    if (null == obj) continue;
                    Log.d((String)TAG, (String)("[ " + key + " = " + obj.toString() + " ]"));
                }
                Log.d((String)TAG, (String)"-------End of bundle extras-------");
            }
            catch (Exception e) {
                if (!DEBUG_ENABLED) break block5;
                Log.e((String)TAG, (String)"printBundle", (Throwable)e);
            }
        }
    }

    public static interface GcmMessageListener {
        public void onMessageReceived(Context var1, String var2, Bundle var3);

        public boolean canHandleMessage(Bundle var1);
    }

    public static interface GcmRegistrationListener {
        public void onTokenAvailable(Context var1, String var2, boolean var3);

        public void onTokenDeleted(Context var1);
    }
}

