package ir.najva.najvasdk.reactnativeplugin;


import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.najva.sdk.Najva;
import com.najva.sdk.NajvaJsonDataListener;
import com.najva.sdk.UserSubscriptionListener;


import javax.annotation.Nonnull;

public class InitializeModule  extends ReactContextBaseJavaModule {

    private static final String HANDLER_EVENT_NAME = "userHandler";
    private static final String DATA_EVENT_NAME = "data";

    private ReactApplicationContext reactContext;

    public InitializeModule(@Nonnull ReactApplicationContext reactContext) {
        super(reactContext);

        this.reactContext = reactContext;
    }

    @Nonnull
    @Override
    public String getName() {
        return "NajvaModule";
    }

    @ReactMethod
    public void initializeNajva(){
        Najva.initialize(getCurrentActivity());

        Najva.setUserSubscriptionListener(new UserSubscriptionListener() {
            @Override
            public void onUserSubscribed(String token) {
                reactContext.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class)
                        .emit(HANDLER_EVENT_NAME,token);
            }
        });

        Najva.setNajvaJsonDataListener(new NajvaJsonDataListener() {
            @Override
            public void onReceiveJson(String jsonString) {
                reactContext.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class)
                        .emit(DATA_EVENT_NAME,jsonString);
            }
        });
        Najva.getCachedJsonData(reactContext);
    }
    @ReactMethod
    public void getSubscribedToken(Callback callback){
        callback.invoke(Najva.getSubscribedToken(reactContext));
    }
}
