package com.najva.sdk.core.utils;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

public class WriterThread extends Thread {
    private final String tag;
    private final String message;
    private final String type;
    private int currentIndex;

    public WriterThread(String tag, String message, String type, int currentIndex){

        this.tag = tag;
        this.message = message;
        this.type = type;
        this.currentIndex = currentIndex;
    }

    @Override
    public void run() {
        Date currentDate = new Date(System.currentTimeMillis());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        String content = "\n" + dateFormat.format(currentDate) + " - " + type + "/" + tag + ": " + message;
        if (tag.length() < Logger.MAX_TAG_LENGTH || message.length() < Logger.MAX_MSG_LENGTH) {
            content = fillWithSpace(tag, message, content);
        }
        FileManager.appendToRandomAccessFile(Logger.getLoggerFilePath(), content, currentIndex, Logger.MAX_LINE_LENGTH);
    }
    private static String fillWithSpace(String TAG, String msg, String content) {
        int constantsLength = 30;
        int lineLength = TAG.length() + msg.length() + constantsLength;
        char[] spaceChars = new char[Logger.MAX_LINE_LENGTH - lineLength - 1];
        char space = ' ';
        Arrays.fill(spaceChars, space);
        content = content.concat(new String(spaceChars));
        return content;
    }
}
