package com.najva.sdk.runnables;

import android.content.Context;
import android.content.Intent;

import com.najva.sdk.Najva;
import com.najva.sdk.NajvaClient;
import com.najva.sdk.NotificationClickListener;
import com.najva.sdk.NajvaClientReceiver;
import com.najva.sdk.NajvaRunnable;
import com.najva.sdk.core.utils.StaticFields;

public class ClickReceiverHandler implements NajvaRunnable {

    public static void sendBroadcast(Context context, String uuid) {
        Intent sendIntent = new Intent(NajvaClientReceiver.ACTION);
        sendIntent.putExtra(StaticFields.ACTION, StaticFields.EVENT_CLICK);
        sendIntent.putExtra(StaticFields.UUID, uuid);
        context.sendBroadcast(sendIntent);
    }

    @Override
    public void run(Intent data) {
        if (NajvaClient.configuration.getNotificationClickListener() != null) {
            NajvaClient.configuration.getNotificationClickListener()
                    .onClickNotification(data.getStringExtra(StaticFields.UUID));
        }
    }
}
