package com.najva.sdk.receivers;

import android.annotation.SuppressLint;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;

import com.najva.sdk.push_notification.service.NajvaMessagingService;

public class BootUpReceiver extends BroadcastReceiver {
    int interval = 1000 * 60 * 60; // one hour

    @SuppressLint("UnsafeProtectedBroadcastReceiver")
    @Override
    public void onReceive(Context context, Intent intent) {
        AlarmManager am = (AlarmManager) context.getSystemService(Context.ALARM_SERVICE);
        PendingIntent pi = PendingIntent.getService(
                context,
                0,
                new Intent(context, NajvaMessagingService.class),
                PendingIntent.FLAG_UPDATE_CURRENT
        );
        am.setInexactRepeating(
                AlarmManager.RTC_WAKEUP,
                System.currentTimeMillis() + 1000, interval,
                pi
        );
    }
}