package com.najva.sdk.core.utils;

import android.util.Log;

import com.najva.sdk.BuildConfig;


public class Logger {
    static int MAX_INDEX = 1000;
    static int MAX_TAG_LENGTH = 70;
    static int MAX_MSG_LENGTH = 400;
    static int MAX_LINE_LENGTH = 500;
    static String loggerFilePath;
    static String indexFilePath;
    public static boolean isDebug = true;
    public static boolean logEnabled = true;

    public static void v(String TAG, String msg) {
        if (BuildConfig.DEBUG == isDebug) {
            Log.v(TAG, msg);
        }
        if (logEnabled)
            writeToFile(TAG, msg, "V");
    }

    public static void d(String TAG, String msg) {
        if (BuildConfig.DEBUG == isDebug) {
            Log.d(TAG, msg);
        }
        if (logEnabled)
            writeToFile(TAG, msg, "D");
    }

    public static void i(String TAG, String msg) {
        if (BuildConfig.DEBUG == isDebug) {
            Log.i(TAG, msg);
        }
        if (logEnabled)
            writeToFile(TAG, msg, "I");
    }

    public static void e(String TAG, String msg) {
        if (BuildConfig.DEBUG == isDebug) {
            Log.e(TAG, msg);
        }
        if (logEnabled)
            writeToFile(TAG, msg, "E");
    }

    public static void w(String TAG, String msg) {
        if (BuildConfig.DEBUG == isDebug) {
            Log.w(TAG, msg);
        }
        if (logEnabled)
            writeToFile(TAG, msg, "W");
    }

    private static void setLoggerIndex(String filePath, int index) {
        if (indexFilePath == null) return;
        index = resetIndex(index);
        if (logEnabled)
            FileManager.writeToFile(filePath, "" + index);
    }

    private static int resetIndex(int index) {
        if (index == MAX_INDEX) {
            index = 0;
        }
        return index;
    }

    private static int getLoggerIndex(String filePath) {
        String index = FileManager.readFromFile(filePath);
        if (index == null || index.equalsIgnoreCase("")) {
            return 0;
        } else {
            try {
                return Integer.parseInt(index);
            } catch (Exception e) {
                return 0;
            }
        }
    }

    private static void writeToFile(String TAG, final String msg, final String type) {
        try {
            if (loggerFilePath == null) return;
            if (indexFilePath == null) return;
            final String tag = TAG.length() > MAX_TAG_LENGTH ? TAG.substring(0, MAX_TAG_LENGTH) : TAG;
            final String message = msg.length() > MAX_MSG_LENGTH ? msg.substring(0, MAX_MSG_LENGTH - 1) : msg;
            int currentIndex = getLoggerIndex(indexFilePath);

            new WriterThread(tag, message, type, currentIndex).start();

            setLoggerIndex(indexFilePath, currentIndex + 1);
        } catch (Exception ignored){}
    }


    public static String getLoggerFilePath() {
        return loggerFilePath;
    }

    public static void setLoggerFilePath(String filePath) {
        loggerFilePath = filePath;
    }

    public static String getIndexFilePath() {
        return indexFilePath;
    }

    public static void setIndexFilePath(String indexFilePath) {
        Logger.indexFilePath = indexFilePath;
    }
}
