package com.najva.sdk.push_notification;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Looper;

import androidx.annotation.NonNull;

import com.google.android.gms.tasks.OnSuccessListener;
import com.google.firebase.FirebaseApp;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.InstanceIdResult;
import com.google.firebase.messaging.RemoteMessage;
import com.najva.sdk.ClientMetaData;
import com.najva.sdk.Najva;
import com.najva.sdk.NajvaClient;
import com.najva.sdk.campaign.CampaignController;
import com.najva.sdk.campaign.CampaignControllerImpl;
import com.najva.sdk.core.utils.FileManager;
import com.najva.sdk.core.utils.Logger;
import com.najva.sdk.core.utils.Parameter;
import com.najva.sdk.core.utils.StaticFields;
import com.najva.sdk.location.LocationControllerImpl;


import java.util.Map;

public class NajvaPushNotificationHandler {
    private static final String TAG = "NajvaPushNotifHandler";

    public static void handleMessage(@NonNull final Context context, @NonNull RemoteMessage remoteMessage) {
        NotificationUtils notificationUtils = NotificationUtils.getInstance();
        sendNotification(context, remoteMessage, notificationUtils);
    }

    // for better testing no item should be initialized during test so we have to take them as parameters
    public static void sendNotification(@NonNull final Context context, @NonNull final RemoteMessage remoteMessage,
                                        @NonNull NotificationUtils notificationUtils) {
        String messageId = remoteMessage.getMessageId();
        final Map<String, String> data = remoteMessage.getData();
        Logger.i(TAG, "handling new notification");

        if (notificationUtils.isNajvaMessage(context, remoteMessage)) {
            assert messageId != null;
            Logger.d(TAG, "sendNotification>>>simpleNotification: " + data.toString());

            NotificationHandler.handle(context, data, messageId, notificationUtils);
            notificationUtils.broadcastNajvaNotification(context, remoteMessage);
        }
    }

    public static void handleNewToken(@NonNull final Context context) {
        Logger.i("PushNotification", "new token received");
        if (!NajvaClient.configuration.isFirebaseEnabled() && !NajvaClient.najvaDefault) {
            FirebaseInstanceId
                    .getInstance(FirebaseApp.getInstance(StaticFields.NAJVA))
                    .getInstanceId()
                    .addOnSuccessListener(new OnSuccessListener<InstanceIdResult>() {
                        @Override
                        public void onSuccess(InstanceIdResult instanceIdResult) {
                            sendTokenToServer(context, instanceIdResult.getToken());
                        }
                    });
        } else {
            FirebaseInstanceId
                    .getInstance()
                    .getInstanceId()
                    .addOnSuccessListener(new OnSuccessListener<InstanceIdResult>() {
                        @Override
                        public void onSuccess(InstanceIdResult instanceIdResult) {
                            sendTokenToServer(context, instanceIdResult.getToken());
                        }
                    });
        }

    }

    private static void sendTokenToServer(Context context, String token) {
        Logger.d("PushNotificationHandler", "new token: " + token);
        String lastToken = FileManager.readFromFile(context, Parameter.FIREBASE_TOKEN.getValue());
        if (lastToken != null && lastToken.equals(token)) return;

        ClientMetaData.setToken(token);
        CampaignController campaignController = new CampaignControllerImpl(
                context,
                new LocationControllerImpl(context),
                ClientMetaData.getParams()
        );
        campaignController.load();
    }

    public static boolean isNajvaMessage(@NonNull Context context, RemoteMessage remoteMessage) {
        return NotificationUtils.getInstance().isNajvaMessage(context, remoteMessage);
    }


}
