package com.najva.sdk;

import androidx.annotation.DrawableRes;

import com.najva.sdk.core.utils.StaticFields;

public class NajvaConfiguration {
    private boolean pushNotificationsEnabled = true;
    private boolean locationEnabled = false;
    private boolean firebaseEnabled = false;

    private String lowPriorityChannel = StaticFields.CHANNEL_ID_LOW_PRIORITY;
    private String highPriorityChannel = StaticFields.CHANNEL_ID_HIGH_PRIORITY;

    private UserSubscriptionListener userSubscriptionListener = null;
    private NotificationReceiveListener receiveNotificationListener = null;
    private NotificationClickListener notificationClickListener = null;
    private @DrawableRes
    int notificationSmallIcon = R.drawable.ic_notification_icon;

    public void enableLocation() {
        locationEnabled = true;
    }

    public void disableLocation() {
        locationEnabled = false;
    }

    public boolean isFirebaseEnabled() {
        return firebaseEnabled;
    }

    public void setFirebaseEnabled(boolean firebaseEnabled) {
        this.firebaseEnabled = firebaseEnabled;
    }

    public void setHighPriorityChannel(String highPriorityChannel) {
        this.highPriorityChannel = highPriorityChannel;
    }

    public String getHighPriorityChannel() {
        return highPriorityChannel;
    }

    public void setLowPriorityChannel(String lowPriorityChannel) {
        this.lowPriorityChannel = lowPriorityChannel;
    }

    public String getLowPriorityChannel() {
        return lowPriorityChannel;
    }

    boolean isLocationEnabled() {
        return locationEnabled;
    }

    boolean isPushNotificationsEnabled() {
        return pushNotificationsEnabled;
    }

    public void setUserSubscriptionListener(UserSubscriptionListener userSubscriptionListener) {
        this.userSubscriptionListener = userSubscriptionListener;
    }

    public UserSubscriptionListener getUserSubscriptionListener() {
        return userSubscriptionListener;
    }

    public boolean isPushNotificationEnabled() {
        return pushNotificationsEnabled;
    }

    public int getNotificationSmallIcon() {
        return notificationSmallIcon;
    }

    public void setNotificationSmallIcon(@DrawableRes int id) {
        this.notificationSmallIcon = id;
    }

    public NotificationReceiveListener getReceiveNotificationListener() {
        return receiveNotificationListener;
    }

    public void setReceiveNotificationListener(NotificationReceiveListener receiveNotificationListener) {
        this.receiveNotificationListener = receiveNotificationListener;
    }

    public NotificationClickListener getNotificationClickListener() {
        return notificationClickListener;
    }

    public void setNotificationClickListener(NotificationClickListener notificationClickListener) {
        this.notificationClickListener = notificationClickListener;
    }

    @Override
    public String toString() {
        return "NajvaConfiguration{" +
                "pushNotificationsEnabled=" + pushNotificationsEnabled +
                ", locationEnabled=" + locationEnabled +
                ", firebaseEnabled=" + firebaseEnabled +
                ", lowPriorityChannel='" + lowPriorityChannel + '\'' +
                ", highPriorityChannel='" + highPriorityChannel + '\'' +
                ", userSubscriptionListener=" + userSubscriptionListener +
                ", receiveNotificationListener=" + receiveNotificationListener +
                ", notificationClickListener=" + notificationClickListener +
                ", notificationSmallIcon=" + notificationSmallIcon +
                '}';
    }
}
