package com.najva.sdk.utils;

import android.content.Context;
import android.content.pm.PackageManager;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;


import com.google.android.gms.common.internal.Preconditions;

import java.util.List;


/**
 * A utility class for related device stuff
 */
public class DeviceUtils {

    private DeviceUtils() {}

    /**
     * A helper method for checking a permission is granted or not.
     * In android marshmallow and post-marshmallow, you must grant some permission manually
     * @param context android {@link Context}
     * @param permission desired permission
     * @return true if permission granted
     */
    public static boolean isPermissionGranted(@NonNull final Context context,
                                              @NonNull final String permission) {
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(permission);

        return ContextCompat.checkSelfPermission(context, permission) ==
                PackageManager.PERMISSION_GRANTED;
    }
}
