package com.najva.sdk;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.util.Log;

import com.najva.sdk.core.utils.StaticFields;

import java.util.Map;

public class NajvaClientReceiver extends BroadcastReceiver {

    public static final String ACTION = "com.najva.sdk.NajvaCientReceiver.ACTION";

    private Map<String, NajvaRunnable> actions;

    NajvaClientReceiver(Map<String,NajvaRunnable> actions){

        this.actions = actions;
    }

    @Override
    public void onReceive(Context context, Intent intent) {
        Log.d("NajvaClientReceiver", "onReceive: ");
        String key = intent.getStringExtra(StaticFields.ACTION);
        if (actions.containsKey(key)){
            actions.get(key).run(intent);
        }
    }
}
