package com.najva.sdk.core.utils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.RequestFuture;


import java.util.HashMap;
import java.util.Map;

//TODO delete this class and use MetaRequest instead
public class MetaFormRequest extends MetaRequest {

    private static final String TAG = "MetaFormRequest";

    public MetaFormRequest(int method, String url, Response.Listener<String> listener, @Nullable Response.ErrorListener errorListener) {
        super(method, url, listener, errorListener);
    }


    public static class Builder implements IBuilder<MetaFormRequest> {
        private String url;
        private int method = Method.GET;
        private Response.Listener<String> responseListener = new Response.Listener<String>() {
            @Override
            public void onResponse(String response) {
                Logger.i(TAG, "no response listener.");
            }
        };
        private Response.ErrorListener errorListener = new Response.ErrorListener() {
            @Override
            public void onErrorResponse(VolleyError error) {
                Logger.i(TAG, "no error listener.");
                Logger.d(TAG, "error: " + error.getMessage());

            }
        };
        private Map<String, String> params = new HashMap<>();
        private Map<String, String> headers = new HashMap<>();
        private CookieManager manager;
        private boolean async;

        public Builder setUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder setResponseListener(@NonNull Response.Listener<String> listener) {
            this.responseListener = listener;
            return this;
        }

        public Builder setErrorListener(@NonNull Response.ErrorListener listener) {
            this.errorListener = listener;
            return this;
        }

        public Builder addHeader(@NonNull String key, @NonNull String value) {
            headers.put(key, value);
            return this;
        }

        public Builder addParam(@NonNull String key,@NonNull String value) {
            params.put(key, value);
            return this;
        }

        public Builder setMethod(int method) {
            this.method = method;
            return this;
        }

        public Builder setCookieManager(@NonNull CookieManager manager) {
            this.manager = manager;
            return this;
        }


        public Builder setParams(@NonNull Map<String, String> map) {
            this.params.putAll(map);
            return this;
        }

        public Builder setAsync(boolean async) {
            this.async = async;

            return this;
        }

        @NonNull
        public MetaFormRequest build() {
            if (async) {
                return buildAsyncRequest();
            }
            RequestFuture<String> future = RequestFuture.newFuture();
            MetaFormRequest request = new MetaFormRequest(method, url, future, errorListener);
            request.setFuture(future);
            for (String key : headers.keySet()) {
                request.addHeader(key, headers.get(key));
            }
            for (String key : params.keySet()) {
                request.addPostParams(key, params.get(key));
            }
            if (manager == null) {
                Logger.d(TAG, "CookieManager is null");
            }
            request.setShouldCache(false);
            request.setCookieManager(manager);
            return request;
        }

        @NonNull
        private MetaFormRequest buildAsyncRequest() {
            MetaFormRequest request = new MetaFormRequest(method, url, responseListener, errorListener);
            for (String key : headers.keySet()) {
                request.addHeader(key, headers.get(key));
            }
            for (String key : params.keySet()) {
                request.addPostParams(key, params.get(key));
            }
            if (manager == null) {
                Logger.d(TAG, "CookieManager is null");
            }

            request.setShouldCache(false);
            request.setCookieManager(manager);
            return request;
        }

        public Builder setHeaders(@NonNull Map<String, String> headers) {
            this.headers.putAll(headers);
            return this;
        }
    }

}
